/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.safe.util;

import com.abasecode.opencode.base.code.CodeResult;
import com.abasecode.opencode.base.safe.SafeResult;
import com.abasecode.opencode.base.safe.util.CodeAesUtils;
import com.abasecode.opencode.base.safe.util.CodeJSONUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class CodeCryptUtils {
    private static String encrypt2String(Map<String, Object> map, String key, String iv) throws Exception {
        String jsonString = JSONObject.toJSONString(map);
        if (!StringUtils.isEmpty((CharSequence)jsonString)) {
            return CodeAesUtils.encrypt(jsonString, key, iv);
        }
        return null;
    }

    private static Map<String, Object> decryptString2Map(String data, String key, String iv) throws Exception {
        String jsonString = CodeAesUtils.decrypt(data, key, iv);
        JSONObject jsonObject = JSON.parseObject((String)jsonString);
        Map map = (Map)JSONObject.toJavaObject((JSON)jsonObject, Map.class);
        return map;
    }

    public static CodeResult decryptData(SafeResult result, String key, String iv) throws Exception {
        Map<String, Object> map = CodeCryptUtils.decryptString2Map(result.getData(), key, iv);
        if (map.get("sign").equals(result.getSign())) {
            map.remove("sign");
            return CodeResult.ok((String)result.getMessage(), map);
        }
        return CodeResult.error((String)"sign error!");
    }

    public static SafeResult encryptData(CodeResult result, String key, String iv, String secret) throws Exception {
        HashMap<String, Object> map;
        String json = JSONObject.toJSONString((Object)result.getData());
        if (CodeJSONUtils.hasJsonString(json)) {
            JSONObject jsonObject = JSON.parseObject((String)json);
            map = (Map)JSONObject.toJavaObject((JSON)jsonObject, Map.class);
        } else {
            map = new HashMap<String, String>();
            map.put("data", json);
        }
        String sign = CodeCryptUtils.sign(map, secret);
        map.put("sign", sign);
        String data = CodeCryptUtils.encrypt2String(map, key, iv);
        return SafeResult.ok(sign, data, result.getMessage());
    }

    public static String sign(Map<String, Object> data, String secret) throws NoSuchAlgorithmException {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            Object v;
            if ("v2sign".equals(k) || (v = data.get(k)) == null || StringUtils.isEmpty((CharSequence)v.toString())) continue;
            sb.append((String)k).append("=").append(data.get(k).toString().trim()).append("&");
        }
        sb.append("key=").append(secret);
        return CodeCryptUtils.getSha(sb.toString()).toUpperCase();
    }

    public static boolean signVerify(String sign, String data, String key, String iv) throws Exception {
        Map<String, Object> result = CodeCryptUtils.decryptString2Map(data, key, iv);
        return result.get("sign").equals(sign);
    }

    public static String getSha(String txt) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] cipherBytes = messageDigest.digest(txt.getBytes());
        String cipherStr = Hex.encodeHexString((byte[])cipherBytes);
        return cipherStr;
    }

    public static String getMd5(String txt) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] cipherBytes = messageDigest.digest(txt.getBytes());
        String cipherStr = Hex.encodeHexString((byte[])cipherBytes);
        return cipherStr;
    }
}

