/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.safe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.cert.X509Certificate;

public class CodeRsaUtils {
    private static final int KEY_SIZE = 2048;
    private static final String ALGORITHM_SHA1_RSA = "Sha1WithRSA";
    private static final String ALGORITHM_OAEP_SHA = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    private static final String RSA = "RSA";

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static RSAPrivateKey getRSAPrivateKey(KeyPair keyPair) {
        return (RSAPrivateKey)keyPair.getPrivate();
    }

    public static String getRSAPrivateKeyString(KeyPair keyPair) {
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])rsaPrivateKey.getEncoded());
    }

    public static PrivateKey getPrivateKey(RSAPrivateKey rsaPrivateKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(rsaPrivateKey.getEncoded());
        return KeyFactory.getInstance(RSA).generatePrivate(pkcs8EncodedKeySpec);
    }

    public static PrivateKey getPrivateKey(String privateString) throws Exception {
        byte[] keyBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)privateString);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey getPublicKey(RSAPublicKey rsaPublicKey) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(rsaPublicKey.getEncoded());
        return KeyFactory.getInstance(RSA).generatePublic(x509EncodedKeySpec);
    }

    public static PublicKey getPublicKey(String publicKeyString) throws Exception {
        byte[] keyBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)publicKeyString);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(keySpec);
    }

    public static RSAPublicKey getRSAPublicKey(KeyPair keyPair) {
        return (RSAPublicKey)keyPair.getPublic();
    }

    public static String getRSAPublicKeyString(KeyPair keyPair) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])rsaPublicKey.getEncoded());
    }

    public static String encrypt(String source, RSAPublicKey rsaPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, rsaPublicKey);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])cipher.doFinal(source.getBytes(StandardCharsets.UTF_8)));
    }

    public static String encrypt(String source, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, publicKey);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])cipher.doFinal(source.getBytes(StandardCharsets.UTF_8)));
    }

    public static String encrypt(String source, String rsaPublicKeyString) throws Exception {
        byte[] keyPubByte = org.apache.commons.codec.binary.Base64.decodeBase64((String)rsaPublicKeyString);
        RSAPublicKey keyPub = (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(keyPubByte));
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, keyPub);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])cipher.doFinal(source.getBytes(StandardCharsets.UTF_8)));
    }

    public static String encrypt(String source, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, privateKey);
        byte[] result = cipher.doFinal(source.getBytes(StandardCharsets.UTF_8));
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])result);
    }

    public static String encryptOAEP(String source, X509Certificate certificate) throws IllegalBlockSizeException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_OAEP_SHA);
            cipher.init(1, certificate.getPublicKey());
            byte[] data = source.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertext = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(ciphertext);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("The current Java environment does not support RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid certificates", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("The length of the original encrypted string cannot exceed 214 bytes");
        }
    }

    public static String decryptOAEP(String encString, PrivateKey privateKey) throws BadPaddingException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_OAEP_SHA);
            cipher.init(2, privateKey);
            byte[] data = Base64.getDecoder().decode(encString);
            return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("The current Java environment does not support RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid private key.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new BadPaddingException("Failed to decrypt");
        }
    }

    public static String decrypt(String encString, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, privateKey);
        byte[] result = cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64((String)encString));
        return new String(result);
    }

    public static String decrypt(String encString, RSAPrivateKey rsaPrivateKey) throws Exception {
        byte[] encStringByte = org.apache.commons.codec.binary.Base64.decodeBase64((byte[])encString.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, rsaPrivateKey);
        return new String(cipher.doFinal(encStringByte));
    }

    public static String decrypt(String encString, String rsaPrivateKeyString) throws Exception {
        byte[] encStringByte = org.apache.commons.codec.binary.Base64.decodeBase64((byte[])encString.getBytes(StandardCharsets.UTF_8));
        byte[] keyPrivateByte = org.apache.commons.codec.binary.Base64.decodeBase64((String)rsaPrivateKeyString);
        RSAPrivateKey keyPrivate = (RSAPrivateKey)KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(keyPrivateByte));
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, keyPrivate);
        return new String(cipher.doFinal(encStringByte));
    }

    public static String decrypt(String encString, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, publicKey);
        byte[] result = cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64((String)encString));
        return new String(result);
    }

    public static String sign(String source, RSAPrivateKey rsaPrivateKey) throws Exception {
        byte[] signInfo = CodeRsaUtils.signByte(source, rsaPrivateKey);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])signInfo);
    }

    public static String sign(String source, PrivateKey privateKey) throws Exception {
        byte[] signInfo = CodeRsaUtils.signByte(source, privateKey);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])signInfo);
    }

    public static byte[] signByte(String source, PrivateKey privateKey) throws Exception {
        Signature sign = Signature.getInstance(ALGORITHM_SHA1_RSA);
        sign.initSign(privateKey);
        sign.update(source.getBytes(StandardCharsets.UTF_8));
        return sign.sign();
    }

    public static boolean verifySign(String source, String sign, RSAPublicKey rsaPublicKey) throws Exception {
        return CodeRsaUtils.verifySign(source.getBytes(StandardCharsets.UTF_8), org.apache.commons.codec.binary.Base64.decodeBase64((String)sign), (PublicKey)rsaPublicKey);
    }

    public static boolean verifySign(String source, String sign, PublicKey publicKey) throws Exception {
        return CodeRsaUtils.verifySign(source.getBytes(StandardCharsets.UTF_8), org.apache.commons.codec.binary.Base64.decodeBase64((String)sign), publicKey);
    }

    public static boolean verifySign(byte[] sourceByte, byte[] signByte, PublicKey publicKey) throws Exception {
        Signature sign = Signature.getInstance(ALGORITHM_SHA1_RSA);
        sign.initVerify(publicKey);
        sign.update(sourceByte);
        return sign.verify(signByte);
    }

    public static byte[] signFileByte(File file, PrivateKey privateKey) throws Exception {
        Signature sign = Signature.getInstance(ALGORITHM_SHA1_RSA);
        sign.initSign(privateKey);
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = ((InputStream)in).read(buf)) != -1) {
                sign.update(buf, 0, len);
            }
        }
        return sign.sign();
    }

    public static String signFile(String filePath, PrivateKey privateKey) throws Exception {
        File file = new File(filePath);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])CodeRsaUtils.signFileByte(file, privateKey));
    }

    public static boolean verifyFileSign(File file, byte[] signByte, PublicKey publicKey) throws Exception {
        Signature sign = Signature.getInstance(ALGORITHM_SHA1_RSA);
        sign.initVerify(publicKey);
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = ((InputStream)in).read(buf)) != -1) {
                sign.update(buf, 0, len);
            }
        }
        return sign.verify(signByte);
    }

    public static boolean verifyFileSign(String filePath, String sign, PublicKey publicKey) throws Exception {
        byte[] signByte = org.apache.commons.codec.binary.Base64.decodeBase64((String)sign);
        File file = new File(filePath);
        return CodeRsaUtils.verifyFileSign(file, signByte, publicKey);
    }
}

