/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.DecryptError;
import com.adscore.signature.DecryptResult;
import com.adscore.signature.PhpUnpack;
import com.adscore.signature.SignatureVerifierUtils;
import java.nio.ByteBuffer;
import java.util.Map;

abstract class AbstractSymmetricCrypt {
    private Integer methodSize = 2;

    AbstractSymmetricCrypt() {
    }

    abstract byte[] decryptWithKey(ByteBuffer var1, byte[] var2) throws DecryptError;

    DecryptResult parse(ByteBuffer payload, Map<String, Integer> lengths) throws DecryptError {
        if (payload.capacity() < this.methodSize + lengths.values().stream().reduce(0, Integer::sum)) {
            throw new DecryptError("Premature data end");
        }
        int pos = this.methodSize;
        DecryptResult decryptResult = new DecryptResult();
        Map<String, Object> unpack = PhpUnpack.unpack("vmethod", SignatureVerifierUtils.substrBuffer(payload, 0, pos));
        decryptResult.setMethod(SignatureVerifierUtils.characterToInt(unpack.get("method")));
        for (Map.Entry<String, Integer> entry : lengths.entrySet()) {
            ByteBuffer bytesForKey = SignatureVerifierUtils.substrBuffer(payload, pos, entry.getValue());
            decryptResult.getByteBufferMap().put(entry.getKey(), bytesForKey);
            pos += entry.getValue().intValue();
        }
        decryptResult.setData(SignatureVerifierUtils.substrBuffer(payload, pos, null));
        return decryptResult;
    }
}

