/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.AbstractSymmetricCrypt;
import com.adscore.signature.OpenSSL;
import com.adscore.signature.OpenSSLAEAD;
import com.adscore.signature.PhpUnpack;
import com.adscore.signature.Secretbox;
import com.adscore.signature.SignatureParseError;
import com.adscore.signature.SignatureVerifierUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

class CryptFactory {
    CryptFactory() {
    }

    static AbstractSymmetricCrypt createFromPayload(ByteBuffer payload) throws SignatureParseError {
        byte[] header = SignatureVerifierUtils.substrBuffer(payload, 0, 2).array();
        return CryptFactory.createCrypt(header);
    }

    private static AbstractSymmetricCrypt createCrypt(byte[] name) throws SignatureParseError {
        if (Arrays.equals(name, PhpUnpack.pack("v", 512))) {
            return new OpenSSL();
        }
        if (Arrays.equals(name, PhpUnpack.pack("v", 513))) {
            return new OpenSSLAEAD();
        }
        if (Arrays.equals(name, PhpUnpack.pack("v", 257))) {
            return new Secretbox();
        }
        throw new SignatureParseError("Unsupported crypt class");
    }
}

