/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.VerifyError;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddressString;

class IpV6Utils {
    IpV6Utils() {
    }

    static boolean validate(String ipAddress) {
        return new IPAddressString(ipAddress).isIPv6();
    }

    static String abbreviate(String ipAddress) throws VerifyError {
        IPAddressString ip6 = new IPAddressString(ipAddress);
        if (!ip6.isIPv6()) {
            throw new VerifyError(String.format("Invalid address: %s", ipAddress));
        }
        try {
            return new IPAddressString(ipAddress).toAddress().toIPv6().toString();
        }
        catch (AddressStringException e) {
            throw new VerifyError(String.format("Invalid address: %s", ipAddress));
        }
    }
}

