/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.AbstractSymmetricCrypt;
import com.adscore.signature.CryptMethod;
import com.adscore.signature.DecryptError;
import com.adscore.signature.DecryptResult;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class OpenSSL
extends AbstractSymmetricCrypt {
    static final int METHOD = 512;
    private CryptMethod cryptMethod = CryptMethod.AES_256_CBC;

    OpenSSL() {
    }

    @Override
    byte[] decryptWithKey(ByteBuffer payload, byte[] key) throws DecryptError {
        HashMap lengths = new HashMap(){
            {
                this.put("iv", OpenSSL.this.cryptMethod.getIvLength());
            }
        };
        DecryptResult result = this.parse(payload, lengths);
        if (result.getMethod() != 512) {
            throw new DecryptError("Unrecognized payload");
        }
        return this.decode(result.getData().array(), "AES/CBC/PKCS5Padding", key, result.getByteBufferMap().get("iv").array());
    }

    private byte[] decode(byte[] input, String method, byte[] key, byte[] iv) throws DecryptError {
        try {
            Cipher cipher = Cipher.getInstance(method);
            ByteBuffer buffer = ByteBuffer.allocate(input.length);
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            buffer.put(input);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            cipher.init(2, (Key)keySpec, paramSpec);
            return cipher.doFinal(buffer.array());
        }
        catch (Exception e) {
            throw new DecryptError("Decryption OpenSSL failed " + e);
        }
    }
}

