/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.AbstractSymmetricCrypt;
import com.adscore.signature.CryptMethod;
import com.adscore.signature.DecryptError;
import com.adscore.signature.DecryptResult;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.LinkedHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class OpenSSLAEAD
extends AbstractSymmetricCrypt {
    public static final int METHOD = 513;
    private CryptMethod cryptMethod = CryptMethod.AES_256_GCM;

    OpenSSLAEAD() {
    }

    @Override
    byte[] decryptWithKey(ByteBuffer payload, byte[] key) throws DecryptError {
        LinkedHashMap lengths = new LinkedHashMap(){
            {
                this.put("iv", OpenSSLAEAD.this.cryptMethod.getIvLength());
                this.put("tag", 16);
            }
        };
        DecryptResult parse = this.parse(payload, lengths);
        return this.decode(parse.getData().array(), "AES/GCM/NoPadding", key, parse.getByteBufferMap().get("iv").array(), parse.getByteBufferMap().get("tag").array());
    }

    byte[] decode(byte[] input, String method, byte[] key, byte[] iv, byte[] tag) throws DecryptError {
        try {
            Cipher cipher = Cipher.getInstance(method);
            ByteBuffer buffer = ByteBuffer.allocate(input.length + tag.length);
            GCMParameterSpec paramSpec = new GCMParameterSpec(tag.length * 8, iv);
            buffer.put(input);
            buffer.put(tag);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            cipher.init(2, (Key)keySpec, paramSpec);
            return cipher.doFinal(buffer.array());
        }
        catch (Exception e) {
            throw new DecryptError("Decryption failed" + e);
        }
    }
}

