/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import java.util.HashMap;
import java.util.Map;

class PhpUnserializer {
    private String data;
    private int index;

    PhpUnserializer(String data) {
        this.data = data;
        this.index = 0;
    }

    Object unserialize() {
        char type = this.data.charAt(this.index);
        this.index += 2;
        switch (type) {
            case 'i': {
                return this.parseInt();
            }
            case 'd': {
                return this.parseFloat();
            }
            case 'b': {
                return this.parseBoolean();
            }
            case 's': {
                return this.parseString();
            }
            case 'a': {
                return this.parseArray();
            }
            case 'O': {
                return this.parseObject();
            }
        }
        throw new IllegalArgumentException("PhpUnserializer error. Unsupported type: " + type);
    }

    private String parseInt() {
        int semiColonIndex = this.data.indexOf(59, this.index);
        String intStr = this.data.substring(this.index, semiColonIndex);
        this.index = semiColonIndex + 1;
        return intStr;
    }

    private String parseFloat() {
        int semiColonIndex = this.data.indexOf(59, this.index);
        String floatStr = this.data.substring(this.index, semiColonIndex);
        this.index = semiColonIndex + 1;
        return floatStr;
    }

    private String parseBoolean() {
        char boolChar = this.data.charAt(this.index);
        this.index += 2;
        return boolChar == '1' ? "true" : "false";
    }

    private String parseString() {
        int colonIndex = this.data.indexOf(58, this.index);
        int length = Integer.parseInt(this.data.substring(this.index, colonIndex));
        this.index = colonIndex + 2;
        String str = this.data.substring(this.index, this.index + length);
        this.index += length + 2;
        return str;
    }

    private Map<Object, Object> parseArray() {
        int colonIndex = this.data.indexOf(58, this.index);
        int length = Integer.parseInt(this.data.substring(this.index, colonIndex));
        this.index = colonIndex + 2;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < length; ++i) {
            Object key = this.unserialize();
            Object value = this.unserialize();
            map.put(key, value);
        }
        ++this.index;
        return map;
    }

    private Map<String, Object> parseObject() {
        int colonIndex = this.data.indexOf(58, this.index);
        int classNameLength = Integer.parseInt(this.data.substring(this.index, colonIndex));
        this.index = colonIndex + 2;
        String className = this.data.substring(this.index, this.index + classNameLength);
        this.index += classNameLength + 2;
        colonIndex = this.data.indexOf(58, this.index);
        int length = Integer.parseInt(this.data.substring(this.index, colonIndex));
        this.index = colonIndex + 2;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < length; ++i) {
            String key = (String)this.unserialize();
            Object value = this.unserialize();
            fields.put(key, value);
        }
        ++this.index;
        return fields;
    }
}

