/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.AsymOpenSSL;
import com.adscore.signature.Field;
import com.adscore.signature.IpV6Utils;
import com.adscore.signature.ParseError;
import com.adscore.signature.PhpUnpack;
import com.adscore.signature.Signature4VerificationResult;
import com.adscore.signature.SignatureParseError;
import com.adscore.signature.SignatureVerifierUtils;
import com.adscore.signature.StructParseError;
import com.adscore.signature.VerifierConstant;
import com.adscore.signature.VerifyError;
import com.adscore.signature.VersionError;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

class Signature4VerifierService {
    private static final HashMap<Integer, Field> fieldIds = new HashMap<Integer, Field>(){
        {
            this.put(0, new Field("requestTime", "ulong"));
            this.put(1, new Field("signatureTime", "ulong"));
            this.put(64, new Field(null, "ushort"));
            this.put(128, new Field("masterSignType", "uchar"));
            this.put(129, new Field("customerSignType", "uchar"));
            this.put(192, new Field("masterToken", "string"));
            this.put(193, new Field("customerToken", "string"));
            this.put(194, new Field("masterTokenV6", "string"));
            this.put(195, new Field("customerTokenV6", "string"));
        }
    };

    Signature4VerifierService() {
    }

    Signature4VerificationResult verifySignature(String signature, String userAgent, String signRole, String key, boolean isKeyBase64Encoded, Integer expiry, String[] ipAddresses) throws VerifyError, VersionError, ParseError {
        Map<String, Object> data;
        Signature4VerificationResult validationResult = new Signature4VerificationResult();
        try {
            data = this.parse4(signature);
        }
        catch (VersionError e) {
            data = this.parse3(signature);
        }
        String signRoleToken = (String)data.get(signRole + "Token");
        if (signRoleToken == null || signRoleToken.length() == 0) {
            throw new VerifyError("sign role signature mismatch");
        }
        int signType = SignatureVerifierUtils.characterToInt(data.get(signRole + "SignType"));
        for (String ipAddress : ipAddresses) {
            String token;
            if (ipAddress == null || ipAddress.length() == 0) continue;
            if (IpV6Utils.validate(ipAddress)) {
                if (!data.containsKey(signRole + "TokenV6")) continue;
                token = (String)data.get(signRole + "TokenV6");
                ipAddress = IpV6Utils.abbreviate(ipAddress);
            } else {
                if (!data.containsKey(signRole + "Token")) continue;
                token = (String)data.get(signRole + "Token");
            }
            int signatureTime = SignatureVerifierUtils.characterToInt(data.get("signatureTime"));
            int requestTime = SignatureVerifierUtils.characterToInt(data.get("requestTime"));
            for (String result : VerifierConstant.results.keySet()) {
                boolean isValid = false;
                String signatureBase = this.getBase(result, requestTime, signatureTime, ipAddress, userAgent);
                switch (signType) {
                    case 1: {
                        boolean isHashedDataEqualToToken = SignatureVerifierUtils.encode(isKeyBase64Encoded ? SignatureVerifierUtils.keyDecode(key) : key, signatureBase).equals(token);
                        if (!isHashedDataEqualToToken) break;
                        if (this.isExpired(expiry, signatureTime, requestTime)) {
                            validationResult.setExpired(true);
                            return validationResult;
                        }
                        isValid = true;
                        break;
                    }
                    case 2: {
                        if (!this.verifyData(signatureBase, token, key, isKeyBase64Encoded, "SHA256withECDSA")) break;
                        isValid = true;
                        break;
                    }
                    default: {
                        throw new VerifyError("unrecognized signature");
                    }
                }
                if (!isValid) continue;
                validationResult.setScore(Integer.valueOf(result));
                validationResult.setVerdict(VerifierConstant.results.get(result));
                validationResult.setIpAddress(ipAddress);
                validationResult.setRequestTime(Integer.parseInt(String.valueOf(data.get("requestTime"))));
                validationResult.setSignatureTime(Integer.parseInt(String.valueOf(data.get("signatureTime"))));
                return validationResult;
            }
        }
        throw new StructParseError("no verdict");
    }

    private boolean verifyData(String data, String signature, String key, boolean isKeyBase64Encoded, String algorithm) throws VerifyError {
        AsymOpenSSL crypt = new AsymOpenSSL(algorithm);
        if (key.contains("BEGIN")) {
            key = key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        }
        if (crypt.verify(data, signature, key)) {
            return true;
        }
        throw new VerifyError("Signature verification error");
    }

    boolean isExpired(Integer expiry, int signatureTime, int requestTime) {
        if (expiry == null) {
            return false;
        }
        long currentEpochInSeconds = new Date().getTime() / 1000L;
        boolean isSignatureTimeExpired = (long)signatureTime + (long)expiry.intValue() < currentEpochInSeconds;
        boolean isRequestTimeExpired = (long)requestTime + (long)expiry.intValue() < currentEpochInSeconds;
        return isSignatureTimeExpired || isRequestTimeExpired;
    }

    String getBase(String verdict, int requestTime, int signatureTime, String ipAddress, String userAgent) {
        StringJoiner joiner = new StringJoiner("\n");
        return joiner.add(verdict).add(String.valueOf(requestTime)).add(String.valueOf(signatureTime)).add(ipAddress).add(userAgent).toString();
    }

    private Map<String, Object> parse3(String signature) throws VersionError, SignatureParseError {
        ByteBuffer signBuffer = ByteBuffer.wrap(SignatureVerifierUtils.base64Decode(signature));
        if (!"".equals(signature)) {
            throw new SignatureParseError("invalid base64 payload");
        }
        Map<String, Object> unpackResult = PhpUnpack.unpack("Cversion/NrequestTime/NsignatureTime/CmasterSignType/nmasterTokenLength", signBuffer);
        Integer version = (Integer)unpackResult.get("version");
        if (version != 3) {
            throw new VersionError("Invalid signature version");
        }
        Long timestamp = (Long)unpackResult.get("timestamp");
        if (timestamp > new Date().getTime() / 1000L) {
            throw new SignatureParseError("invalid timestamp (future time)");
        }
        Integer masterTokenLength = (Integer)unpackResult.get("masterTokenLength");
        String masterToken = this.getBytesAndAdvancePosition(signBuffer, masterTokenLength);
        unpackResult.put("masterToken", masterToken);
        int s1 = masterTokenLength;
        int s2 = masterToken.length();
        if (s1 != s2) {
            throw new SignatureParseError(String.format("master token length mismatch (%s / %s)", s1, s2));
        }
        Map<String, Object> data2 = PhpUnpack.unpack("CcustomerSignType/ncustomerTokenLength", signBuffer);
        Integer customerTokenLength = (Integer)data2.get("customerTokenLength");
        String customerToken = this.getBytesAndAdvancePosition(signBuffer, customerTokenLength);
        data2.put("customerToken", customerToken);
        s1 = customerTokenLength;
        s2 = customerToken.length();
        if (s1 != s2) {
            throw new SignatureParseError(String.format("customer token length mismatch (%s / %s)')", s1, s2));
        }
        unpackResult.putAll(data2);
        return unpackResult;
    }

    private Field fieldTypeDef(Integer fieldId, int i) {
        if (fieldIds.get(fieldId) != null) {
            return fieldIds.get(fieldId);
        }
        String resultType = fieldIds.get(fieldId & 0xC0).getType();
        String iStr = SignatureVerifierUtils.padStart(String.valueOf(i), 2, '0');
        String resultName = resultType + iStr;
        return new Field(resultName, resultType);
    }

    private Map<String, Object> parse4(String signature) throws VersionError, SignatureParseError {
        ByteBuffer signBB = ByteBuffer.wrap(SignatureVerifierUtils.base64Decode(signature));
        if ((signature = new String(SignatureVerifierUtils.base64Decode(signature), StandardCharsets.ISO_8859_1)).length() == 0) {
            throw new SignatureParseError("invalid base64 payload");
        }
        Map<String, Object> data = PhpUnpack.unpack("Cversion/CfieldNum", signBB);
        int version = SignatureVerifierUtils.characterToInt(data.get("version"));
        if (version != 4) {
            throw new VersionError("Invalid signature version");
        }
        int fieldNum = SignatureVerifierUtils.characterToInt(data.get("fieldNum"));
        block12: for (int i = 0; i < fieldNum; ++i) {
            Map<String, Object> header = PhpUnpack.unpack("CfieldId", signBB);
            if (header.entrySet().size() == 0 || !header.containsKey("fieldId")) {
                throw new SignatureParseError("premature end of signature 0x01");
            }
            Field fieldTypeDef = this.fieldTypeDef(SignatureVerifierUtils.characterToInt(header.get("fieldId")), i);
            Map<Object, Object> v = new HashMap();
            switch (fieldTypeDef.getType()) {
                case "uchar": {
                    v = PhpUnpack.unpack("Cv", signBB);
                    if (v.containsKey("v")) {
                        data.put(fieldTypeDef.getName(), v.get("v"));
                        continue block12;
                    }
                    throw new SignatureParseError("premature end of signature 0x02");
                }
                case "ushort": {
                    v = PhpUnpack.unpack("nv", signBB);
                    if (v.containsKey("v")) {
                        data.put(fieldTypeDef.getName(), v.get("v"));
                        continue block12;
                    }
                    throw new SignatureParseError("premature end of signature 0x03");
                }
                case "ulong": {
                    v = PhpUnpack.unpack("Nv", signBB);
                    if (v.containsKey("v")) {
                        data.put(fieldTypeDef.getName(), v.get("v"));
                        continue block12;
                    }
                    throw new SignatureParseError("premature end of signature 0x04");
                }
                case "string": {
                    Map<String, Object> l = PhpUnpack.unpack("nl", signBB);
                    if (!l.containsKey("l")) {
                        throw new SignatureParseError("premature end of signature 0x05");
                    }
                    if ((SignatureVerifierUtils.characterToInt(l.get("l")) & 0x8000) > 0) {
                        int newl = SignatureVerifierUtils.characterToInt(l.get("l")) & 0xFF;
                        l.put("l", newl);
                    }
                    int lLength = SignatureVerifierUtils.characterToInt(l.get("l"));
                    String newV = this.getBytesAndAdvancePosition(signBB, lLength);
                    v.put("v", newV);
                    data.put(fieldTypeDef.getName(), newV);
                    if (newV.getBytes(StandardCharsets.ISO_8859_1).length == lLength) continue block12;
                    throw new SignatureParseError("premature end of signature 0x06");
                }
                default: {
                    throw new SignatureParseError("unsupported variable type");
                }
            }
        }
        data.remove(String.valueOf(fieldNum));
        return data;
    }

    private String getBytesAndAdvancePosition(ByteBuffer buffer, int numBytes) {
        int currentPosition = buffer.position();
        int bytesToGet = Math.min(buffer.remaining(), numBytes);
        byte[] subArray = new byte[bytesToGet];
        buffer.get(subArray);
        buffer.position(currentPosition + bytesToGet);
        return new String(subArray, StandardCharsets.ISO_8859_1);
    }
}

