/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.AbstractSymmetricCrypt;
import com.adscore.signature.CryptFactory;
import com.adscore.signature.DecryptError;
import com.adscore.signature.IpV6Utils;
import com.adscore.signature.ParseError;
import com.adscore.signature.PhpUnpack;
import com.adscore.signature.Signature5ResponseMapper;
import com.adscore.signature.Signature5VerificationResult;
import com.adscore.signature.SignatureParseError;
import com.adscore.signature.SignatureVerifierUtils;
import com.adscore.signature.StructParseError;
import com.adscore.signature.StructUnpacker;
import com.adscore.signature.VerifierConstant;
import com.adscore.signature.VerifyError;
import com.adscore.signature.VersionError;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

class Signature5VerifierService {
    private final int version = 5;
    private final int headerLength = 11;

    Signature5VerifierService() {
    }

    Signature5VerificationResult createFromRequest(String signature, String userAgent, String key, List<String> ipAddresses) throws ParseError, VersionError, VerifyError {
        Map<String, String> parsed = this.parse(signature, SignatureVerifierUtils.base64Decode(key));
        this.verify(parsed, ipAddresses, userAgent);
        return Signature5ResponseMapper.mapToResponse(parsed);
    }

    private Map<String, String> parse(String signature, byte[] onCryptKeyRequest) throws SignatureParseError, StructParseError, DecryptError, VersionError {
        ByteBuffer payload = ByteBuffer.wrap(SignatureVerifierUtils.base64Decode(signature));
        if (payload.capacity() <= this.headerLength) {
            throw new SignatureParseError("Malformed signature");
        }
        Map<String, Object> unpack = PhpUnpack.unpack("Cversion/nlength/Jzone_id", payload);
        int length = SignatureVerifierUtils.characterToInt(unpack.get("length"));
        long zoneId = (Long)unpack.get("zone_id");
        if ((Integer)unpack.get("version") != this.version) {
            throw new VersionError("Invalid signature version");
        }
        ByteBuffer encryptedPayload = SignatureVerifierUtils.substrBuffer(payload, this.headerLength, length);
        if (encryptedPayload.capacity() < length) {
            throw new SignatureParseError("Truncated signature payload");
        }
        Map<String, String> decryptedPayload = this.decryptPayload(encryptedPayload, onCryptKeyRequest);
        decryptedPayload.put("zone_id", Long.toString(zoneId));
        return decryptedPayload;
    }

    private Map<String, String> decryptPayload(ByteBuffer payload, byte[] key) throws SignatureParseError, StructParseError, DecryptError {
        AbstractSymmetricCrypt crypt = CryptFactory.createFromPayload(payload);
        byte[] decryptedPayload = crypt.decryptWithKey(payload, key);
        Map<String, String> fromPayload = this.createFromPayload(ByteBuffer.wrap(decryptedPayload));
        return fromPayload;
    }

    private Map<String, String> createFromPayload(ByteBuffer decryptedPayload) throws StructParseError {
        String header;
        switch (header = SignatureVerifierUtils.substr(new String(decryptedPayload.array(), StandardCharsets.UTF_8), 0, 1)) {
            case "S": 
            case "Serialize": 
            case "serialize": {
                return StructUnpacker.serializeUnpack(decryptedPayload);
            }
            case "M": 
            case "Msgpack": 
            case "msgpack": {
                return StructUnpacker.msgUnpack(decryptedPayload);
            }
            case "J": 
            case "StructJson": 
            case "json": {
                return StructUnpacker.jsonUnpack(decryptedPayload);
            }
            case "H": 
            case "StructRfc3986": 
            case "rfc3986": {
                return StructUnpacker.rfc3986Unpack(decryptedPayload);
            }
        }
        throw new StructParseError("Unsupported struct class");
    }

    private void verify(Map<String, String> parsed, List<String> ipAddresses, String userAgent) throws VerifyError {
        String matchingIp = null;
        for (String ipAddress : ipAddresses) {
            if (parsed.getOrDefault("ipv4.ip", null) != null && ipAddress.equals(parsed.get("ipv4.ip"))) {
                matchingIp = ipAddress;
                break;
            }
            if (parsed.getOrDefault("ipv6.ip", null) == null || !IpV6Utils.abbreviate(parsed.get("ipv6.ip")).equals(IpV6Utils.abbreviate(ipAddress))) continue;
            matchingIp = ipAddress;
            break;
        }
        if (matchingIp == null) {
            throw new VerifyError("Signature IP mismatch");
        }
        if (!parsed.get("b.ua").equals(userAgent)) {
            throw new VerifyError("Signature user agent mismatch");
        }
        if (!VerifierConstant.results.get(parsed.get("result")).equals(parsed.get("verdict"))) {
            throw new VerifyError("Result mismatch");
        }
    }
}

