/*
 * Decompiled with CFR 0.152.
 */
package com.adscore.signature;

import com.adscore.signature.PhpUnserializer;
import com.adscore.signature.SignatureVerifierUtils;
import com.adscore.signature.StructParseError;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessagePack;

class StructUnpacker {
    static final String SERIALIZE_HEADER = "S";
    static final String JSON_HEADER = "J";
    static final String MSG_HEADER = "M";
    static final String RFC3986_HEADER = "H";

    StructUnpacker() {
    }

    static Map<String, String> serializeUnpack(ByteBuffer buffer) throws StructParseError {
        if (SignatureVerifierUtils.strpos(new String(buffer.array(), StandardCharsets.UTF_8), SERIALIZE_HEADER, 0) != 0) {
            throw new StructParseError("Unexpected serializer type");
        }
        try {
            String payload = new String(SignatureVerifierUtils.substrBuffer(buffer, SERIALIZE_HEADER.length(), null).array(), StandardCharsets.UTF_8);
            return (Map)new PhpUnserializer(payload).unserialize();
        }
        catch (Exception e) {
            throw new StructParseError("Error parsing Serialize struct: " + e);
        }
    }

    static Map<String, String> jsonUnpack(ByteBuffer payload) throws StructParseError {
        try {
            String strPayload = new String(payload.array(), StandardCharsets.UTF_8);
            String substring = strPayload.substring(1, strPayload.length());
            return (Map)new ObjectMapper().readValue(substring, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new StructParseError("Error parsing StructJson struct: " + (Object)((Object)e));
        }
    }

    static Map<String, String> msgUnpack(ByteBuffer buffer) throws StructParseError {
        try {
            ByteBuffer slice = buffer.position(1).slice();
            String unpacked = new MessagePack.UnpackerConfig().withStringDecoderBufferSize(16384).newUnpacker(slice).unpackValue().toString();
            return (Map)new ObjectMapper().readValue(unpacked, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw new StructParseError("Error parsing MsgPack struct: " + e);
        }
    }

    static Map<String, String> rfc3986Unpack(ByteBuffer data) throws StructParseError {
        try {
            data.position(1).slice();
            String queryString = StandardCharsets.UTF_8.decode(data).toString();
            String decoded = StructUnpacker.decodeUrl(queryString);
            String[] pairs = decoded.split("&");
            HashMap<String, String> result = new HashMap<String, String>();
            for (String pair : pairs) {
                String[] keyValue = pair.split("=", 2);
                if (keyValue.length == 2) {
                    result.put(keyValue[0], keyValue[1]);
                    continue;
                }
                result.put(keyValue[0], "");
            }
            return result;
        }
        catch (Exception e) {
            throw new StructParseError("Error parsing StructRfc3986 struct: " + e);
        }
    }

    private static String decodeUrl(String encodedUrl) {
        StringBuilder decodedUrl = new StringBuilder();
        int len = encodedUrl.length();
        int i = 0;
        while (i < len) {
            char c = encodedUrl.charAt(i);
            if (c == '%') {
                if (i + 2 < len) {
                    String hex = encodedUrl.substring(i + 1, i + 3);
                    try {
                        char decodedChar = (char)Integer.parseInt(hex, 16);
                        decodedUrl.append(decodedChar);
                        i += 3;
                    }
                    catch (NumberFormatException e) {
                        decodedUrl.append(c);
                        ++i;
                    }
                    continue;
                }
                decodedUrl.append(c);
                ++i;
                continue;
            }
            decodedUrl.append(c);
            ++i;
        }
        return decodedUrl.toString();
    }
}

