/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.altom.altunitytester.AltBaseSettings;
import ro.altom.altunitytester.AltUnityObject;
import ro.altom.altunitytester.Commands.AltCallStaticMethods;
import ro.altom.altunitytester.Commands.AltCallStaticMethodsParameters;
import ro.altom.altunitytester.Commands.AltStop;
import ro.altom.altunitytester.Commands.EnableLogging;
import ro.altom.altunitytester.Commands.FindObject.AltFindObject;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjects;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsParameters;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElements;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElementsParameters;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObject;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectToNotBePresent;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWithText;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWithTextParameters;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectsParameters;
import ro.altom.altunitytester.Commands.GetPNGScreenshotCommand;
import ro.altom.altunitytester.Commands.GetServerVersionCommand;
import ro.altom.altunitytester.Commands.InputActions.AltClickScreen;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouse;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouseAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouseParameters;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipeAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltPressKey;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeyAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeyParameters;
import ro.altom.altunitytester.Commands.InputActions.AltScrollMouse;
import ro.altom.altunitytester.Commands.InputActions.AltScrollMouseParameters;
import ro.altom.altunitytester.Commands.InputActions.AltSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltSwipeAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltTapScreen;
import ro.altom.altunitytester.Commands.InputActions.AltTilt;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElement;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementByComponent;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementWhereNameContains;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElements;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementsByComponent;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementsByComponentParameters;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementsParameters;
import ro.altom.altunitytester.Commands.OldFindObject.AltFindElementsWhereNameContains;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElement;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElementParameters;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElementToNotBePresent;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElementWhereNameContains;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElementWithText;
import ro.altom.altunitytester.Commands.OldFindObject.AltWaitForElementWithTextParameters;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeleteKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeletePlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltFloatGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetCurrentScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltIntGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltLoadScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltScrollMouseAndWait;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltStringGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBe;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBeParameters;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidParamerException;
import ro.altom.altunitytester.position.Vector2;

public class AltUnityDriver {
    private static final Logger log = LoggerFactory.getLogger(AltUnityDriver.class);
    public static final String VERSION = "1.5.3";
    public static final int READ_TIMEOUT = 5000;
    private Socket socket = null;
    private PrintWriter out = null;
    private DataInputStream in = null;
    private AltBaseSettings altBaseSettings;

    public AltUnityDriver(String ip, int port) {
        this(ip, port, ";", "&", false);
    }

    public AltUnityDriver(String ip, int port, String requestSeparator, String requestEnd) {
        this(ip, port, requestSeparator, requestEnd, false);
    }

    public AltUnityDriver(String ip, int port, String requestSeparator, String requestEnd, Boolean logEnabled) {
        if (ip == null || ip.isEmpty()) {
            throw new InvalidParamerException("Provided IP address is null or empty");
        }
        try {
            log.info("Initializing connection to {}:{}", (Object)ip, (Object)port);
            this.socket = new Socket(ip, port);
            this.socket.setSoTimeout(5000);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new ConnectionException("Could not create connection to " + String.format("%s:%d", ip, port), e);
        }
        this.altBaseSettings = new AltBaseSettings(this.socket, requestSeparator, requestEnd, this.out, this.in, logEnabled);
        this.EnableLogging();
        this.GetServerVersion();
    }

    private String GetServerVersion() {
        try {
            new GetServerVersionCommand(this.altBaseSettings).Execute();
            return "Ok";
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return "Version mismatch";
        }
    }

    private void EnableLogging() {
        new EnableLogging(this.altBaseSettings).Execute();
    }

    public void stop() {
        new AltStop(this.altBaseSettings).Execute();
    }

    public String callStaticMethods(AltCallStaticMethodsParameters altCallStaticMethodsParameters) {
        return new AltCallStaticMethods(this.altBaseSettings, altCallStaticMethodsParameters).Execute();
    }

    public String callStaticMethods(String assembly, String typeName, String methodName, String parameters, String typeOfParameters) {
        AltCallStaticMethodsParameters altCallStaticMethodsParameters = new AltCallStaticMethodsParameters.Builder(typeName, methodName, parameters).withAssembly(assembly).withTypeOfParameters(typeOfParameters).build();
        return this.callStaticMethods(altCallStaticMethodsParameters);
    }

    public String callStaticMethods(String typeName, String methodName, String parameters) {
        return this.callStaticMethods("", typeName, methodName, parameters, "");
    }

    public void loadScene(String scene) {
        new AltLoadScene(this.altBaseSettings, scene).Execute();
    }

    public void deletePlayerPref() {
        new AltDeletePlayerPref(this.altBaseSettings).Execute();
    }

    public void deleteKeyPlayerPref(String keyName) {
        new AltDeleteKeyPlayerPref(this.altBaseSettings, keyName).Execute();
    }

    public void setKeyPlayerPref(String keyName, int valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public void setKeyPlayerPref(String keyName, float valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public void setKeyPlayerPref(String keyName, String valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public int getIntKeyPlayerPref(String keyname) {
        return new AltIntGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public float getFloatKeyPlayerPref(String keyname) {
        return new AltFloatGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public String getStringKeyPlayerPref(String keyname) {
        return new AltStringGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public String getCurrentScene() {
        return new AltGetCurrentScene(this.altBaseSettings).Execute();
    }

    public float getTimeScale() {
        return new AltGetTimeScale(this.altBaseSettings).Execute();
    }

    public void setTimeScale(float timeScale) {
        new AltSetTimeScale(this.altBaseSettings, timeScale).Execute();
    }

    public void swipe(int xStart, int yStart, int xEnd, int yEnd, float durationInSecs) {
        new AltSwipe(this.altBaseSettings, xStart, yStart, xEnd, yEnd, durationInSecs).Execute();
    }

    public void swipeAndWait(int xStart, int yStart, int xEnd, int yEnd, float durationInSecs) {
        new AltSwipeAndWait(this.altBaseSettings, xStart, yStart, xEnd, yEnd, durationInSecs).Execute();
    }

    public void multipointSwipe(List<Vector2> positions, float durationInSecs) {
        new AltMultiPointSwipe(this.altBaseSettings, positions, durationInSecs).Execute();
    }

    public void multipointSwipeAndWait(List<Vector2> positions, float durationInSecs) {
        new AltMultiPointSwipeAndWait(this.altBaseSettings, positions, durationInSecs).Execute();
    }

    public void holdButton(int xPosition, int yPosition, float durationInSecs) {
        this.swipe(xPosition, yPosition, xPosition, yPosition, durationInSecs);
    }

    public void holdButtonAndWait(int xPosition, int yPosition, float durationInSecs) {
        this.swipeAndWait(xPosition, yPosition, xPosition, yPosition, durationInSecs);
    }

    public AltUnityObject clickScreen(float x, float y) {
        return new AltClickScreen(this.altBaseSettings, x, y).Execute();
    }

    public void tilt(int x, int y, int z) {
        new AltTilt(this.altBaseSettings, x, y, z).Execute();
    }

    public void pressKey(AltPressKeyParameters altPressKeyParameters) {
        new AltPressKey(this.altBaseSettings, altPressKeyParameters).Execute();
    }

    public void pressKey(String keyName, float power, float duration) {
        AltPressKeyParameters altPressKeyParameters = new AltPressKeyParameters.Builder(keyName).withDuration(duration).withPower(power).build();
        this.pressKey(altPressKeyParameters);
    }

    public void pressKeyAndWait(AltPressKeyParameters altPressKeyParameters) {
        new AltPressKeyAndWait(this.altBaseSettings, altPressKeyParameters).Execute();
    }

    public void pressKeyAndWait(String keyName, float power, float duration) {
        AltPressKeyParameters altPressKeyParameters = new AltPressKeyParameters.Builder(keyName).withPower(power).withDuration(duration).build();
        this.pressKeyAndWait(altPressKeyParameters);
    }

    public void moveMouse(AltMoveMouseParameters altMoveMouseParameters) {
        new AltMoveMouse(this.altBaseSettings, altMoveMouseParameters).Execute();
    }

    public void moveMouse(int x, int y, float duration) {
        AltMoveMouseParameters altMoveMouseParameters = new AltMoveMouseParameters.Builder(x, y).withDuration(duration).build();
        this.moveMouse(altMoveMouseParameters);
    }

    public void moveMouseAndWait(AltMoveMouseParameters altMoveMouseParameters) {
        new AltMoveMouseAndWait(this.altBaseSettings, altMoveMouseParameters).Execute();
    }

    public void moveMouseAndWait(int x, int y, float duration) {
        AltMoveMouseParameters altMoveMouseParameters = new AltMoveMouseParameters.Builder(x, y).withDuration(duration).build();
        this.moveMouseAndWait(altMoveMouseParameters);
    }

    public void scrollMouse(AltScrollMouseParameters altScrollMouseParameters) {
        new AltScrollMouse(this.altBaseSettings, altScrollMouseParameters).Execute();
    }

    public void scrollMouse(float speed, float duration) {
        AltScrollMouseParameters altScrollMouseParameters = new AltScrollMouseParameters.Builder().withDuration(duration).withSpeed(speed).build();
        this.scrollMouse(altScrollMouseParameters);
    }

    public void scrollMouseAndWait(AltScrollMouseParameters altScrollMouseParameters) {
        new AltScrollMouseAndWait(this.altBaseSettings, altScrollMouseParameters).Execute();
    }

    public void scrollMouseAndWait(float speed, float duration) {
        AltScrollMouseParameters altScrollMouseParameters = new AltScrollMouseParameters.Builder().withSpeed(speed).withDuration(duration).build();
        this.scrollMouseAndWait(altScrollMouseParameters);
    }

    public AltUnityObject findObject(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObject(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject findObject(By by, String value, String cameraName, boolean enabled) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).isEnabled(enabled).withCamera(cameraName).build();
        return this.findObject(altFindObjectsParameters);
    }

    public AltUnityObject findObject(By by, String value, boolean enabled) {
        return this.findObject(by, value, "", enabled);
    }

    public AltUnityObject findObject(By by, String value, String cameraName) {
        return this.findObject(by, value, cameraName, true);
    }

    public AltUnityObject findObject(By by, String value) {
        return this.findObject(by, value, "", true);
    }

    public AltUnityObject findObjectWhichContains(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjectWhichContains(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject findObjectWhichContains(By by, String value, String cameraName, boolean enabled) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).withCamera(cameraName).isEnabled(enabled).build();
        return this.findObjectWhichContains(altFindObjectsParameters);
    }

    public AltUnityObject findObjectWhichContains(By by, String value, boolean enabled) {
        return this.findObjectWhichContains(by, value, "", enabled);
    }

    public AltUnityObject findObjectWhichContains(By by, String value, String cameraName) {
        return this.findObjectWhichContains(by, value, cameraName, true);
    }

    public AltUnityObject findObjectWhichContains(By by, String value) {
        return this.findObjectWhichContains(by, value, "", true);
    }

    public AltUnityObject[] findObjects(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjects(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject[] findObjects(By by, String value, String cameraName, boolean enabled) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).withCamera(cameraName).isEnabled(enabled).build();
        return this.findObjects(altFindObjectsParameters);
    }

    public AltUnityObject[] findObjects(By by, String value, String cameraName) {
        return this.findObjects(by, value, cameraName, true);
    }

    public AltUnityObject[] findObjects(By by, String value, boolean enabled) {
        return this.findObjects(by, value, "", enabled);
    }

    public AltUnityObject[] findObjects(By by, String value) {
        return this.findObjects(by, value, "", true);
    }

    public AltUnityObject[] findObjectsWhichContains(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjectsWhichContains(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject[] findObjectsWhichContains(By by, String value, String cameraName, boolean enabled) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).withCamera(cameraName).isEnabled(enabled).build();
        return this.findObjectsWhichContains(altFindObjectsParameters);
    }

    public AltUnityObject[] findObjectsWhichContains(By by, String value, String cameraName) {
        return this.findObjectsWhichContains(by, value, cameraName, true);
    }

    public AltUnityObject[] findObjectsWhichContains(By by, String value, boolean enabled) {
        return this.findObjectsWhichContains(by, value, "", enabled);
    }

    public AltUnityObject[] findObjectsWhichContains(By by, String value) {
        return this.findObjectsWhichContains(by, value, "", true);
    }

    @Deprecated
    public AltUnityObject findElementWhereNameContains(AltFindElementsParameters altFindElementsParameters) {
        return new AltFindElementWhereNameContains(this.altBaseSettings, altFindElementsParameters).Execute();
    }

    @Deprecated
    public AltUnityObject findElementWhereNameContains(String name, String cameraName, boolean enabled) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        return this.findElementWhereNameContains(altFindElementsParameters);
    }

    @Deprecated
    public AltUnityObject findElementWhereNameContains(String name, String cameraName) {
        return this.findElementWhereNameContains(name, cameraName, true);
    }

    @Deprecated
    public AltUnityObject findElementWhereNameContains(String name, boolean enabled) {
        return this.findElementWhereNameContains(name, "", enabled);
    }

    @Deprecated
    public AltUnityObject findElementWhereNameContains(String name) {
        return this.findElementWhereNameContains(name, "");
    }

    public AltUnityObject[] getAllElements(AltGetAllElementsParameters altGetAllElementsParameters) {
        return new AltGetAllElements(this.altBaseSettings, altGetAllElementsParameters).Execute();
    }

    public AltUnityObject[] getAllElements(String cameraName, boolean enabled) {
        AltGetAllElementsParameters altGetAllElementsParameters = new AltGetAllElementsParameters.Builder().withCamera(cameraName).isEnabled(enabled).build();
        return this.getAllElements(altGetAllElementsParameters);
    }

    public AltUnityObject[] getAllElements(String cameraName) {
        return this.getAllElements(cameraName, true);
    }

    public AltUnityObject[] getAllElements(boolean enabled) {
        return this.getAllElements("", enabled);
    }

    public AltUnityObject[] getAllElements() throws Exception {
        return this.getAllElements("", true);
    }

    @Deprecated
    public AltUnityObject findElement(AltFindElementsParameters altFindElementsParameters) {
        return new AltFindElement(this.altBaseSettings, altFindElementsParameters).Execute();
    }

    @Deprecated
    public AltUnityObject findElement(String name, String cameraName, boolean enabled) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).isEnabled(enabled).withCamera(cameraName).build();
        return this.findElement(altFindElementsParameters);
    }

    @Deprecated
    public AltUnityObject findElement(String name, boolean enabled) {
        return this.findElement(name, "", enabled);
    }

    @Deprecated
    public AltUnityObject findElement(String name, String cameraName) {
        return this.findElement(name, cameraName, true);
    }

    @Deprecated
    public AltUnityObject findElement(String name) {
        return this.findElement(name, "", true);
    }

    public AltUnityObject[] findElements(AltFindElementsParameters altFindElementsParameters) {
        return new AltFindElements(this.altBaseSettings, altFindElementsParameters).Execute();
    }

    @Deprecated
    public AltUnityObject[] findElements(String name, String cameraName, boolean enabled) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        return this.findElements(altFindElementsParameters);
    }

    @Deprecated
    public AltUnityObject[] findElements(String name) {
        return this.findElements(name, "", true);
    }

    @Deprecated
    public AltUnityObject[] findElements(String name, String cameraName) {
        return this.findElements(name, cameraName, true);
    }

    @Deprecated
    public AltUnityObject[] findElements(String name, boolean enabled) {
        return this.findElements(name, "", enabled);
    }

    @Deprecated
    public AltUnityObject[] findElementsWhereNameContains(AltFindElementsParameters altFindElementsParameters) {
        return new AltFindElementsWhereNameContains(this.altBaseSettings, altFindElementsParameters).Execute();
    }

    @Deprecated
    public AltUnityObject[] findElementsWhereNameContains(String name, String cameraName, boolean enabled) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        return this.findElementsWhereNameContains(altFindElementsParameters);
    }

    @Deprecated
    public AltUnityObject[] findElementsWhereNameContains(String name, String cameraName) {
        return this.findElementsWhereNameContains(name, cameraName, true);
    }

    @Deprecated
    public AltUnityObject[] findElementsWhereNameContains(String name, boolean enabled) {
        return this.findElementsWhereNameContains(name, "", enabled);
    }

    @Deprecated
    public AltUnityObject[] findElementsWhereNameContains(String name) {
        return this.findElementsWhereNameContains(name, "", true);
    }

    public AltUnityObject tapScreen(int x, int y) {
        return new AltTapScreen(this.altBaseSettings, x, y).Execute();
    }

    public String waitForCurrentSceneToBe(AltWaitForCurrentSceneToBeParameters altWaitForCurrentSceneToBeParameters) {
        return new AltWaitForCurrentSceneToBe(this.altBaseSettings, altWaitForCurrentSceneToBeParameters).Execute();
    }

    public String waitForCurrentSceneToBe(String sceneName, double timeout, double interval) {
        AltWaitForCurrentSceneToBeParameters altWaitForCurrentSceneToBeParameters = new AltWaitForCurrentSceneToBeParameters.Builder(sceneName).withInterval(interval).withTimeout(timeout).build();
        return this.waitForCurrentSceneToBe(altWaitForCurrentSceneToBeParameters);
    }

    public String waitForCurrentSceneToBe(String sceneName) {
        return this.waitForCurrentSceneToBe(sceneName, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(AltWaitForElementParameters altWaitForElementParameters) {
        return new AltWaitForElementWhereNameContains(this.altBaseSettings, altWaitForElementParameters).Execute();
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(String name, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForElementParameters altWaitForElementParameters = new AltWaitForElementParameters.Builder(altFindElementsParameters).withInterval(interval).withTimeout(timeout).build();
        return this.waitForElementWhereNameContains(altWaitForElementParameters);
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(String name, String cameraName, double timeout, double interval) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).build();
        AltWaitForElementParameters altWaitForElementParameters = new AltWaitForElementParameters.Builder(altFindElementsParameters).withInterval(interval).withTimeout(timeout).build();
        return this.waitForElementWhereNameContains(altWaitForElementParameters);
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(String name) {
        return this.waitForElementWhereNameContains(name, "", true, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(String name, boolean enabled) {
        return this.waitForElementWhereNameContains(name, "", enabled, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWhereNameContains(String name, String cameraName) {
        return this.waitForElementWhereNameContains(name, cameraName, true, 20.0, 0.5);
    }

    @Deprecated
    public void waitForElementToNotBePresent(AltWaitForElementParameters altWaitForElementParameters) {
        new AltWaitForElementToNotBePresent(this.altBaseSettings, altWaitForElementParameters).Execute();
    }

    @Deprecated
    public void waitForElementToNotBePresent(String name, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForElementParameters altWaitForElementParameters = new AltWaitForElementParameters.Builder(altFindElementsParameters).withTimeout(timeout).withInterval(interval).build();
        this.waitForElementToNotBePresent(altWaitForElementParameters);
    }

    public AltUnityObject waitForObject(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        return new AltWaitForObject(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    public AltUnityObject waitForObject(By by, String value, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForObjectsParameters altWaitForObjectsParameters = new AltWaitForObjectsParameters.Builder(altFindObjectsParameters).withInterval(interval).withTimeout(timeout).build();
        return this.waitForObject(altWaitForObjectsParameters);
    }

    public AltUnityObject waitForObject(By by, String value) {
        return this.waitForObject(by, value, "", true, 2.0, 0.5);
    }

    public AltUnityObject waitForObjectWithText(AltWaitForObjectWithTextParameters altWaitForObjectWithTextParameters) {
        return new AltWaitForObjectWithText(this.altBaseSettings, altWaitForObjectWithTextParameters).Execute();
    }

    public AltUnityObject waitForObjectWithText(By by, String value, String text, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindObjectsParameters altFindElementsParameters = new AltFindObjectsParameters.Builder(by, value).isEnabled(enabled).withCamera(cameraName).build();
        AltWaitForObjectWithTextParameters altWaitForElementWithTextParameters = new AltWaitForObjectWithTextParameters.Builder(altFindElementsParameters, text).withInterval(interval).withTimeout(timeout).build();
        return this.waitForObjectWithText(altWaitForElementWithTextParameters);
    }

    public AltUnityObject waitForObjectWithText(By by, String value, String text) {
        return this.waitForObjectWithText(by, value, text, "", true, 2.0, 0.5);
    }

    public void waitForObjectToNotBePresent(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        new AltWaitForObjectToNotBePresent(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    public void waitForObjectToNotBePresent(By by, String value, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForObjectsParameters altWaitForObjectsParameters = new AltWaitForObjectsParameters.Builder(altFindObjectsParameters).withTimeout(timeout).withInterval(interval).build();
        this.waitForObjectToNotBePresent(altWaitForObjectsParameters);
    }

    public void waitForObjectToNotBePresent(By by, String value) {
        this.waitForObjectToNotBePresent(by, value, "", true, 20.0, 0.5);
    }

    public AltUnityObject waitForObjectWhichContains(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        return new AltWaitForObjectWhichContains(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    public AltUnityObject waitForObjectWhichContains(By by, String value, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(by, value).isEnabled(enabled).withCamera(cameraName).build();
        AltWaitForObjectsParameters altWaitForObjectsParameters = new AltWaitForObjectsParameters.Builder(altFindObjectsParameters).withInterval(interval).withTimeout(timeout).build();
        return this.waitForObjectWhichContains(altWaitForObjectsParameters);
    }

    public AltUnityObject waitForObjectWhichContains(By by, String value) {
        return this.waitForObjectWhichContains(by, value, "", true, 30.0, 0.5);
    }

    @Deprecated
    public void waitForElementToNotBePresent(String name) {
        this.waitForElementToNotBePresent(name, "", true, 20.0, 0.5);
    }

    @Deprecated
    public void waitForElementToNotBePresent(String name, String cameraName) {
        this.waitForElementToNotBePresent(name, cameraName, true, 20.0, 0.5);
    }

    @Deprecated
    public void waitForElementToNotBePresent(String name, boolean enabled) {
        this.waitForElementToNotBePresent(name, "", enabled, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElement(AltWaitForElementParameters altWaitForElementParameters) {
        return new AltWaitForElement(this.altBaseSettings, altWaitForElementParameters).Execute();
    }

    @Deprecated
    public AltUnityObject waitForElement(String name, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForElementParameters altWaitForElementParameters = new AltWaitForElementParameters.Builder(altFindElementsParameters).withTimeout(timeout).withInterval(interval).build();
        return this.waitForElement(altWaitForElementParameters);
    }

    @Deprecated
    public AltUnityObject waitForElement(String name) {
        return this.waitForElement(name, "", true, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElement(String name, String cameraName) {
        return this.waitForElement(name, cameraName, true, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElement(String name, boolean enabled) {
        return this.waitForElement(name, "", enabled, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWithText(AltWaitForElementWithTextParameters altWaitForElementWithTextParameters) {
        return new AltWaitForElementWithText(this.altBaseSettings, altWaitForElementWithTextParameters).Execute();
    }

    @Deprecated
    public AltUnityObject waitForElementWithText(String name, String text, String cameraName, boolean enabled, double timeout, double interval) {
        AltFindElementsParameters altFindElementsParameters = new AltFindElementsParameters.Builder(name).withCamera(cameraName).isEnabled(enabled).build();
        AltWaitForElementWithTextParameters altWaitForElementWithTextParameters = new AltWaitForElementWithTextParameters.Builder(altFindElementsParameters, text).withInterval(interval).withTimeout(timeout).build();
        return this.waitForElementWithText(altWaitForElementWithTextParameters);
    }

    @Deprecated
    public AltUnityObject waitForElementWithText(String name, String text) {
        return this.waitForElementWithText(name, text, "", true, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWithText(String name, String text, String cameraName) {
        return this.waitForElementWithText(name, text, cameraName, true, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject waitForElementWithText(String name, String text, boolean enabled) {
        return this.waitForElementWithText(name, text, "", enabled, 20.0, 0.5);
    }

    @Deprecated
    public AltUnityObject findElementByComponent(AltFindElementsByComponentParameters altFindElementsByComponentParameters) {
        return new AltFindElementByComponent(this.altBaseSettings, altFindElementsByComponentParameters).Execute();
    }

    @Deprecated
    public AltUnityObject findElementByComponent(String componentName, String assemblyName, String cameraName, boolean enabled) {
        AltFindElementsByComponentParameters altFindElementsByComponentParameters = new AltFindElementsByComponentParameters.Builder(componentName).inAssembly(assemblyName).isEnabled(enabled).withCamera(cameraName).build();
        return this.findElementByComponent(altFindElementsByComponentParameters);
    }

    @Deprecated
    public AltUnityObject findElementByComponent(String componentName) {
        return this.findElementByComponent(componentName, "", "", true);
    }

    @Deprecated
    public AltUnityObject findElementByComponent(String componentName, String cameraName) {
        return this.findElementByComponent(componentName, "", cameraName, true);
    }

    @Deprecated
    public AltUnityObject findElementByComponent(String componentName, String assemblyName, boolean enabled) {
        return this.findElementByComponent(componentName, assemblyName, "", enabled);
    }

    @Deprecated
    public AltUnityObject[] findElementsByComponent(AltFindElementsByComponentParameters altFindElementsByComponentParameters) {
        return new AltFindElementsByComponent(this.altBaseSettings, altFindElementsByComponentParameters).Execute();
    }

    @Deprecated
    public AltUnityObject[] findElementsByComponent(String componentName, String assemblyName, String cameraName, boolean enabled) {
        AltFindElementsByComponentParameters altFindElementsByComponentParameters = new AltFindElementsByComponentParameters.Builder(componentName).inAssembly(assemblyName).isEnabled(enabled).withCamera(cameraName).build();
        return this.findElementsByComponent(altFindElementsByComponentParameters);
    }

    @Deprecated
    public AltUnityObject[] findElementsByComponent(String componentName, String assemblyName) {
        return this.findElementsByComponent(componentName, assemblyName, "", true);
    }

    @Deprecated
    public AltUnityObject[] findElementsByComponent(String componentName, String assemblyName, boolean enabled) {
        return this.findElementsByComponent(componentName, assemblyName, "", enabled);
    }

    public void getPNGScreeshot(String path) {
        new GetPNGScreenshotCommand(this.altBaseSettings, path).Execute();
    }

    public static void setupPortForwarding(String platform, String deviceID, int local_tcp_port, int remote_tcp_port) {
        log.info("Setting up port forward for " + platform + " on port " + remote_tcp_port);
        AltUnityDriver.removePortForwarding();
        if (platform.toLowerCase().equals("android".toLowerCase())) {
            try {
                String commandToRun = deviceID.equals("") ? "adb forward tcp:" + local_tcp_port + " tcp:" + remote_tcp_port : "adb -s " + deviceID + " forward  tcp:" + local_tcp_port + " tcp:" + remote_tcp_port;
                Runtime.getRuntime().exec(commandToRun);
                Thread.sleep(1000L);
                log.info("adb forward enabled.");
            }
            catch (Exception e) {
                log.warn("AltUnityServer - abd probably not installed\n" + e);
            }
        } else if (platform.toLowerCase().equals("ios".toLowerCase())) {
            try {
                String commandToRun = deviceID.equals("") ? "iproxy " + local_tcp_port + " " + remote_tcp_port + "&" : "iproxy " + local_tcp_port + " " + remote_tcp_port + " " + deviceID + "&";
                Runtime.getRuntime().exec(commandToRun);
                Thread.sleep(1000L);
                log.info("iproxy forward enabled.");
            }
            catch (Exception e) {
                log.warn("AltUnityServer - no iproxy process was running/present\n" + e);
            }
        }
    }

    public static void removePortForwarding() {
        String commandToExecute;
        try {
            commandToExecute = "killall iproxy";
            Runtime.getRuntime().exec(commandToExecute);
            Thread.sleep(1000L);
            log.info("Killed any iproxy process that may have been running...");
        }
        catch (Exception e) {
            log.warn("AltUnityServer - no iproxy process was running/present\n" + e);
        }
        try {
            commandToExecute = "adb forward --remove-all";
            Runtime.getRuntime().exec(commandToExecute);
            Thread.sleep(1000L);
            log.info("Removed existing adb forwarding...");
        }
        catch (Exception e) {
            log.warn("AltUnityServer - adb probably not installed\n" + e);
        }
    }

    public static enum By {
        TAG,
        LAYER,
        NAME,
        COMPONENT,
        PATH,
        ID;

    }

    public static class PlayerPrefsKeyType {
        public static int IntType = 1;
        public static int StringType = 2;
        public static int FloatType = 3;
    }
}

