/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester.Commands;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.altom.altunitytester.AltBaseSettings;
import ro.altom.altunitytester.altUnityTesterExceptions.ComponentNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionException;
import ro.altom.altunitytester.altUnityTesterExceptions.CouldNotParseJsonStringException;
import ro.altom.altunitytester.altUnityTesterExceptions.CouldNotPerformOperationException;
import ro.altom.altunitytester.altUnityTesterExceptions.FailedToParseArgumentsException;
import ro.altom.altunitytester.altUnityTesterExceptions.FormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.IncorrectNumberOfParametersException;
import ro.altom.altunitytester.altUnityTesterExceptions.MethodNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NullReferenceException;
import ro.altom.altunitytester.altUnityTesterExceptions.ObjectWasNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.PropertyNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.UnknownErrorException;

public class AltBaseCommand {
    protected static final Logger log = LoggerFactory.getLogger(AltBaseCommand.class);
    private static final int BUFFER_SIZE = 1024;
    public AltBaseSettings altBaseSettings;

    public AltBaseCommand(AltBaseSettings altBaseSettings) {
        this.altBaseSettings = altBaseSettings;
    }

    protected String recvall() {
        String receivedData = "";
        boolean streamIsFinished = false;
        while (!streamIsFinished) {
            byte[] messageByte = new byte[1024];
            int bytesRead = 0;
            try {
                bytesRead = this.altBaseSettings.in.read(messageByte);
            }
            catch (IOException e) {
                throw new ConnectionException(e);
            }
            if (bytesRead > 0) {
                receivedData = receivedData + new String(messageByte, 0, bytesRead, StandardCharsets.UTF_8);
            }
            if (!receivedData.contains("::altend")) continue;
            streamIsFinished = true;
        }
        receivedData = receivedData.split("altstart::")[1].split("::altend")[0];
        String[] data = receivedData.split("::altLog::");
        receivedData = data[0];
        log.debug("Data received: " + receivedData);
        if (this.altBaseSettings.logEnabled.booleanValue()) {
            this.WriteInLogFile(data[1]);
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            this.WriteInLogFile(formatter.format(date) + " : response received : " + receivedData);
        }
        return receivedData;
    }

    protected void WriteInLogFile(String logMessages) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter("AltUnityTesterLog.txt", true));
            writer.append(logMessages + System.lineSeparator());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void send(String message) {
        log.info("Sending rpc message [{}]", (Object)message);
        this.altBaseSettings.out.print(message);
        this.altBaseSettings.out.flush();
    }

    protected String CreateCommand(String ... arguments) {
        String command = "";
        for (String argument : arguments) {
            command = command + argument + this.altBaseSettings.RequestSeparator;
        }
        return command + this.altBaseSettings.RequestEnd;
    }

    protected void handleErrors(String data) {
        String typeOfException = data.split(";")[0];
        if ("error:notFound".equals(typeOfException)) {
            throw new NotFoundException(data);
        }
        if ("error:propertyNotFound".equals(typeOfException)) {
            throw new PropertyNotFoundException(data);
        }
        if ("error:methodNotFound".equals(typeOfException)) {
            throw new MethodNotFoundException(data);
        }
        if ("error:componentNotFound".equals(typeOfException)) {
            throw new ComponentNotFoundException(data);
        }
        if ("error:couldNotPerformOperation".equals(typeOfException)) {
            throw new CouldNotPerformOperationException(data);
        }
        if ("error:couldNotParseJsonString".equals(typeOfException)) {
            throw new CouldNotParseJsonStringException(data);
        }
        if ("error:incorrectNumberOfParameters".equals(typeOfException)) {
            throw new IncorrectNumberOfParametersException(data);
        }
        if ("error:failedToParseMethodArguments".equals(typeOfException)) {
            throw new FailedToParseArgumentsException(data);
        }
        if ("error:objectNotFound".equals(typeOfException)) {
            throw new ObjectWasNotFoundException(data);
        }
        if ("error:propertyCannotBeSet".equals(typeOfException)) {
            throw new PropertyNotFoundException(data);
        }
        if ("error:nullReferenceException".equals(typeOfException)) {
            throw new NullReferenceException(data);
        }
        if ("error:unknownError".equals(typeOfException)) {
            throw new UnknownErrorException(data);
        }
        if ("error:formatException".equals(typeOfException)) {
            throw new FormatException(data);
        }
    }

    public String vectorToJsonString(int x, int y) {
        return "{\"x\":" + x + ", \"y\":" + y + "}";
    }

    public String vectorToJsonString(int x, int y, int z) {
        return "{\"x\":" + x + ", \"y\":" + y + ", \"z\":" + z + "}";
    }

    protected void sleepFor(double interval) {
        long timeToSleep = (long)(interval * 1000.0);
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            log.warn("Could not sleep for " + timeToSleep + " ms");
        }
    }
}

