/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import ro.altom.altunitytester.AltBaseSettings;
import ro.altom.altunitytester.AltUnityDriver;
import ro.altom.altunitytester.Commands.FindObject.AltFindObject;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsParameters;
import ro.altom.altunitytester.Commands.ObjectCommand.AltCallComponentMethod;
import ro.altom.altunitytester.Commands.ObjectCommand.AltCallComponentMethodParameters;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetComponentProperty;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetComponentPropertyParameters;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetText;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSendActionAndEvaluateResult;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetComponentProperty;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetComponentPropertyParameters;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetText;
import ro.altom.altunitytester.position.Vector2;
import ro.altom.altunitytester.position.Vector3;

public class AltUnityObject {
    public String name;
    public int id;
    public int x;
    public int y;
    public int z;
    public int mobileY;
    public String type;
    public boolean enabled;
    public float worldX;
    public float worldY;
    public float worldZ;
    public int idCamera;
    @Deprecated
    public int parentId;
    public int transformParentId;
    public int tranformId;
    private transient AltBaseSettings altBaseSettings;

    public AltBaseSettings getAltBaseSettings() {
        return this.altBaseSettings;
    }

    public void setAltBaseSettings(AltBaseSettings altBaseSettings) {
        this.altBaseSettings = altBaseSettings;
    }

    public AltUnityObject(String name, int id, int x, int y, int z, int mobileY, String type, boolean enabled, float worldX, float worldY, float worldZ, int idCamera, int parentId, int transformId) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mobileY = mobileY;
        this.type = type;
        this.enabled = enabled;
        this.worldX = worldX;
        this.worldY = worldY;
        this.worldZ = worldZ;
        this.idCamera = idCamera;
        this.tranformId = transformId;
        this.parentId = parentId;
        this.transformParentId = parentId;
    }

    public AltUnityObject(String name, int id, int x, int y, int z, int mobileY, String type, boolean enabled, float worldX, float worldY, float worldZ, int idCamera, int parentId, int transformParentId, int transformId) {
        this(name, id, x, y, z, mobileY, type, enabled, worldX, worldY, worldZ, idCamera, transformParentId, transformId);
        this.transformParentId = transformParentId;
    }

    public AltUnityObject getParent() {
        AltFindObjectsParameters altFindObjectsParameters = new AltFindObjectsParameters.Builder(AltUnityDriver.By.PATH, "//*[@id=" + this.id + "]/..").build();
        return new AltFindObject(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public Vector2 getScreenPosition() {
        return new Vector2(this.x, this.y);
    }

    public Vector3 getWorldPosition() {
        return new Vector3(this.worldX, this.worldY, this.worldZ);
    }

    public String getComponentProperty(AltGetComponentPropertyParameters altGetComponentPropertyParameters) {
        return new AltGetComponentProperty(this.altBaseSettings, this, altGetComponentPropertyParameters).Execute();
    }

    public String getComponentProperty(String assemblyName, String componentName, String propertyName) {
        AltGetComponentPropertyParameters altGetComponentPropertyParameters = new AltGetComponentPropertyParameters.Builder(componentName, propertyName).withAssembly(assemblyName).build();
        return this.getComponentProperty(altGetComponentPropertyParameters);
    }

    public String getComponentProperty(String componentName, String propertyName) {
        return this.getComponentProperty("", componentName, propertyName);
    }

    public String setComponentProperty(AltSetComponentPropertyParameters altSetComponentPropertyParameters) {
        return new AltSetComponentProperty(this.altBaseSettings, this, altSetComponentPropertyParameters).Execute();
    }

    public String setComponentProperty(String assemblyName, String componentName, String propertyName, String value) {
        AltSetComponentPropertyParameters altSetComponentPropertyParameters = new AltSetComponentPropertyParameters.Builder(componentName, propertyName, value).withAssembly(assemblyName).build();
        return this.setComponentProperty(altSetComponentPropertyParameters);
    }

    public String setComponentProperty(String componentName, String propertyName, String value) {
        return this.setComponentProperty("", componentName, propertyName, value);
    }

    public String callComponentMethod(AltCallComponentMethodParameters altCallComponentMethodParameters) {
        return new AltCallComponentMethod(this.altBaseSettings, this, altCallComponentMethodParameters).Execute();
    }

    public String callComponentMethod(String assemblyName, String componentName, String methodName, String parameters, String typeOfParameters) {
        AltCallComponentMethodParameters altCallComponentMethodParameters = new AltCallComponentMethodParameters.Builder(componentName, methodName, parameters).withTypeOfParameters(typeOfParameters).withAssembly(assemblyName).build();
        return this.callComponentMethod(altCallComponentMethodParameters);
    }

    public String callComponentMethod(String componentName, String methodName, String parameters) throws Exception {
        return this.callComponentMethod("", componentName, methodName, parameters, "");
    }

    public String getText() {
        return new AltGetText(this.altBaseSettings, this).Execute();
    }

    public AltUnityObject setText(String text) {
        return new AltSetText(this.altBaseSettings, this, text).Execute();
    }

    public AltUnityObject clickEvent() {
        return this.sendActionAndEvaluateResult("clickEvent");
    }

    public AltUnityObject pointerUp() {
        return this.sendActionAndEvaluateResult("pointerUpFromObject");
    }

    public AltUnityObject pointerDown() {
        return this.sendActionAndEvaluateResult("pointerDownFromObject");
    }

    public AltUnityObject pointerEnter() {
        return this.sendActionAndEvaluateResult("pointerEnterObject");
    }

    public AltUnityObject pointerExit() {
        return this.sendActionAndEvaluateResult("pointerExitObject");
    }

    public AltUnityObject tap() {
        return this.sendActionAndEvaluateResult("tapObject", "1");
    }

    public AltUnityObject doubleTap() {
        return this.sendActionAndEvaluateResult("tapObject", "2");
    }

    private AltUnityObject sendActionAndEvaluateResult(String command) {
        return new AltSendActionAndEvaluateResult(this.altBaseSettings, this, command).Execute();
    }

    private AltUnityObject sendActionAndEvaluateResult(String command, String parameter) {
        return new AltSendActionAndEvaluateResult(this.altBaseSettings, this, command, parameter).Execute();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getMobileY() {
        return this.mobileY;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldZ() {
        return this.worldZ;
    }

    public int getIdCamera() {
        return this.idCamera;
    }

    @Deprecated
    public int getParentId() {
        return this.parentId;
    }

    public int getTransformParentId() {
        return this.transformParentId;
    }

    public int getTranformId() {
        return this.tranformId;
    }
}

