/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import ro.altom.altunitytester.AltBaseSettings;
import ro.altom.altunitytester.AltUnityDriverConfigFactory;
import ro.altom.altunitytester.AltUnityDriverParams;
import ro.altom.altunitytester.AltUnityObject;
import ro.altom.altunitytester.Commands.AltCallStaticMethod;
import ro.altom.altunitytester.Commands.AltCallStaticMethodParameters;
import ro.altom.altunitytester.Commands.AltStop;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltSetServerLoggingParameters;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnitySetServerLogging;
import ro.altom.altunitytester.Commands.FindObject.AltFindObject;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjects;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsParameters;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsWhichContain;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElements;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElementsParameters;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObject;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectToNotBePresent;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWithText;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWithTextParameters;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectsParameters;
import ro.altom.altunitytester.Commands.GetPNGScreenshotCommand;
import ro.altom.altunitytester.Commands.GetServerVersionCommand;
import ro.altom.altunitytester.Commands.InputActions.AltClickScreen;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouse;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouseAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouseParameters;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipeAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltPressKey;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeyAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeyParameters;
import ro.altom.altunitytester.Commands.InputActions.AltScrollMouse;
import ro.altom.altunitytester.Commands.InputActions.AltScrollMouseParameters;
import ro.altom.altunitytester.Commands.InputActions.AltSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltSwipeAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltTapCustom;
import ro.altom.altunitytester.Commands.InputActions.AltTapScreen;
import ro.altom.altunitytester.Commands.InputActions.AltTilt;
import ro.altom.altunitytester.Commands.InputActions.AltTiltAndWait;
import ro.altom.altunitytester.Commands.InputActions.AltTiltParameters;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeleteKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeletePlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltFloatGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetAllLoadedScenes;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetCurrentScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltIntGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltLoadScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltLoadSceneParameters;
import ro.altom.altunitytester.Commands.UnityCommand.AltScrollMouseAndWait;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltStringGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltUnloadScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBe;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBeParameters;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityRecvallMessageFormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidParamerException;
import ro.altom.altunitytester.altUnityTesterExceptions.UnknownErrorException;
import ro.altom.altunitytester.position.Vector2;

public class AltUnityDriver {
    private static final Logger log;
    public static final String VERSION = "1.6.4";
    public static final int READ_TIMEOUT = 5000;
    private Socket socket = null;
    private PrintWriter out = null;
    private DataInputStream in = null;
    private AltBaseSettings altBaseSettings;

    public AltUnityDriver() {
        this("127.0.0.1", 13000);
    }

    public AltUnityDriver(String ip, int port) {
        this(ip, port, ";", "&", false);
    }

    public AltUnityDriver(String ip, int port, String requestSeparator, String requestEnd) {
        this(ip, port, requestSeparator, requestEnd, false);
    }

    public AltUnityDriver(String ip, int port, String requestSeparator, String requestEnd, Boolean logFlag) {
        this(ip, port, requestSeparator, requestEnd, logFlag, 60);
    }

    public AltUnityDriver(AltUnityDriverParams params) {
        this(params.ip, params.port, params.requestSeparator, params.requestEnd, params.logFlag, params.connectTimeout);
    }

    public AltUnityDriver(String ip, int port, String requestSeparator, String requestEnd, Boolean logFlag, int connectTimeout) {
        if (!logFlag.booleanValue()) {
            AltUnityDriverConfigFactory.DisableLogging();
        }
        if (ip == null || ip.isEmpty()) {
            throw new InvalidParamerException("Provided IP address is null or empty");
        }
        while (connectTimeout > 0) {
            try {
                try {
                    log.info(String.format("Initializing connection to %s:%d", ip, port));
                    this.socket = new Socket(ip, port);
                    this.socket.setSoTimeout(5000);
                    this.out = new PrintWriter(this.socket.getOutputStream(), true);
                    this.in = new DataInputStream(this.socket.getInputStream());
                }
                catch (IOException e) {
                    throw new ConnectionException("AltUnityServer not running on port " + port + ",retrying (timing out in " + connectTimeout + " secs)...", e);
                }
                this.altBaseSettings = new AltBaseSettings(this.socket, requestSeparator, requestEnd, this.out, this.in);
                this.checkServerVersion();
                break;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (this.socket != null) {
                    this.stop();
                }
                connectTimeout -= 5;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (connectTimeout > 0) continue;
                throw new ConnectionException("Could not create connection to " + String.format("%s:%d", ip, port), new Throwable());
            }
        }
    }

    private String[] splitVersion(String version) {
        return version.split("\\.");
    }

    private void checkServerVersion() {
        String minorDriver;
        String serverVersion;
        try {
            serverVersion = new GetServerVersionCommand(this.altBaseSettings).Execute();
        }
        catch (UnknownErrorException ex) {
            serverVersion = "<=1.5.3";
        }
        catch (AltUnityRecvallMessageFormatException ex) {
            serverVersion = "<=1.5.7";
        }
        String[] parts = this.splitVersion(serverVersion);
        String majorServer = parts[0];
        String minorServer = parts.length > 1 ? parts[1] : "";
        parts = this.splitVersion(VERSION);
        String majorDriver = parts[0];
        String string = minorDriver = parts.length > 1 ? parts[1] : "";
        if (!majorServer.equals(majorDriver) || !minorServer.equals(minorDriver)) {
            String message = "Version mismatch. AltUnity Driver version is 1.6.4. AltUnity Server version is " + serverVersion + ".";
            log.warn(message);
            System.out.println(message);
        }
    }

    public void stop() {
        new AltStop(this.altBaseSettings).Execute();
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            log.warn((Object)ex);
        }
    }

    public String callStaticMethod(AltCallStaticMethodParameters altCallStaticMethodParameters) {
        return new AltCallStaticMethod(this.altBaseSettings, altCallStaticMethodParameters).Execute();
    }

    @Deprecated
    public String callStaticMethods(AltCallStaticMethodParameters altCallStaticMethodParameters) {
        return new AltCallStaticMethod(this.altBaseSettings, altCallStaticMethodParameters).Execute();
    }

    @Deprecated
    public String callStaticMethods(String assembly, String typeName, String methodName, String parameters, String typeOfParameters) {
        AltCallStaticMethodParameters altCallStaticMethodParameters = new AltCallStaticMethodParameters.Builder(typeName, methodName, parameters).withAssembly(assembly).withTypeOfParameters(typeOfParameters).build();
        return this.callStaticMethods(altCallStaticMethodParameters);
    }

    @Deprecated
    public String callStaticMethods(String typeName, String methodName, String parameters) {
        return this.callStaticMethods("", typeName, methodName, parameters, "");
    }

    public void loadScene(AltLoadSceneParameters altLoadSceneParameters) {
        new AltLoadScene(this.altBaseSettings, altLoadSceneParameters).Execute();
    }

    public void unloadScene(String sceneName) {
        new AltUnloadScene(this.altBaseSettings, sceneName).Execute();
    }

    public String[] getAllLoadedScenes() {
        return new AltGetAllLoadedScenes(this.altBaseSettings).Execute();
    }

    public AltBaseSettings GetAltBaseSettings() {
        return this.altBaseSettings;
    }

    public void deletePlayerPref() {
        new AltDeletePlayerPref(this.altBaseSettings).Execute();
    }

    public void deleteKeyPlayerPref(String keyName) {
        new AltDeleteKeyPlayerPref(this.altBaseSettings, keyName).Execute();
    }

    public void setKeyPlayerPref(String keyName, int valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public void setKeyPlayerPref(String keyName, float valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public void setKeyPlayerPref(String keyName, String valueName) {
        new AltSetKeyPlayerPref(this.altBaseSettings, keyName, valueName).Execute();
    }

    public int getIntKeyPlayerPref(String keyname) {
        return new AltIntGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public float getFloatKeyPlayerPref(String keyname) {
        return new AltFloatGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public String getStringKeyPlayerPref(String keyname) {
        return new AltStringGetKeyPlayerPref(this.altBaseSettings, keyname).Execute();
    }

    public String getCurrentScene() {
        return new AltGetCurrentScene(this.altBaseSettings).Execute();
    }

    public float getTimeScale() {
        return new AltGetTimeScale(this.altBaseSettings).Execute();
    }

    public void setTimeScale(float timeScale) {
        new AltSetTimeScale(this.altBaseSettings, timeScale).Execute();
    }

    public void swipe(int xStart, int yStart, int xEnd, int yEnd, float durationInSecs) {
        new AltSwipe(this.altBaseSettings, xStart, yStart, xEnd, yEnd, durationInSecs).Execute();
    }

    public void swipeAndWait(int xStart, int yStart, int xEnd, int yEnd, float durationInSecs) {
        new AltSwipeAndWait(this.altBaseSettings, xStart, yStart, xEnd, yEnd, durationInSecs).Execute();
    }

    public void multipointSwipe(List<Vector2> positions, float durationInSecs) {
        new AltMultiPointSwipe(this.altBaseSettings, positions, durationInSecs).Execute();
    }

    public void multipointSwipeAndWait(List<Vector2> positions, float durationInSecs) {
        new AltMultiPointSwipeAndWait(this.altBaseSettings, positions, durationInSecs).Execute();
    }

    public void holdButton(int xPosition, int yPosition, float durationInSecs) {
        this.swipe(xPosition, yPosition, xPosition, yPosition, durationInSecs);
    }

    public void holdButtonAndWait(int xPosition, int yPosition, float durationInSecs) {
        this.swipeAndWait(xPosition, yPosition, xPosition, yPosition, durationInSecs);
    }

    public AltUnityObject clickScreen(float x, float y) {
        return new AltClickScreen(this.altBaseSettings, x, y).Execute();
    }

    public void tilt(AltTiltParameters altTiltParameter) {
        new AltTilt(this.altBaseSettings, altTiltParameter).Execute();
    }

    public void tiltAndWait(AltTiltParameters altTiltParameters) {
        new AltTiltAndWait(this.altBaseSettings, altTiltParameters).Execute();
    }

    public void pressKey(AltPressKeyParameters altPressKeyParameters) {
        new AltPressKey(this.altBaseSettings, altPressKeyParameters).Execute();
    }

    public void pressKey(String keyName, float power, float duration) {
        this.pressKey(this.BuildPressKeyParameters(keyName, power, duration));
    }

    public void pressKeyAndWait(AltPressKeyParameters altPressKeyParameters) {
        new AltPressKeyAndWait(this.altBaseSettings, altPressKeyParameters).Execute();
    }

    public void pressKeyAndWait(String keyName, float power, float duration) {
        this.pressKeyAndWait(this.BuildPressKeyParameters(keyName, power, duration));
    }

    public void moveMouse(AltMoveMouseParameters altMoveMouseParameters) {
        new AltMoveMouse(this.altBaseSettings, altMoveMouseParameters).Execute();
    }

    public void moveMouse(int x, int y, float duration) {
        this.moveMouse(this.BuildMoveMouseParameters(x, y, duration));
    }

    public void moveMouseAndWait(AltMoveMouseParameters altMoveMouseParameters) {
        new AltMoveMouseAndWait(this.altBaseSettings, altMoveMouseParameters).Execute();
    }

    public void moveMouseAndWait(int x, int y, float duration) {
        this.moveMouseAndWait(this.BuildMoveMouseParameters(x, y, duration));
    }

    public void scrollMouse(AltScrollMouseParameters altScrollMouseParameters) {
        new AltScrollMouse(this.altBaseSettings, altScrollMouseParameters).Execute();
    }

    public void scrollMouse(float speed, float duration) {
        this.scrollMouse(this.BuildScrollMouseParameters(speed, duration));
    }

    public void scrollMouseAndWait(AltScrollMouseParameters altScrollMouseParameters) {
        new AltScrollMouseAndWait(this.altBaseSettings, altScrollMouseParameters).Execute();
    }

    public void scrollMouseAndWait(float speed, float duration) {
        this.scrollMouseAndWait(this.BuildScrollMouseParameters(speed, duration));
    }

    public AltUnityObject findObject(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObject(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject findObjectWhichContains(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjectWhichContains(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject findObjectWhichContains(By by, String value, By cameraBy, String cameraPath, boolean enabled) {
        return this.findObjectWhichContains(this.BuildFindObjectsParameters(by, value, cameraBy, cameraPath, enabled));
    }

    public AltUnityObject[] findObjects(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjects(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject[] findObjects(By by, String value, By cameraBy, String cameraPath, boolean enabled) {
        return this.findObjects(this.BuildFindObjectsParameters(by, value, cameraBy, cameraPath, enabled));
    }

    public AltUnityObject[] findObjectsWhichContain(AltFindObjectsParameters altFindObjectsParameters) {
        return new AltFindObjectsWhichContain(this.altBaseSettings, altFindObjectsParameters).Execute();
    }

    public AltUnityObject[] getAllElements(AltGetAllElementsParameters altGetAllElementsParameters) {
        return new AltGetAllElements(this.altBaseSettings, altGetAllElementsParameters).Execute();
    }

    public AltUnityObject tapScreen(int x, int y) {
        return new AltTapScreen(this.altBaseSettings, x, y).Execute();
    }

    public void tapCustom(int x, int y, int count, float interval) {
        new AltTapCustom(this.altBaseSettings, x, y, count, interval).Execute();
    }

    public void tapCustom(int x, int y, int count) {
        this.tapCustom(x, y, count, 0.1f);
    }

    public String waitForCurrentSceneToBe(AltWaitForCurrentSceneToBeParameters altWaitForCurrentSceneToBeParameters) {
        return new AltWaitForCurrentSceneToBe(this.altBaseSettings, altWaitForCurrentSceneToBeParameters).Execute();
    }

    public AltUnityObject waitForObject(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        return new AltWaitForObject(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    @Deprecated
    public AltUnityObject waitForObjectWithText(AltWaitForObjectWithTextParameters altWaitForObjectWithTextParameters) {
        return new AltWaitForObjectWithText(this.altBaseSettings, altWaitForObjectWithTextParameters).Execute();
    }

    public void waitForObjectToNotBePresent(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        new AltWaitForObjectToNotBePresent(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    public AltUnityObject waitForObjectWhichContains(AltWaitForObjectsParameters altWaitForObjectsParameters) {
        return new AltWaitForObjectWhichContains(this.altBaseSettings, altWaitForObjectsParameters).Execute();
    }

    private AltPressKeyParameters BuildPressKeyParameters(String keyName, float power, float duration) {
        return new AltPressKeyParameters.Builder(keyName).withPower(power).withDuration(duration).build();
    }

    private AltMoveMouseParameters BuildMoveMouseParameters(int x, int y, float duration) {
        return new AltMoveMouseParameters.Builder(x, y).withDuration(duration).build();
    }

    private AltScrollMouseParameters BuildScrollMouseParameters(float speed, float duration) {
        return new AltScrollMouseParameters.Builder().withDuration(duration).withSpeed(speed).build();
    }

    private AltFindObjectsParameters BuildFindObjectsParameters(By by, String value, By cameraBy, String cameraName, boolean enabled) {
        return new AltFindObjectsParameters.Builder(by, value).isEnabled(enabled).withCamera(cameraBy, cameraName).build();
    }

    public void getPNGScreeshot(String path) {
        new GetPNGScreenshotCommand(this.altBaseSettings, path).Execute();
    }

    public void setServerLogging(AltSetServerLoggingParameters parameters) {
        new AltUnitySetServerLogging(this.altBaseSettings, parameters).Execute();
    }

    @Deprecated
    public static void setupPortForwarding(String platform, String deviceID, int local_tcp_port, int remote_tcp_port) {
        log.info("Setting up port forward for " + platform + " on port " + remote_tcp_port);
        AltUnityDriver.removePortForwarding();
        if (platform.toLowerCase().equals("android".toLowerCase())) {
            try {
                String commandToRun = deviceID.equals("") ? "adb forward tcp:" + local_tcp_port + " tcp:" + remote_tcp_port : "adb -s " + deviceID + " forward  tcp:" + local_tcp_port + " tcp:" + remote_tcp_port;
                Runtime.getRuntime().exec(commandToRun);
                Thread.sleep(1000L);
                log.info("adb forward enabled.");
            }
            catch (Exception e) {
                log.warn("AltUnityServer - abd probably not installed\n" + e);
            }
        } else if (platform.toLowerCase().equals("ios".toLowerCase())) {
            try {
                String commandToRun = deviceID.equals("") ? "iproxy " + local_tcp_port + " " + remote_tcp_port + "&" : "iproxy " + local_tcp_port + " " + remote_tcp_port + " " + deviceID + "&";
                Runtime.getRuntime().exec(commandToRun);
                Thread.sleep(1000L);
                log.info("iproxy forward enabled.");
            }
            catch (Exception e) {
                log.warn("AltUnityServer - no iproxy process was running/present\n" + e);
            }
        }
    }

    @Deprecated
    public static void removePortForwarding() {
        String commandToExecute;
        try {
            commandToExecute = "killall iproxy";
            Runtime.getRuntime().exec(commandToExecute);
            Thread.sleep(1000L);
            log.info("Killed any iproxy process that may have been running...");
        }
        catch (Exception e) {
            log.warn("AltUnityServer - no iproxy process was running/present\n" + e);
        }
        try {
            commandToExecute = "adb forward --remove-all";
            Runtime.getRuntime().exec(commandToExecute);
            Thread.sleep(1000L);
            log.info("Removed existing adb forwarding...");
        }
        catch (Exception e) {
            log.warn("AltUnityServer - adb probably not installed\n" + e);
        }
    }

    static {
        AltUnityDriverConfigFactory custom = new AltUnityDriverConfigFactory();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)custom);
        log = LogManager.getLogger(AltUnityDriver.class);
    }

    public static enum By {
        TAG,
        LAYER,
        NAME,
        COMPONENT,
        PATH,
        ID,
        TEXT;

    }

    public static class PlayerPrefsKeyType {
        public static int IntType = 1;
        public static int StringType = 2;
        public static int FloatType = 3;
    }
}

