/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester.Commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ro.altom.altunitytester.AltBaseSettings;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityInvalidPathException;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityInvalidServerResponse;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityRecvallMessageFormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityRecvallMessageIdException;
import ro.altom.altunitytester.altUnityTesterExceptions.AssemblyNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.ComponentNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionException;
import ro.altom.altunitytester.altUnityTesterExceptions.CouldNotParseJsonStringException;
import ro.altom.altunitytester.altUnityTesterExceptions.CouldNotPerformOperationException;
import ro.altom.altunitytester.altUnityTesterExceptions.FailedToParseArgumentsException;
import ro.altom.altunitytester.altUnityTesterExceptions.FormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidParameterTypeException;
import ro.altom.altunitytester.altUnityTesterExceptions.MethodNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.MethodWithGivenParametersNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NullReferenceException;
import ro.altom.altunitytester.altUnityTesterExceptions.ObjectWasNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.PropertyNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.UnknownErrorException;

public class AltBaseCommand {
    protected static final Logger logger = LogManager.getLogger(AltBaseCommand.class);
    private static final int BUFFER_SIZE = 1024;
    private String messageId;
    public AltBaseSettings altBaseSettings;

    public AltBaseCommand(AltBaseSettings altBaseSettings) {
        this.altBaseSettings = altBaseSettings;
    }

    protected String recvall() {
        String receivedData = "";
        boolean streamIsFinished = false;
        int receivedZeroBytesCounter = 0;
        int receivedZeroBytesCounterLimit = 2;
        while (!streamIsFinished) {
            byte[] messageByte = new byte[1024];
            int bytesRead = 0;
            try {
                bytesRead = this.altBaseSettings.in.read(messageByte);
            }
            catch (IOException e) {
                throw new ConnectionException(e);
            }
            if (bytesRead <= 0) {
                if (receivedZeroBytesCounter < receivedZeroBytesCounterLimit) {
                    ++receivedZeroBytesCounter;
                    continue;
                }
                throw new ConnectionException(new Throwable("Received empty response"));
            }
            receivedData = receivedData + new String(messageByte, 0, bytesRead, StandardCharsets.UTF_8);
            if (!receivedData.contains("::altend")) continue;
            streamIsFinished = true;
        }
        logger.trace(receivedData);
        String[] parts = receivedData.split("altstart::|::response::|::altLog::|::altend", -1);
        if (parts.length != 5 || !parts[0].equals("") || !parts[4].equals("")) {
            throw new AltUnityRecvallMessageFormatException(String.format("Data received from socket doesn't have correct start and end control strings.\nGot:\n %s", receivedData));
        }
        if (!parts[1].equals(this.messageId)) {
            throw new AltUnityRecvallMessageIdException("Response received does not match command send. Expected message id: " + this.messageId + ". Got " + parts[1]);
        }
        receivedData = parts[2];
        String logData = parts[3];
        logger.debug("response: " + this.trimLogData(receivedData));
        if (logData != null && !logData.equals("")) {
            logger.debug(logData);
        }
        this.handleErrors(receivedData, logData);
        return receivedData;
    }

    protected void SendCommand(String ... arguments) {
        this.send(this.createCommand(arguments));
    }

    private void send(String message) {
        this.altBaseSettings.out.print(message);
        this.altBaseSettings.out.flush();
        logger.debug("sent: {}", (Object)message);
    }

    private String createCommand(String[] arguments) {
        String command = String.join((CharSequence)this.altBaseSettings.RequestSeparator, arguments);
        this.messageId = Long.toString(System.currentTimeMillis());
        command = String.join((CharSequence)this.altBaseSettings.RequestSeparator, this.messageId, command) + this.altBaseSettings.RequestEnd;
        return command;
    }

    private String trimLogData(String data) {
        return this.trimLogData(data, 10240);
    }

    private String trimLogData(String data, int maxSize) {
        if (data.length() > maxSize) {
            return data.substring(0, 10240) + "[...]";
        }
        return data;
    }

    protected void validateResponse(String expected, String received) {
        if (!expected.equals(received)) {
            throw new AltUnityInvalidServerResponse(expected, received);
        }
    }

    protected void handleErrors(String data) {
        this.handleErrors(data, "");
    }

    private void handleErrors(String data, String log) {
        String typeOfException = data.split(";")[0];
        if (!log.equals("")) {
            log = "\n" + log;
        }
        data = data + log;
        if ("error:notFound".equals(typeOfException)) {
            throw new NotFoundException(data);
        }
        if ("error:propertyNotFound".equals(typeOfException)) {
            throw new PropertyNotFoundException(data);
        }
        if ("error:methodNotFound".equals(typeOfException)) {
            throw new MethodNotFoundException(data);
        }
        if ("error:componentNotFound".equals(typeOfException)) {
            throw new ComponentNotFoundException(data);
        }
        if ("error:invalidParameterType".equals(typeOfException)) {
            throw new InvalidParameterTypeException(data);
        }
        if ("error:assemblyNotFound".equals(typeOfException)) {
            throw new AssemblyNotFoundException(data);
        }
        if ("error:couldNotPerformOperation".equals(typeOfException)) {
            throw new CouldNotPerformOperationException(data);
        }
        if ("error:couldNotParseJsonString".equals(typeOfException)) {
            throw new CouldNotParseJsonStringException(data);
        }
        if ("error:methodWithGivenParametersNotFound".equals(typeOfException)) {
            throw new MethodWithGivenParametersNotFoundException(data);
        }
        if ("error:failedToParseMethodArguments".equals(typeOfException)) {
            throw new FailedToParseArgumentsException(data);
        }
        if ("error:objectNotFound".equals(typeOfException)) {
            throw new ObjectWasNotFoundException(data);
        }
        if ("error:propertyCannotBeSet".equals(typeOfException)) {
            throw new PropertyNotFoundException(data);
        }
        if ("error:nullReferenceException".equals(typeOfException)) {
            throw new NullReferenceException(data);
        }
        if ("error:unknownError".equals(typeOfException)) {
            throw new UnknownErrorException(data);
        }
        if ("error:formatException".equals(typeOfException)) {
            throw new FormatException(data);
        }
        if ("error:invalidPath".equals(typeOfException)) {
            throw new AltUnityInvalidPathException(data);
        }
    }

    public String vectorToJsonString(int x, int y) {
        return "{\"x\":" + x + ", \"y\":" + y + "}";
    }

    public String vectorToJsonString(int x, int y, int z) {
        return "{\"x\":" + x + ", \"y\":" + y + ", \"z\":" + z + "}";
    }

    protected void sleepFor(double interval) {
        long timeToSleep = (long)(interval * 1000.0);
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            logger.warn("Could not sleep for " + timeToSleep + " ms");
        }
    }
}

