/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import ro.altom.altunitytester.AltUnityDriverConfigFactory;
import ro.altom.altunitytester.AltUnityObject;
import ro.altom.altunitytester.Commands.AltCallStaticMethod;
import ro.altom.altunitytester.Commands.AltCallStaticMethodParams;
import ro.altom.altunitytester.Commands.AltGetStaticProperty;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltSetServerLoggingParams;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnityAddNotificationListener;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnityAddNotificationListenerParams;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnityRemoveNotificationListener;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnityRemoveNotificationListenerParams;
import ro.altom.altunitytester.Commands.AltUnityCommands.AltUnitySetServerLogging;
import ro.altom.altunitytester.Commands.FindObject.AltFindObject;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectAtCoordinates;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectAtCoordinatesParams;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjects;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsParams;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsWhichContain;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElements;
import ro.altom.altunitytester.Commands.FindObject.AltGetAllElementsParams;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObject;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectToNotBePresent;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectWhichContains;
import ro.altom.altunitytester.Commands.FindObject.AltWaitForObjectsParams;
import ro.altom.altunitytester.Commands.GetPNGScreenshotCommand;
import ro.altom.altunitytester.Commands.GetServerVersionCommand;
import ro.altom.altunitytester.Commands.InputActions.AltBeginTouch;
import ro.altom.altunitytester.Commands.InputActions.AltBeginTouchParams;
import ro.altom.altunitytester.Commands.InputActions.AltClickCoordinates;
import ro.altom.altunitytester.Commands.InputActions.AltEndTouch;
import ro.altom.altunitytester.Commands.InputActions.AltEndTouchParams;
import ro.altom.altunitytester.Commands.InputActions.AltHoldParams;
import ro.altom.altunitytester.Commands.InputActions.AltKeyDown;
import ro.altom.altunitytester.Commands.InputActions.AltKeyDownParams;
import ro.altom.altunitytester.Commands.InputActions.AltKeyUp;
import ro.altom.altunitytester.Commands.InputActions.AltKeyUpParams;
import ro.altom.altunitytester.Commands.InputActions.AltKeysDown;
import ro.altom.altunitytester.Commands.InputActions.AltKeysDownParams;
import ro.altom.altunitytester.Commands.InputActions.AltKeysUp;
import ro.altom.altunitytester.Commands.InputActions.AltKeysUpParams;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouse;
import ro.altom.altunitytester.Commands.InputActions.AltMoveMouseParams;
import ro.altom.altunitytester.Commands.InputActions.AltMoveTouch;
import ro.altom.altunitytester.Commands.InputActions.AltMoveTouchParams;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltMultiPointSwipeParams;
import ro.altom.altunitytester.Commands.InputActions.AltPressKey;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeyParams;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeys;
import ro.altom.altunitytester.Commands.InputActions.AltPressKeysParams;
import ro.altom.altunitytester.Commands.InputActions.AltScroll;
import ro.altom.altunitytester.Commands.InputActions.AltScrollParams;
import ro.altom.altunitytester.Commands.InputActions.AltSwipe;
import ro.altom.altunitytester.Commands.InputActions.AltSwipeParams;
import ro.altom.altunitytester.Commands.InputActions.AltTapClickCoordinatesParams;
import ro.altom.altunitytester.Commands.InputActions.AltTapCoordinates;
import ro.altom.altunitytester.Commands.InputActions.AltTilt;
import ro.altom.altunitytester.Commands.InputActions.AltTiltParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetComponentPropertyParams;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeleteKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltDeletePlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltFloatGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetAllLoadedScenes;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetCurrentScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltGetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltIntGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltLoadScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltLoadSceneParams;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetTimeScale;
import ro.altom.altunitytester.Commands.UnityCommand.AltSetTimeScaleParams;
import ro.altom.altunitytester.Commands.UnityCommand.AltStringGetKeyPlayerPref;
import ro.altom.altunitytester.Commands.UnityCommand.AltUnloadScene;
import ro.altom.altunitytester.Commands.UnityCommand.AltUnloadSceneParams;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBe;
import ro.altom.altunitytester.Commands.UnityCommand.AltWaitForCurrentSceneToBeParams;
import ro.altom.altunitytester.Utils;
import ro.altom.altunitytester.WebsocketConnection;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidParameterException;

public class AltUnityDriver {
    private static final Logger log;
    public static final String VERSION = "1.7.2";
    public static final int READ_TIMEOUT = 5000;
    private WebsocketConnection connection = null;

    public AltUnityDriver() {
        this("127.0.0.1", 13000);
    }

    public AltUnityDriver(String host, int port) {
        this(host, port, false);
    }

    public AltUnityDriver(String host, int port, Boolean enableLogging) {
        this(host, port, enableLogging, 60);
    }

    public AltUnityDriver(String host, int port, Boolean enableLogging, int connectTimeout) {
        if (!enableLogging.booleanValue()) {
            AltUnityDriverConfigFactory.DisableLogging();
        }
        if (host == null || host.isEmpty()) {
            throw new InvalidParameterException("Provided host address is null or empty");
        }
        this.connection = new WebsocketConnection(host, port, connectTimeout);
        this.connection.connect();
        this.checkServerVersion();
    }

    private String[] splitVersion(String version) {
        String[] parts = version.split("\\.");
        return new String[]{parts[0], parts.length > 1 ? parts[1] : ""};
    }

    private void checkServerVersion() {
        String serverVersion = this.getServerVersion();
        String[] parts = this.splitVersion(serverVersion);
        String majorServer = parts[0];
        String minorServer = parts[1];
        parts = this.splitVersion(VERSION);
        String majorDriver = parts[0];
        String minorDriver = parts[1];
        if (!majorServer.equals(majorDriver) || !minorServer.equals(minorDriver)) {
            String message = String.format("Version mismatch. AltUnity Driver version is %s. AltUnity Tester version is %s.", VERSION, serverVersion);
            log.warn(message);
            System.out.println(message);
        }
    }

    public void stop() throws IOException {
        this.connection.close();
    }

    public String getServerVersion() {
        return new GetServerVersionCommand(this.connection.messageHandler).Execute();
    }

    public double getDelayAfterCommand() {
        return this.connection.messageHandler.getDelayAfterCommand();
    }

    public void setDelayAfterCommand(double delay) {
        this.connection.messageHandler.setDelayAfterCommand(delay);
    }

    public void loadScene(AltLoadSceneParams altLoadSceneParameters) {
        new AltLoadScene(this.connection.messageHandler, altLoadSceneParameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void unloadScene(AltUnloadSceneParams unloadSceneParams) {
        new AltUnloadScene(this.connection.messageHandler, unloadSceneParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public String[] getAllLoadedScenes() {
        String[] response = new AltGetAllLoadedScenes(this.connection.messageHandler).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void setCommandResponseTimeout(int timeout) {
        this.connection.messageHandler.setCommandTimeout(timeout);
    }

    public void deletePlayerPref() {
        new AltDeletePlayerPref(this.connection.messageHandler).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void deleteKeyPlayerPref(String keyName) {
        new AltDeleteKeyPlayerPref(this.connection.messageHandler, keyName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void setKeyPlayerPref(String keyName, int valueName) {
        new AltSetKeyPlayerPref(this.connection.messageHandler, keyName, valueName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void setKeyPlayerPref(String keyName, float valueName) {
        new AltSetKeyPlayerPref(this.connection.messageHandler, keyName, valueName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void setKeyPlayerPref(String keyName, String valueName) {
        new AltSetKeyPlayerPref(this.connection.messageHandler, keyName, valueName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public int getIntKeyPlayerPref(String keyName) {
        int response = new AltIntGetKeyPlayerPref(this.connection.messageHandler, keyName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public float getFloatKeyPlayerPref(String keyName) {
        float response = new AltFloatGetKeyPlayerPref(this.connection.messageHandler, keyName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public String getStringKeyPlayerPref(String keyName) {
        String response = new AltStringGetKeyPlayerPref(this.connection.messageHandler, keyName).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public String getCurrentScene() {
        String response = new AltGetCurrentScene(this.connection.messageHandler).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public float getTimeScale() {
        float response = new AltGetTimeScale(this.connection.messageHandler).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void setTimeScale(AltSetTimeScaleParams setTimescaleParams) {
        new AltSetTimeScale(this.connection.messageHandler, setTimescaleParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public <T> T callStaticMethod(AltCallStaticMethodParams altCallStaticMethodParams, Class<T> returnType) {
        T response = new AltCallStaticMethod(this.connection.messageHandler, altCallStaticMethodParams).Execute(returnType);
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void swipe(AltSwipeParams swipeParams) {
        new AltSwipe(this.connection.messageHandler, swipeParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void multipointSwipe(AltMultiPointSwipeParams parameters) {
        new AltMultiPointSwipe(this.connection.messageHandler, parameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void holdButton(AltHoldParams holdParams) {
        this.swipe(holdParams);
    }

    public void tilt(AltTiltParams altTiltParameter) {
        new AltTilt(this.connection.messageHandler, altTiltParameter).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void pressKey(AltPressKeyParams altPressKeyParameters) {
        new AltPressKey(this.connection.messageHandler, altPressKeyParameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void pressKeys(AltPressKeysParams altPressKeysParameters) {
        new AltPressKeys(this.connection.messageHandler, altPressKeysParameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void keyDown(AltKeyDownParams keyDownParams) throws InterruptedException {
        new AltKeyDown(this.connection.messageHandler, keyDownParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void keysDown(AltKeysDownParams keysDownParams) {
        new AltKeysDown(this.connection.messageHandler, keysDownParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void keyUp(AltKeyUpParams keyUpParams) {
        new AltKeyUp(this.connection.messageHandler, keyUpParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void keysUp(AltKeysUpParams keysUpParams) {
        new AltKeysUp(this.connection.messageHandler, keysUpParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void moveMouse(AltMoveMouseParams altMoveMouseParams) {
        new AltMoveMouse(this.connection.messageHandler, altMoveMouseParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void scroll(AltScrollParams altScrollParams) {
        new AltScroll(this.connection.messageHandler, altScrollParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public AltUnityObject findObject(AltFindObjectsParams altFindObjectsParams) {
        AltUnityObject response = new AltFindObject(this.connection.messageHandler, altFindObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject findObjectWhichContains(AltFindObjectsParams altFindObjectsParams) {
        AltUnityObject response = new AltFindObjectWhichContains(this.connection.messageHandler, altFindObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject[] findObjects(AltFindObjectsParams altFindObjectsParams) {
        AltUnityObject[] response = new AltFindObjects(this.connection.messageHandler, altFindObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject[] findObjectsWhichContain(AltFindObjectsParams altFindObjectsParams) {
        AltUnityObject[] response = new AltFindObjectsWhichContain(this.connection.messageHandler, altFindObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject[] getAllElements(AltGetAllElementsParams altGetAllElementsParams) {
        AltUnityObject[] response = new AltGetAllElements(this.connection.messageHandler, altGetAllElementsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void waitForCurrentSceneToBe(AltWaitForCurrentSceneToBeParams altWaitForCurrentSceneToBeParameters) {
        new AltWaitForCurrentSceneToBe(this.connection.messageHandler, altWaitForCurrentSceneToBeParameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public AltUnityObject waitForObject(AltWaitForObjectsParams altWaitForObjectsParams) {
        AltUnityObject response = new AltWaitForObject(this.connection.messageHandler, altWaitForObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void waitForObjectToNotBePresent(AltWaitForObjectsParams altWaitForObjectsParams) {
        new AltWaitForObjectToNotBePresent(this.connection.messageHandler, altWaitForObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public AltUnityObject waitForObjectWhichContains(AltWaitForObjectsParams altWaitForObjectsParams) {
        AltUnityObject response = new AltWaitForObjectWhichContains(this.connection.messageHandler, altWaitForObjectsParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void getPNGScreenshot(String path) {
        new GetPNGScreenshotCommand(this.connection.messageHandler, path).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void setServerLogging(AltSetServerLoggingParams parameters) {
        new AltUnitySetServerLogging(this.connection.messageHandler, parameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public int beginTouch(AltBeginTouchParams beginTouchParams) {
        int response = new AltBeginTouch(this.connection.messageHandler, beginTouchParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void moveTouch(AltMoveTouchParams moveTouchParams) {
        new AltMoveTouch(this.connection.messageHandler, moveTouchParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void endTouch(AltEndTouchParams endTouchParams) {
        new AltEndTouch(this.connection.messageHandler, endTouchParams).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void tap(AltTapClickCoordinatesParams parameters) {
        new AltTapCoordinates(this.connection.messageHandler, parameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public void click(AltTapClickCoordinatesParams parameters) {
        new AltClickCoordinates(this.connection.messageHandler, parameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
    }

    public <T> T getStaticProperty(AltGetComponentPropertyParams parameters, Class<T> returnType) {
        T response = new AltGetStaticProperty(this.connection.messageHandler, parameters).Execute(returnType);
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject findObjectAtCoordinates(AltFindObjectAtCoordinatesParams parameters) {
        AltUnityObject response = new AltFindObjectAtCoordinates(this.connection.messageHandler, parameters).Execute();
        Utils.sleepFor(this.connection.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void addNotification(AltUnityAddNotificationListenerParams parameters) {
        new AltUnityAddNotificationListener(this.connection.messageHandler, parameters).Execute();
    }

    public void removeNotificationListener(AltUnityRemoveNotificationListenerParams notificationType) {
        new AltUnityRemoveNotificationListener(this.connection.messageHandler, notificationType).Execute();
    }

    static {
        AltUnityDriverConfigFactory custom = new AltUnityDriverConfigFactory();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)custom);
        log = LogManager.getLogger(AltUnityDriver.class);
    }

    public static enum By {
        TAG,
        LAYER,
        NAME,
        COMPONENT,
        PATH,
        ID,
        TEXT;

    }

    public static enum PlayerPrefsKeyType {
        Int(1),
        String(2),
        Float(3);

        private int val;

        private PlayerPrefsKeyType(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }
}

