/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="AltUnityDriverConfigFactory", category="ConfigurationFactory")
@Order(value=50)
public class AltUnityDriverConfigFactory
extends ConfigurationFactory {
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationBuilder builder = AltUnityDriverConfigFactory.newConfigurationBuilder();
        return AltUnityDriverConfigFactory.createConfiguration(name, (ConfigurationBuilder<BuiltConfiguration>)builder);
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public static void DisableLogging() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.getLoggerConfig("ro.altom.altunitytester").setLevel(Level.OFF);
        ctx.updateLoggers();
    }

    static Configuration createConfiguration(String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName(name);
        AppenderComponentBuilder consoleAppender = (AppenderComponentBuilder)builder.newAppender("AltUnityConsoleAppender", "Console").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        builder.add(consoleAppender);
        AppenderComponentBuilder fileAppender = (AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("AltUnityFileAppender", "File").addAttribute("fileName", "./AltUnityTesterLog.txt")).addAttribute("append", false);
        builder.add(fileAppender);
        LayoutComponentBuilder standard = builder.newLayout("PatternLayout");
        standard.addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable");
        consoleAppender.add(standard);
        fileAppender.add(standard);
        LoggerComponentBuilder logger = builder.newLogger("ro.altom.altunitytester", Level.DEBUG);
        logger.add(builder.newAppenderRef("AltUnityConsoleAppender"));
        logger.add(builder.newAppenderRef("AltUnityFileAppender"));
        logger.addAttribute("additivity", false);
        builder.add(logger);
        return (Configuration)builder.build();
    }
}

