/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import ro.altom.altunitytester.AltUnityDriver;
import ro.altom.altunitytester.Commands.FindObject.AltFindObject;
import ro.altom.altunitytester.Commands.FindObject.AltFindObjectsParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltCallComponentMethod;
import ro.altom.altunitytester.Commands.ObjectCommand.AltCallComponentMethodParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltClickElement;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetComponentProperty;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetComponentPropertyParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetText;
import ro.altom.altunitytester.Commands.ObjectCommand.AltGetTextParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSendActionAndEvaluateResult;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetComponentProperty;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetComponentPropertyParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetText;
import ro.altom.altunitytester.Commands.ObjectCommand.AltSetTextParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltTapClickElementParams;
import ro.altom.altunitytester.Commands.ObjectCommand.AltTapElement;
import ro.altom.altunitytester.IMessageHandler;
import ro.altom.altunitytester.Utils;
import ro.altom.altunitytester.position.Vector2;
import ro.altom.altunitytester.position.Vector3;

public class AltUnityObject {
    public String name;
    public int id;
    public int x;
    public int y;
    public int z;
    public int mobileY;
    public String type;
    public boolean enabled;
    public float worldX;
    public float worldY;
    public float worldZ;
    public int idCamera;
    public int transformParentId;
    public int transformId;
    private transient IMessageHandler messageHandler;

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMesssageHandler(IMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public AltUnityObject() {
    }

    public AltUnityObject(String name, int id, int x, int y, int z, int mobileY, String type, boolean enabled, float worldX, float worldY, float worldZ, int idCamera, int transformParentId, int transformId) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mobileY = mobileY;
        this.type = type;
        this.enabled = enabled;
        this.worldX = worldX;
        this.worldY = worldY;
        this.worldZ = worldZ;
        this.idCamera = idCamera;
        this.transformId = transformId;
        this.transformParentId = transformParentId;
    }

    public AltUnityObject getParent() {
        AltFindObjectsParams altFindObjectsParameters = new AltFindObjectsParams.Builder(AltUnityDriver.By.PATH, "//*[@id=" + this.id + "]/..").build();
        AltUnityObject response = new AltFindObject(this.messageHandler, altFindObjectsParameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public Vector2 getScreenPosition() {
        return new Vector2(this.x, this.y);
    }

    public Vector3 getWorldPosition() {
        return new Vector3(this.worldX, this.worldY, this.worldZ);
    }

    public <T> T getComponentProperty(AltGetComponentPropertyParams altGetComponentPropertyParameters, Class<T> returnType) {
        altGetComponentPropertyParameters.setAltUnityObject(this);
        T response = new AltGetComponentProperty(this.messageHandler, altGetComponentPropertyParameters).Execute(returnType);
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public void setComponentProperty(AltSetComponentPropertyParams altSetComponentPropertyParameters) {
        altSetComponentPropertyParameters.setAltUnityObject(this);
        new AltSetComponentProperty(this.messageHandler, altSetComponentPropertyParameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
    }

    public <T> T callComponentMethod(AltCallComponentMethodParams altCallComponentMethodParameters, Class<T> returnType) {
        altCallComponentMethodParameters.setAltUnityObject(this);
        T response = new AltCallComponentMethod(this.messageHandler, altCallComponentMethodParameters).Execute(returnType);
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public String getText() {
        AltGetTextParams altGetTextParameters = new AltGetTextParams(this);
        String response = new AltGetText(this.messageHandler, altGetTextParameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject setText(String text) {
        AltSetTextParams parameters = new AltSetTextParams.Builder(text).build();
        parameters.setAltUnityObject(this);
        AltUnityObject response = new AltSetText(this.messageHandler, parameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject setText(AltSetTextParams parameters) {
        parameters.setAltUnityObject(this);
        AltUnityObject response = new AltSetText(this.messageHandler, parameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public AltUnityObject pointerUp() {
        return this.sendActionAndEvaluateResult("pointerUpFromObject");
    }

    public AltUnityObject pointerDown() {
        return this.sendActionAndEvaluateResult("pointerDownFromObject");
    }

    public AltUnityObject pointerEnter() {
        return this.sendActionAndEvaluateResult("pointerEnterObject");
    }

    public AltUnityObject pointerExit() {
        return this.sendActionAndEvaluateResult("pointerExitObject");
    }

    public AltUnityObject tap() {
        return this.tap(new AltTapClickElementParams.Builder().build());
    }

    public AltUnityObject tap(AltTapClickElementParams parameters) {
        parameters.setAltUnityObject(this);
        return new AltTapElement(this.messageHandler, parameters).Execute();
    }

    public AltUnityObject click() {
        AltTapClickElementParams params = new AltTapClickElementParams.Builder().build();
        return this.click(params);
    }

    public AltUnityObject click(AltTapClickElementParams parameters) {
        parameters.setAltUnityObject(this);
        AltUnityObject response = new AltClickElement(this.messageHandler, parameters).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    private AltUnityObject sendActionAndEvaluateResult(String command) {
        AltUnityObject response = new AltSendActionAndEvaluateResult(this.messageHandler, this, command).Execute();
        Utils.sleepFor(this.messageHandler.getDelayAfterCommand());
        return response;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getMobileY() {
        return this.mobileY;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldZ() {
        return this.worldZ;
    }

    public int getIdCamera() {
        return this.idCamera;
    }

    public int getTransformParentId() {
        return this.transformParentId;
    }

    public int getTransformId() {
        return this.transformId;
    }
}

