/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ro.altom.altunitytester.altUnityTesterExceptions.PortForwardingException;

public class AltUnityPortForwarding {
    private static final Logger log = LogManager.getLogger(AltUnityPortForwarding.class);

    public static String getAdbPath(String adbPath) {
        if (adbPath != null && !adbPath.isEmpty()) {
            return adbPath;
        }
        String androidSdkRoot = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRoot != null && !androidSdkRoot.isEmpty()) {
            return Paths.get(androidSdkRoot, "platform-tools", "adb").toString();
        }
        return "adb";
    }

    public static String getIproxyPath(String iproxyPath) {
        if (iproxyPath != null && !iproxyPath.isEmpty()) {
            return iproxyPath;
        }
        return "iproxy";
    }

    public static void forwardAndroid() {
        AltUnityPortForwarding.forwardAndroid(13000, 13000, "", "");
    }

    public static void forwardAndroid(int localPort) {
        AltUnityPortForwarding.forwardAndroid(localPort, 13000, "", "");
    }

    public static void forwardAndroid(int localPort, int remotePort) {
        AltUnityPortForwarding.forwardAndroid(localPort, remotePort, "", "");
    }

    public static void forwardAndroid(int localPort, int remotePort, String deviceId) {
        AltUnityPortForwarding.forwardAndroid(localPort, remotePort, deviceId, "");
    }

    public static void forwardAndroid(int localPort, int remotePort, String deviceId, String adbPath) {
        adbPath = AltUnityPortForwarding.getAdbPath(adbPath);
        log.debug("Setting up port forward for android local port " + localPort + " remote port: " + remotePort);
        String command = deviceId.equals("") ? adbPath + " forward tcp:" + localPort + " tcp:" + remotePort : adbPath + " -s " + deviceId + " forward  tcp:" + localPort + " tcp:" + remotePort;
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            throw new PortForwardingException("An exception occurred while running command: " + command, ex);
        }
        log.debug("adb forward enabled.");
    }

    public static void removeForwardAndroid() {
        AltUnityPortForwarding.removeForwardAndroid(13000, "", "");
    }

    public static void removeForwardAndroid(int localPort) {
        AltUnityPortForwarding.removeForwardAndroid(localPort, "", "");
    }

    public static void removeForwardAndroid(int localPort, String deviceId) {
        AltUnityPortForwarding.removeForwardAndroid(localPort, deviceId, "");
    }

    public static void removeForwardAndroid(int localPort, String deviceId, String adbPath) {
        adbPath = AltUnityPortForwarding.getAdbPath(adbPath);
        log.debug("Removing android forward localPort: " + localPort + " deviceId: " + deviceId);
        String arguments = "forward --remove tcp:" + localPort;
        if (deviceId != null && !deviceId.isEmpty()) {
            arguments = "-s " + deviceId + " " + arguments;
        }
        String command = adbPath + " " + arguments;
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            throw new PortForwardingException("An exception occurred while running command: " + command, ex);
        }
        log.debug("Android forward removed...");
    }

    public static void removeAllForwardAndroid() {
        AltUnityPortForwarding.removeAllForwardAndroid("");
    }

    public static void removeAllForwardAndroid(String adbPath) {
        adbPath = AltUnityPortForwarding.getAdbPath(adbPath);
        String command = adbPath + " forward --remove-all";
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            throw new PortForwardingException("An exception occurred while running command: " + command, ex);
        }
        log.debug("Removed all existing adb forwarding...");
    }

    public static void forwardIos() throws IOException {
        AltUnityPortForwarding.forwardIos(13000, 13000, "", "");
    }

    public static void forwardIos(int localPort) throws IOException {
        AltUnityPortForwarding.forwardIos(localPort, 13000, "", "");
    }

    public static void forwardIos(int localPort, int devicePort) throws IOException {
        AltUnityPortForwarding.forwardIos(localPort, devicePort, "", "");
    }

    public static void forwardIos(int localPort, int devicePort, String deviceId) throws IOException {
        AltUnityPortForwarding.forwardIos(localPort, devicePort, deviceId, "");
    }

    public static void forwardIos(int localPort, int devicePort, String deviceId, String iproxyPath) throws IOException {
        iproxyPath = AltUnityPortForwarding.getIproxyPath(iproxyPath);
        String arguments = deviceId == null || deviceId.isEmpty() ? localPort + " " + devicePort : localPort + " " + devicePort + " -u " + deviceId;
        String command = iproxyPath + " " + arguments;
        Runtime.getRuntime().exec(command);
        log.debug("iproxy forward enabled.");
    }

    public static void killAllIproxyProcess() {
        String command = "killall iproxy";
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            throw new PortForwardingException("An exception occurred while running command: " + command, ex);
        }
        log.debug("Killed any iproxy process that may have been running...");
    }
}

