/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester.Commands.InputActions;

import ro.altom.altunitytester.AltMessage;
import ro.altom.altunitytester.position.Vector2;

public class AltSwipeParams
extends AltMessage {
    protected Vector2 start;
    protected Vector2 end;
    protected float duration;
    protected boolean wait;

    protected AltSwipeParams() {
        this.setCommandName("swipe");
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public Vector2 getStart() {
        return this.start;
    }

    public void setStart(Vector2 start) {
        this.start = start;
    }

    public Vector2 getEnd() {
        return this.end;
    }

    public void setEnd(Vector2 end) {
        this.end = end;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public static class Builder {
        private Vector2 start;
        private Vector2 end;
        private float duration = 0.1f;
        private boolean wait = true;

        public Builder(Vector2 start, Vector2 end) {
            this.start = start;
            this.end = end;
        }

        public Builder withStart(Vector2 start) {
            this.start = start;
            return this;
        }

        public Builder withEnd(Vector2 end) {
            this.end = end;
            return this;
        }

        public Builder withDuration(float duration) {
            this.duration = duration;
            return this;
        }

        public Builder withWait(boolean wait) {
            this.wait = wait;
            return this;
        }

        public AltSwipeParams build() {
            AltSwipeParams altTiltParameters = new AltSwipeParams();
            altTiltParameters.start = this.start;
            altTiltParameters.end = this.end;
            altTiltParameters.duration = this.duration;
            altTiltParameters.wait = this.wait;
            return altTiltParameters;
        }
    }
}

