/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.websocket.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ro.altom.altunitytester.AltMessage;
import ro.altom.altunitytester.AltMessageResponse;
import ro.altom.altunitytester.CommandError;
import ro.altom.altunitytester.Commands.AltUnityCommands.NotificationType;
import ro.altom.altunitytester.IMessageHandler;
import ro.altom.altunitytester.Notifications.AltUnityLoadSceneNotificationResultParams;
import ro.altom.altunitytester.Notifications.AltUnityLogNotificationResultParams;
import ro.altom.altunitytester.Notifications.INotificationCallbacks;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityException;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityInputModuleException;
import ro.altom.altunitytester.altUnityTesterExceptions.AltUnityRecvallException;
import ro.altom.altunitytester.altUnityTesterExceptions.AssemblyNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.CameraNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.CommandResponseTimeoutException;
import ro.altom.altunitytester.altUnityTesterExceptions.ComponentNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.CouldNotPerformOperationException;
import ro.altom.altunitytester.altUnityTesterExceptions.FailedToParseArgumentsException;
import ro.altom.altunitytester.altUnityTesterExceptions.FormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidCommandException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidParameterTypeException;
import ro.altom.altunitytester.altUnityTesterExceptions.InvalidPathException;
import ro.altom.altunitytester.altUnityTesterExceptions.MethodNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.MethodWithGivenParametersNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.NullReferenceException;
import ro.altom.altunitytester.altUnityTesterExceptions.ObjectWasNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.PropertyNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.ResponseFormatException;
import ro.altom.altunitytester.altUnityTesterExceptions.SceneNotFoundException;
import ro.altom.altunitytester.altUnityTesterExceptions.UnknownErrorException;

public class MessageHandler
implements IMessageHandler {
    private Session session;
    private Queue<AltMessageResponse> responses = new LinkedList<AltMessageResponse>();
    private static final Logger logger = LogManager.getLogger(MessageHandler.class);
    private List<INotificationCallbacks> loadSceneNotificationList = new ArrayList<INotificationCallbacks>();
    private List<INotificationCallbacks> unloadSceneNotificationList = new ArrayList<INotificationCallbacks>();
    private List<INotificationCallbacks> logNotificationList = new ArrayList<INotificationCallbacks>();
    private List<INotificationCallbacks> applicationPausedNotificationList = new ArrayList<INotificationCallbacks>();
    private List<String> messageIdTimeout = new ArrayList<String>();
    private double commandTimeout = 60.0;
    private double delayAfterCommand = 0.0;

    public MessageHandler(Session session) {
        this.session = session;
    }

    @Override
    public double getDelayAfterCommand() {
        return this.delayAfterCommand;
    }

    @Override
    public void setDelayAfterCommand(double delay) {
        this.delayAfterCommand = delay;
    }

    @Override
    public <T> T receive(AltMessage data, Class<T> type) {
        AltMessageResponse responseMessage;
        double time = 0.0;
        double delay = 0.1;
        long sleepDelay = (long)(delay * 1000.0);
        while (true) {
            if (this.responses.isEmpty() && this.session.isOpen() && this.commandTimeout >= time) {
                try {
                    Thread.sleep(sleepDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                time += delay;
                continue;
            }
            if (this.commandTimeout < time && this.session.isOpen()) {
                this.messageIdTimeout.add(data.messageId());
                throw new CommandResponseTimeoutException();
            }
            if (!this.session.isOpen()) {
                throw new AltUnityException("Driver disconnected");
            }
            responseMessage = this.responses.remove();
            if (!this.messageIdTimeout.contains(responseMessage.messageId)) break;
        }
        if (!(responseMessage.error != null && responseMessage.error.type == "invalidCommand" || responseMessage.messageId.equals(data.messageId()) && responseMessage.commandName.equals(data.getCommandName()))) {
            throw new AltUnityRecvallException(String.format("Response received does not match command send. Expected %s:%s. Got %s:%s", data.getCommandName(), data.messageId(), responseMessage.commandName, responseMessage.messageId));
        }
        this.handleErrors(responseMessage.error);
        try {
            Object response = new Gson().fromJson(responseMessage.data, type);
            return (T)response;
        }
        catch (JsonParseException ex) {
            throw new ResponseFormatException(type, responseMessage.data);
        }
    }

    @Override
    public void send(AltMessage altMessage) {
        String message = new Gson().toJson((Object)altMessage);
        this.session.getAsyncRemote().sendText(message);
        logger.debug("command sent: {}", (Object)this.trimLogData(message));
    }

    @Override
    public void onMessage(String message) {
        logger.debug("response received: {}", (Object)this.trimLogData(message));
        AltMessageResponse response = (AltMessageResponse)new Gson().fromJson(message, AltMessageResponse.class);
        if (response.isNotification.booleanValue()) {
            this.handleNotification(response);
        } else {
            this.responses.add(response);
        }
    }

    private void handleNotification(AltMessageResponse message) {
        switch (message.commandName) {
            case "loadSceneNotification": {
                AltUnityLoadSceneNotificationResultParams data = (AltUnityLoadSceneNotificationResultParams)new Gson().fromJson(message.data, AltUnityLoadSceneNotificationResultParams.class);
                for (INotificationCallbacks callback : this.loadSceneNotificationList) {
                    callback.SceneLoadedCallBack(data);
                }
                break;
            }
            case "unloadSceneNotification": {
                String sceneName = (String)new Gson().fromJson(message.data, String.class);
                for (INotificationCallbacks callback : this.unloadSceneNotificationList) {
                    callback.SceneUnloadedCallBack(sceneName);
                }
                break;
            }
            case "logNotification": {
                AltUnityLogNotificationResultParams data1 = (AltUnityLogNotificationResultParams)new Gson().fromJson(message.data, AltUnityLogNotificationResultParams.class);
                for (INotificationCallbacks callback : this.logNotificationList) {
                    callback.LogCallBack(data1);
                }
                break;
            }
            case "applicationPausedNotification": {
                Boolean data2 = (Boolean)new Gson().fromJson(message.data, Boolean.class);
                for (INotificationCallbacks callback : this.applicationPausedNotificationList) {
                    callback.ApplicationPausedCallBack(data2);
                }
                break;
            }
        }
    }

    private void handleErrors(CommandError error) {
        if (error == null) {
            return;
        }
        logger.error(error.type + ": " + error.message);
        logger.error(error.trace);
        switch (error.type) {
            case "notFound": {
                throw new NotFoundException(error.message);
            }
            case "sceneNotFound": {
                throw new SceneNotFoundException(error.message);
            }
            case "propertyNotFound": {
                throw new PropertyNotFoundException(error.message);
            }
            case "methodNotFound": {
                throw new MethodNotFoundException(error.message);
            }
            case "componentNotFound": {
                throw new ComponentNotFoundException(error.message);
            }
            case "assemblyNotFound": {
                throw new AssemblyNotFoundException(error.message);
            }
            case "couldNotPerformOperation": {
                throw new CouldNotPerformOperationException(error.message);
            }
            case "methodWithGivenParametersNotFound": {
                throw new MethodWithGivenParametersNotFoundException(error.message);
            }
            case "failedToParseMethodArguments": {
                throw new FailedToParseArgumentsException(error.message);
            }
            case "invalidParameterType": {
                throw new InvalidParameterTypeException(error.message);
            }
            case "objectNotFound": {
                throw new ObjectWasNotFoundException(error.message);
            }
            case "propertyCannotBeSet": {
                throw new PropertyNotFoundException(error.message);
            }
            case "nullReferenceException": {
                throw new NullReferenceException(error.message);
            }
            case "unknownError": {
                throw new UnknownErrorException(error.message);
            }
            case "formatException": {
                throw new FormatException(error.message);
            }
            case "invalidPath": {
                throw new InvalidPathException(error.message);
            }
            case "invalidCommand": {
                throw new InvalidCommandException(error.message);
            }
            case "ALTUNITYTESTERNotAddedAsDefineVariable": {
                throw new AltUnityInputModuleException(error.message);
            }
            case "cameraNotFound": {
                throw new CameraNotFoundException(error.message);
            }
        }
        logger.error(error.type + " is not handled by driver.");
        throw new UnknownErrorException(error.message);
    }

    @Override
    public void setCommandTimeout(int timeout) {
        this.commandTimeout = timeout;
    }

    private String trimLogData(String data) {
        return this.trimLogData(data, 10240);
    }

    private String trimLogData(String data, int maxSize) {
        if (data.length() > maxSize) {
            return data.substring(0, 10240) + "[...]";
        }
        return data;
    }

    @Override
    public void addNotificationListener(NotificationType notificationType, INotificationCallbacks callbacks, boolean overwrite) {
        switch (notificationType) {
            case LOADSCENE: {
                if (overwrite) {
                    this.loadSceneNotificationList.clear();
                }
                this.loadSceneNotificationList.add(callbacks);
                break;
            }
            case UNLOADSCENE: {
                if (overwrite) {
                    this.unloadSceneNotificationList.clear();
                }
                this.unloadSceneNotificationList.add(callbacks);
                break;
            }
            case LOG: {
                if (overwrite) {
                    this.logNotificationList.clear();
                }
                this.logNotificationList.add(callbacks);
                break;
            }
            case APPLICATION_PAUSED: {
                if (overwrite) {
                    this.applicationPausedNotificationList.clear();
                }
                this.applicationPausedNotificationList.add(callbacks);
                break;
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationType notificationType) {
        switch (notificationType) {
            case LOADSCENE: {
                this.loadSceneNotificationList.clear();
                break;
            }
            case UNLOADSCENE: {
                this.unloadSceneNotificationList.clear();
                break;
            }
            case LOG: {
                this.logNotificationList.clear();
                break;
            }
            case APPLICATION_PAUSED: {
                this.applicationPausedNotificationList.clear();
                break;
            }
        }
    }
}

