/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.altunitytester;

import java.io.IOException;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ro.altom.altunitytester.AltUnityDriver;
import ro.altom.altunitytester.IMessageHandler;
import ro.altom.altunitytester.MessageHandler;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionException;
import ro.altom.altunitytester.altUnityTesterExceptions.ConnectionTimeoutException;

@ClientEndpoint
public class WebsocketConnection {
    private static final Logger logger = LogManager.getLogger(AltUnityDriver.class);
    private String _uri;
    private String _host;
    private int _port;
    private int _connectTimeout;
    public Session session = null;
    public IMessageHandler messageHandler = null;

    @OnOpen
    public void onOpen(Session session) {
        logger.debug("Connected to: " + this._uri);
        this.session = session;
        this.messageHandler = new MessageHandler(session);
    }

    @OnMessage
    public void onMessage(String message) {
        this.messageHandler.onMessage(message);
    }

    @OnError
    public void onError(Throwable th) {
        logger.error(th.getMessage());
        logger.error((Object)th);
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        logger.debug("Connection to AltUnity closed: {}.", (Object)reason.toString());
    }

    public WebsocketConnection(String host, int port, int connectTimeout) {
        this._host = host;
        this._port = port;
        this._uri = "ws://" + host + ":" + port + "/altws/";
        this._connectTimeout = connectTimeout;
    }

    public void connect() {
        int delay = 100;
        logger.info("Connecting to host: {} port: {}.", (Object)this._host, (Object)this._port);
        long start = System.currentTimeMillis();
        long finish = System.currentTimeMillis();
        int retries = 0;
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        Throwable connectionError = null;
        while (finish - start < (long)(this._connectTimeout * 1000)) {
            try {
                if (retries > 0) {
                    logger.debug("Retrying #{} to host: {} port: {}.", (Object)retries, (Object)this._host, (Object)this._port);
                }
                this.session = container.connectToServer((Object)this, URI.create(this._uri));
            }
            catch (IllegalStateException e) {
                logger.error((Object)e);
                throw new ConnectionException(e.getMessage(), e);
            }
            catch (IOException | DeploymentException e) {
                connectionError = e;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.session != null && this.session.isOpen()) break;
            ++retries;
            finish = System.currentTimeMillis();
        }
        if (this.session == null || !this.session.isOpen() && finish - start >= (long)(this._connectTimeout * 1000)) {
            throw new ConnectionTimeoutException(String.format("Failed to connect to AltUnity Tester on host: %s port: %s.", this._host, this._port), connectionError);
        }
        if (!this.session.isOpen()) {
            throw new ConnectionException(String.format("Failed to connect to AltUnity Tester on host: %s port: %s.", this._host, this._port), connectionError);
        }
    }

    public void close() throws IOException {
        logger.info(String.format("Closing connection to AltUnity Tester on host: %s port: %s.", this._host, this._port));
        if (this.session != null) {
            this.session.close();
        }
    }
}

