/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.response.ipn.model;

import com.amazon.pay.response.ipn.model.EventType;
import java.util.Map;

public final class IPNMessageMetaData {
    private final String releaseEnvironment;
    private final String timeStamp;
    private final String notificationReferenceId;
    private final String sellerId;
    private final String version;
    private final String notificationType;
    private final String marketplaceId;
    private final EventType eventType;

    public IPNMessageMetaData(Map<String, String> messageMetaDataMap) {
        this.releaseEnvironment = messageMetaDataMap.get("ReleaseEnvironment");
        this.timeStamp = messageMetaDataMap.get("Timestamp");
        this.notificationReferenceId = messageMetaDataMap.get("NotificationReferenceId");
        this.sellerId = messageMetaDataMap.get("SellerId");
        this.version = messageMetaDataMap.get("Version");
        this.notificationType = messageMetaDataMap.get("NotificationType");
        this.marketplaceId = messageMetaDataMap.get("MarketplaceID");
        String eventTypeString = messageMetaDataMap.get("EventType");
        this.eventType = eventTypeString != null ? EventType.valueOf(eventTypeString) : null;
    }

    public String getReleaseEnvironment() {
        return this.releaseEnvironment;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getNotificationReferenceId() {
        return this.notificationReferenceId;
    }

    public String getSellerId() {
        return this.sellerId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public String toString() {
        return "IPNMessageMetaData{releaseEnvironment=" + this.releaseEnvironment + ", timeStamp=" + this.timeStamp + ", notificationReferenceId=" + this.notificationReferenceId + ", sellerId=" + this.sellerId + ", version=" + this.version + ", notificationType=" + this.notificationType + ", eventType=" + (Object)((Object)this.eventType) + ", marketplaceId=" + this.marketplaceId + '}';
    }
}

