/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.request;

import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.request.DelegateRequest;
import com.amazon.pay.response.model.ProviderCredit;
import com.amazon.pay.types.AmazonReferenceIdType;
import com.amazon.pay.types.CurrencyCode;
import java.io.Serializable;
import java.util.List;

public class ChargeRequest
extends DelegateRequest<ChargeRequest>
implements Serializable {
    private String amazonReferenceId;
    private AmazonReferenceIdType type;
    private String chargeReferenceId;
    private String amount;
    private CurrencyCode currencyCode;
    private String transactionTimeout;
    private Boolean captureNow;
    private String chargeOrderId;
    private String storeName;
    private String customInformation;
    private String platformId;
    private String sellerNote;
    private String softDescriptor;
    private Boolean inheritShippingAddress;
    private List<ProviderCredit> providerCredit;

    @Override
    protected ChargeRequest getThis() {
        return this;
    }

    public Boolean getInheritShippingAddress() {
        return this.inheritShippingAddress;
    }

    public void setInheritShippingAddress(Boolean inheritShippingAddress) {
        this.inheritShippingAddress = inheritShippingAddress;
    }

    @Deprecated
    public void setInheritShippingAddress(String inheritShippingAddress) {
        this.setInheritShippingAddress(Boolean.parseBoolean(inheritShippingAddress));
    }

    public ChargeRequest withAmazonReferenceId(String amazonReferenceId) {
        if (amazonReferenceId != null && amazonReferenceId.length() > 0) {
            String switchChar = amazonReferenceId;
            switch (switchChar.charAt(0)) {
                case 'P': 
                case 'S': {
                    this.type = AmazonReferenceIdType.ORDER_REFERENCE_ID;
                    this.amazonReferenceId = amazonReferenceId;
                    break;
                }
                case 'B': 
                case 'C': {
                    this.type = AmazonReferenceIdType.BILLING_AGREEMENT_ID;
                    this.amazonReferenceId = amazonReferenceId;
                    break;
                }
                default: {
                    throw new AmazonClientException("Invalid Amazon Reference ID");
                }
            }
        } else {
            throw new AmazonClientException("Amazon Reference ID is a required field and should be a Order Reference ID / Billing Agreement ID");
        }
        return this;
    }

    public ChargeRequest withAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public ChargeRequest withCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public ChargeRequest withChargeReferenceId(String chargeReferenceId) {
        this.chargeReferenceId = chargeReferenceId;
        return this;
    }

    public ChargeRequest withChargeNote(String chargeNote) {
        this.sellerNote = chargeNote;
        return this;
    }

    public ChargeRequest withTransactionTimeout(String transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
        return this;
    }

    public ChargeRequest withCaptureNow(Boolean captureNow) {
        this.captureNow = captureNow;
        return this;
    }

    public ChargeRequest withInheritShippingAddress(Boolean inheritShippingAddress) {
        this.inheritShippingAddress = inheritShippingAddress;
        return this;
    }

    @Deprecated
    public ChargeRequest withInheritShippingAddress(String inheritShippingAddress) {
        return this.withInheritShippingAddress(Boolean.parseBoolean(inheritShippingAddress));
    }

    public ChargeRequest withChargeOrderId(String chargeOrderId) {
        this.chargeOrderId = chargeOrderId;
        return this;
    }

    public ChargeRequest withStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public ChargeRequest withCustomInformation(String customInformation) {
        this.customInformation = customInformation;
        return this;
    }

    public ChargeRequest withPlatformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public ChargeRequest withSoftDescriptor(String softDescriptor) {
        this.softDescriptor = softDescriptor;
        return this;
    }

    public ChargeRequest withProviderCreditDetails(List<ProviderCredit> providerCredit) {
        this.providerCredit = providerCredit;
        return this;
    }

    public String getAmazonReferenceId() {
        return this.amazonReferenceId;
    }

    public AmazonReferenceIdType getType() {
        return this.type;
    }

    public String getChargeReferenceId() {
        return this.chargeReferenceId;
    }

    public String getAmount() {
        return this.amount;
    }

    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public String getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public Boolean getCaptureNow() {
        return this.captureNow;
    }

    public String getChargeOrderId() {
        return this.chargeOrderId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getCustomInformation() {
        return this.customInformation;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public String getSellerNote() {
        return this.sellerNote;
    }

    public String getSoftDescriptor() {
        return this.softDescriptor;
    }

    public List<ProviderCredit> getProviderCredit() {
        return this.providerCredit;
    }

    public String toString() {
        return "ChargeRequest{amazonReferenceId=" + this.amazonReferenceId + ", type=" + (Object)((Object)this.type) + ", chargeReferenceId=" + this.chargeReferenceId + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", transactionTimeout=" + this.transactionTimeout + ", captureNow=" + this.captureNow + ", chargeOrderId=" + this.chargeOrderId + ", storeName=" + this.storeName + ", customInformation=" + this.customInformation + ", platformId=" + this.platformId + ", sellerNote=" + this.sellerNote + ", softDescriptor=" + this.softDescriptor + ", mwsAuthToken=" + this.getMwsAuthToken() + ", inheritShippingAddress=" + this.inheritShippingAddress + ", providerCredit=" + this.providerCredit + '}';
    }
}

