/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.request;

import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.impl.PayConfig;
import com.amazon.pay.impl.PayLogUtil;
import com.amazon.pay.impl.Util;
import com.amazon.pay.request.AuthorizeOnBillingAgreementRequest;
import com.amazon.pay.request.AuthorizeRequest;
import com.amazon.pay.request.CancelOrderReferenceRequest;
import com.amazon.pay.request.CaptureRequest;
import com.amazon.pay.request.CloseAuthorizationRequest;
import com.amazon.pay.request.CloseBillingAgreementRequest;
import com.amazon.pay.request.CloseOrderReferenceRequest;
import com.amazon.pay.request.ConfirmBillingAgreementRequest;
import com.amazon.pay.request.ConfirmOrderReferenceRequest;
import com.amazon.pay.request.CreateOrderReferenceForIdRequest;
import com.amazon.pay.request.DelegateRequest;
import com.amazon.pay.request.GetAuthorizationDetailsRequest;
import com.amazon.pay.request.GetBillingAgreementDetailsRequest;
import com.amazon.pay.request.GetCaptureDetailsRequest;
import com.amazon.pay.request.GetMerchantAccountStatusRequest;
import com.amazon.pay.request.GetOrderReferenceDetailsRequest;
import com.amazon.pay.request.GetProviderCreditDetailsRequest;
import com.amazon.pay.request.GetProviderCreditReversalDetailsRequest;
import com.amazon.pay.request.GetRefundDetailsRequest;
import com.amazon.pay.request.ListOrderReferenceByNextTokenRequest;
import com.amazon.pay.request.ListOrderReferenceRequest;
import com.amazon.pay.request.RefundRequest;
import com.amazon.pay.request.ReverseProviderCreditRequest;
import com.amazon.pay.request.SetBillingAgreementDetailsRequest;
import com.amazon.pay.request.SetOrderAttributesRequest;
import com.amazon.pay.request.SetOrderReferenceDetailsRequest;
import com.amazon.pay.request.ValidateBillingAgreementRequest;
import com.amazon.pay.response.model.Price;
import com.amazon.pay.response.model.ProviderCredit;
import com.amazon.pay.types.OrderReferenceStatus;
import com.amazon.pay.types.ServiceConstants;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RequestHelper {
    public PayConfig payConfig;
    private PayLogUtil payUtil;

    public RequestHelper(PayConfig payConfig) {
        this.payConfig = payConfig;
        this.payUtil = new PayLogUtil();
    }

    private Map<String, String> addClientParameters(Map<String, String> params, DelegateRequest request) {
        try {
            if (request != null && request.getMwsAuthToken() != null) {
                params.put("MWSAuthToken", request.getMwsAuthToken());
            }
            if (request != null && request.getSellerId() != null) {
                params.put("SellerId", request.getSellerId());
            } else {
                params.put("SellerId", this.payConfig.getSellerId());
            }
            params.put("AWSAccessKeyId", this.payConfig.getAccessKey());
            params.put("SignatureVersion", "2");
            params.put("SignatureMethod", "HmacSHA256");
            params.put("Version", "2013-01-01");
            params.put("Timestamp", Util.getTimestamp());
            Util.urlEncodeAPIParams(params);
            String signature = this.constructSignature(params);
            params.put("Signature", signature);
            return params;
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Encountered client exception:", e);
        }
    }

    private String constructSignature(Map<String, String> params) {
        String signature = null;
        try {
            String domainName = this.payConfig.getOverrideServiceURL() != null ? this.payConfig.getOverrideServiceURL() : ServiceConstants.mwsEndpointMappings.get((Object)this.payConfig.getRegion());
            String postHeader = "POST\n" + domainName.replace("https://", "") + "\n" + Util.getServiceVersionName(this.payConfig.getEnvironment()) + "\n";
            TreeMap<String, String> sortedParams = new TreeMap<String, String>();
            sortedParams.putAll(params);
            this.payUtil.logMessage("Client Parameters: " + ((Object)sortedParams).toString());
            String stringToSign = postHeader + Util.convertParameterMapToString(sortedParams);
            signature = Util.urlEncode(Util.getSignature(stringToSign, this.payConfig.getSecretKey()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new AmazonClientException("Encountered UnsupportedEncodingException:", ex);
        }
        catch (IllegalStateException ex) {
            throw new AmazonClientException("Encountered IllegalStateException:", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AmazonClientException("Encountered NoSuchAlgorithmException:", ex);
        }
        catch (InvalidKeyException ex) {
            throw new AmazonClientException("Encountered InvalidKeyException:", ex);
        }
        return signature;
    }

    public String getPostURL(GetOrderReferenceDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetOrderReferenceDetails");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getAddressConsentToken() != null) {
            parameters.put("AddressConsentToken", request.getAddressConsentToken());
        }
        if (request.getAccessToken() != null) {
            parameters.put("AccessToken", request.getAccessToken());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(SetOrderReferenceDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        if (request.getOrderCurrencyCode() == null) {
            request.setOrderCurrencyCode(this.payConfig.getCurrencyCode());
        }
        parameters.put("Action", "SetOrderReferenceDetails");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getOrderAmount() != null) {
            parameters.put("OrderReferenceAttributes.OrderTotal.Amount", request.getOrderAmount());
        }
        if (request.getOrderCurrencyCode() != null) {
            parameters.put("OrderReferenceAttributes.OrderTotal.CurrencyCode", request.getOrderCurrencyCode().toString());
        }
        if (request.getPlatformId() != null) {
            parameters.put("OrderReferenceAttributes.PlatformId", request.getPlatformId());
        }
        if (request.getSellerNote() != null) {
            parameters.put("OrderReferenceAttributes.SellerNote", request.getSellerNote());
        }
        if (request.getSellerOrderId() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.SellerOrderId", request.getSellerOrderId());
        }
        if (request.getStoreName() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.StoreName", request.getStoreName());
        }
        if (request.getCustomInformation() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.CustomInformation", request.getCustomInformation());
        }
        if (request.getRequestPaymentAuthorization() != null) {
            parameters.put("OrderReferenceAttributes.RequestPaymentAuthorization", Boolean.toString(request.getRequestPaymentAuthorization()));
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(AuthorizeRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        if (request.getAuthorizationCurrencyCode() == null) {
            request.setAuthorizationCurrencyCode(this.payConfig.getCurrencyCode());
        }
        parameters.put("Action", "Authorize");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getAuthorizationReferenceId() != null) {
            parameters.put("AuthorizationReferenceId", request.getAuthorizationReferenceId());
        }
        if (request.getAuthorizationAmount() != null) {
            parameters.put("AuthorizationAmount.Amount", request.getAuthorizationAmount());
        }
        if (request.getAuthorizationCurrencyCode() != null) {
            parameters.put("AuthorizationAmount.CurrencyCode", request.getAuthorizationCurrencyCode().toString());
        }
        if (request.getSellerAuthorizationNote() != null) {
            parameters.put("SellerAuthorizationNote", request.getSellerAuthorizationNote());
        }
        if (request.getTransactionTimeout() != null) {
            parameters.put("TransactionTimeout", request.getTransactionTimeout());
        }
        if (request.getCaptureNow() != null) {
            parameters.put("CaptureNow", Boolean.toString(request.getCaptureNow()));
        }
        if (request.getSoftDescriptor() != null) {
            parameters.put("SoftDescriptor", request.getSoftDescriptor());
        }
        if (request.getProviderCredit() != null) {
            this.addProviderCreditToParamMap(request.getProviderCredit(), parameters);
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetAuthorizationDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetAuthorizationDetails");
        if (request.getAmazonAuthorizationId() != null) {
            parameters.put("AmazonAuthorizationId", request.getAmazonAuthorizationId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CaptureRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "Capture");
        if (request.getCaptureCurrencyCode() == null) {
            request.setCaptureCurrencyCode(this.payConfig.getCurrencyCode());
        }
        if (request.getAmazonAuthorizationId() != null) {
            parameters.put("AmazonAuthorizationId", request.getAmazonAuthorizationId());
        }
        if (request.getCaptureReferenceId() != null) {
            parameters.put("CaptureReferenceId", request.getCaptureReferenceId());
        }
        if (request.getCaptureAmount() != null) {
            parameters.put("CaptureAmount.Amount", request.getCaptureAmount());
        }
        if (request.getCaptureCurrencyCode() != null) {
            parameters.put("CaptureAmount.CurrencyCode", request.getCaptureCurrencyCode().toString());
        }
        if (request.getSellerCaptureNote() != null) {
            parameters.put("SellerCaptureNote", request.getSellerCaptureNote());
        }
        if (request.getSoftDescriptor() != null) {
            parameters.put("SoftDescriptor", request.getSoftDescriptor());
        }
        if (request.getProviderCredit() != null) {
            this.addProviderCreditToParamMap(request.getProviderCredit(), parameters);
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetCaptureDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetCaptureDetails");
        if (request.getAmazonCaptureId() != null) {
            parameters.put("AmazonCaptureId", request.getAmazonCaptureId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(ConfirmOrderReferenceRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ConfirmOrderReference");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CancelOrderReferenceRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CancelOrderReference");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getCancelationReason() != null) {
            parameters.put("CancelationReason", request.getCancelationReason());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CloseOrderReferenceRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CloseOrderReference");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getClosureReason() != null) {
            parameters.put("ClosureReason", request.getClosureReason());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CloseAuthorizationRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CloseAuthorization");
        if (request.getAmazonAuthorizationId() != null) {
            parameters.put("AmazonAuthorizationId", request.getAmazonAuthorizationId());
        }
        if (request.getClosureReason() != null) {
            parameters.put("ClosureReason", request.getClosureReason());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(RefundRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "Refund");
        if (request.getRefundCurrencyCode() == null) {
            request.setRefundCurrencyCode(this.payConfig.getCurrencyCode());
        }
        if (request.getAmazonCaptureId() != null) {
            parameters.put("AmazonCaptureId", request.getAmazonCaptureId());
        }
        if (request.getRefundReferenceId() != null) {
            parameters.put("RefundReferenceId", request.getRefundReferenceId());
        }
        if (request.getRefundAmount() != null) {
            parameters.put("RefundAmount.Amount", request.getRefundAmount());
        }
        if (request.getRefundCurrencyCode() != null) {
            parameters.put("RefundAmount.CurrencyCode", request.getRefundCurrencyCode().toString());
        }
        if (request.getSellerRefundNote() != null) {
            parameters.put("SellerRefundNote", request.getSellerRefundNote());
        }
        if (request.getSoftDescriptor() != null) {
            parameters.put("SoftDescriptor", request.getSoftDescriptor());
        }
        if (request.getProviderCredit() != null) {
            this.addProviderCreditToParamMap(request.getProviderCredit(), parameters);
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetRefundDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetRefundDetails");
        if (request.getAmazonRefundId() != null) {
            parameters.put("AmazonRefundId", request.getAmazonRefundId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetProviderCreditDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetProviderCreditDetails");
        if (request.getAmazonProviderCreditId() != null) {
            parameters.put("AmazonProviderCreditId", request.getAmazonProviderCreditId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetProviderCreditReversalDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetProviderCreditReversalDetails");
        if (request.getAmazonProviderCreditReversalId() != null) {
            parameters.put("AmazonProviderCreditReversalId", request.getAmazonProviderCreditReversalId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(ReverseProviderCreditRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ReverseProviderCredit");
        if (request.getCreditReversalAmountCurrencyCode() == null) {
            request.setCreditReversalCurrencyCode(this.payConfig.getCurrencyCode());
        }
        if (request.getAmazonProviderCreditId() != null) {
            parameters.put("AmazonProviderCreditId", request.getAmazonProviderCreditId());
        }
        if (request.getCreditReversalReferenceId() != null) {
            parameters.put("CreditReversalReferenceId", request.getCreditReversalReferenceId());
        }
        if (request.getCreditReversalAmount() != null) {
            parameters.put("CreditReversalAmount.Amount", request.getCreditReversalAmount());
        }
        if (request.getCreditReversalAmountCurrencyCode() != null) {
            parameters.put("CreditReversalAmount.CurrencyCode", request.getCreditReversalAmountCurrencyCode().toString());
        }
        if (request.getCreditReversalNote() != null) {
            parameters.put("CreditReversalNote", request.getCreditReversalNote());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetBillingAgreementDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetBillingAgreementDetails");
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        if (request.getAddressConsentToken() != null) {
            parameters.put("AddressConsentToken", request.getAddressConsentToken());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(SetBillingAgreementDetailsRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "SetBillingAgreementDetails");
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        if (request.getPlatformId() != null) {
            parameters.put("BillingAgreementAttributes.PlatformId", request.getPlatformId());
        }
        if (request.getSellerNote() != null) {
            parameters.put("BillingAgreementAttributes.SellerNote", request.getSellerNote());
        }
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("BillingAgreementAttributes.SellerBillingAgreementAttributes.SellerBillingAgreementId", request.getSellerBillingAgreementId());
        }
        if (request.getStoreName() != null) {
            parameters.put("BillingAgreementAttributes.SellerBillingAgreementAttributes.StoreName", request.getStoreName());
        }
        if (request.getCustomInformation() != null) {
            parameters.put("BillingAgreementAttributes.SellerBillingAgreementAttributes.CustomInformation", request.getCustomInformation());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(ConfirmBillingAgreementRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ConfirmBillingAgreement");
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CloseBillingAgreementRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CloseBillingAgreement");
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        if (request.getClosureReason() != null) {
            parameters.put("ClosureReason", request.getClosureReason());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(AuthorizeOnBillingAgreementRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "AuthorizeOnBillingAgreement");
        if (request.getAuthorizationCurrencyCode() == null) {
            request.setAuthorizationCurrencyCode(this.payConfig.getCurrencyCode());
        }
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        if (request.getAuthorizationReferenceId() != null) {
            parameters.put("AuthorizationReferenceId", request.getAuthorizationReferenceId());
        }
        if (request.getAuthorizationAmount() != null) {
            parameters.put("AuthorizationAmount.Amount", request.getAuthorizationAmount());
        }
        if (request.getAuthorizationCurrencyCode() != null) {
            parameters.put("AuthorizationAmount.CurrencyCode", request.getAuthorizationCurrencyCode().toString());
        }
        if (request.getSellerAuthorizationNote() != null) {
            parameters.put("SellerAuthorizationNote", request.getSellerAuthorizationNote());
        }
        if (request.getTransactionTimeout() != null) {
            parameters.put("TransactionTimeout", request.getTransactionTimeout());
        }
        if (request.getCaptureNow() != null) {
            parameters.put("CaptureNow", Boolean.toString(request.getCaptureNow()));
        }
        if (request.getSoftDescriptor() != null) {
            parameters.put("SoftDescriptor", request.getSoftDescriptor());
        }
        if (request.getSellerNote() != null) {
            parameters.put("OrderReferenceAttributes.SellerNote", request.getSellerNote());
        }
        if (request.getPlatformId() != null) {
            parameters.put("OrderReferenceAttributes.PlatformId", request.getPlatformId());
        }
        if (request.getSellerOrderId() != null) {
            parameters.put("SellerOrderAttributes.SellerOrderId", request.getSellerOrderId());
        }
        if (request.getStoreName() != null) {
            parameters.put("SellerOrderAttributes.StoreName", request.getStoreName());
        }
        if (request.getCustomInformation() != null) {
            parameters.put("SellerOrderAttributes.CustomInformation", request.getCustomInformation());
        }
        if (request.getInheritShippingAddress() != null) {
            parameters.put("InheritShippingAddress", Boolean.toString(request.getInheritShippingAddress()));
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(ValidateBillingAgreementRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ValidateBillingAgreement");
        if (request.getAmazonBillingAgreementId() != null) {
            parameters.put("AmazonBillingAgreementId", request.getAmazonBillingAgreementId());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(CreateOrderReferenceForIdRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "CreateOrderReferenceForId");
        if (request.getOrderTotalCurrencyCode() == null) {
            request.setOrderTotalCurrencyCode(this.payConfig.getCurrencyCode());
        }
        if (request.getInheritShippingAddress() == null) {
            request.setInheritShippingAddress(true);
        }
        if (request.getId() != null) {
            parameters.put("Id", request.getId());
        }
        if (request.getIdType() != null) {
            parameters.put("IdType", request.getIdType().value());
        }
        if (request.getInheritShippingAddress() != null) {
            parameters.put("InheritShippingAddress", Boolean.toString(request.getInheritShippingAddress()));
        }
        if (request.getConfirmNow() != null) {
            parameters.put("ConfirmNow", Boolean.toString(request.getConfirmNow()));
        }
        if (request.getOrderTotalCurrencyCode() != null) {
            parameters.put("OrderReferenceAttributes.OrderTotal.CurrencyCode", request.getOrderTotalCurrencyCode().toString());
        }
        if (request.getOrderTotalAmount() != null) {
            parameters.put("OrderReferenceAttributes.OrderTotal.Amount", request.getOrderTotalAmount());
        }
        if (request.getPlatformId() != null) {
            parameters.put("OrderReferenceAttributes.PlatformId", request.getPlatformId());
        }
        if (request.getSellerNote() != null) {
            parameters.put("OrderReferenceAttributes.SellerNote", request.getSellerNote());
        }
        if (request.getSellerOrderId() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.SellerOrderId", request.getSellerOrderId());
        }
        if (request.getStoreName() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.StoreName", request.getStoreName());
        }
        if (request.getCustomInformation() != null) {
            parameters.put("OrderReferenceAttributes.SellerOrderAttributes.CustomInformation", request.getCustomInformation());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURLGetServiceStatus() {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetServiceStatus");
        this.addClientParameters(parameters, null);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPaymentDomain(String region) {
        String paymentDomain = "NA_USD";
        if (region.equals("DE")) {
            paymentDomain = "EU_EUR";
        } else if (region.equals("UK")) {
            paymentDomain = "EU_GBP";
        } else if (region.equals("JP")) {
            paymentDomain = "FE_JPY";
        }
        return paymentDomain;
    }

    public String getPostURL(ListOrderReferenceRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ListOrderReference");
        parameters.put("PaymentDomain", this.getPaymentDomain(this.payConfig.getRegion().toString()));
        if (request.getStartTime() != null) {
            parameters.put("CreatedTimeRange.StartTime", request.getStartTime().toString());
        }
        if (request.getEndTime() != null) {
            parameters.put("CreatedTimeRange.EndTime", request.getEndTime().toString());
        }
        if (request.getQueryId() != null) {
            parameters.put("QueryId", request.getQueryId());
        }
        if (request.getQueryIdType() != null) {
            parameters.put("QueryIdType", request.getQueryIdType());
        }
        if (request.getSortOrder() != null) {
            parameters.put("SortOrder", request.getSortOrder().toString());
        }
        if (request.getPageSize() != null) {
            parameters.put("PageSize", request.getPageSize().toString());
        }
        if (request.getOrderReferenceStatusListFilter() != null) {
            EnumSet<OrderReferenceStatus> filters = request.getOrderReferenceStatusListFilter();
            int count = 1;
            for (OrderReferenceStatus filter : filters) {
                parameters.put("OrderReferenceStatusListFilter.OrderReferenceStatus." + count, filter.toString());
                ++count;
            }
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(ListOrderReferenceByNextTokenRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "ListOrderReferenceByNextToken");
        if (request.getNextPageToken() != null) {
            parameters.put("NextPageToken", request.getNextPageToken());
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(SetOrderAttributesRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "SetOrderAttributes");
        if (request.getAmazonOrderReferenceId() != null) {
            parameters.put("AmazonOrderReferenceId", request.getAmazonOrderReferenceId());
        }
        if (request.getAmount() != null) {
            parameters.put("OrderAttributes.OrderTotal.Amount", request.getAmount());
        }
        if (request.getCurrencyCode() != null) {
            parameters.put("OrderAttributes.OrderTotal.CurrencyCode", request.getCurrencyCode().toString());
        }
        if (request.getSellerNote() != null) {
            parameters.put("OrderAttributes.SellerNote", request.getSellerNote());
        }
        if (request.getRequestPaymentAuthorization() != null) {
            parameters.put("OrderAttributes.RequestPaymentAuthorization", Boolean.toString(request.getRequestPaymentAuthorization()));
        }
        if (request.getSellerOrderId() != null) {
            parameters.put("OrderAttributes.SellerOrderAttributes.SellerOrderId", request.getSellerOrderId());
        }
        if (request.getStoreName() != null) {
            parameters.put("OrderAttributes.SellerOrderAttributes.StoreName", request.getStoreName());
        }
        if (request.getPlatformId() != null) {
            parameters.put("OrderAttributes.PlatformId", request.getPlatformId());
        }
        if (request.getCustomInformation() != null) {
            parameters.put("OrderAttributes.SellerOrderAttributes.CustomInformation", request.getCustomInformation());
        }
        if (request.getPaymentServiceProviderId() != null) {
            parameters.put("OrderAttributes.PaymentServiceProviderAttributes.PaymentServiceProviderId", request.getPaymentServiceProviderId());
        }
        if (request.getPaymentServiceProviderOrderId() != null) {
            parameters.put("OrderAttributes.PaymentServiceProviderAttributes.PaymentServiceProviderOrderId", request.getPaymentServiceProviderOrderId());
        }
        if (request.getOrderItemCategories() != null) {
            Set<String> orderItemCategories = request.getOrderItemCategories();
            int count = 1;
            for (String orderItemCategory : orderItemCategories) {
                parameters.put("OrderAttributes.SellerOrderAttributes.OrderItemCategories.OrderItemCategory." + count, orderItemCategory);
                ++count;
            }
        }
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    public String getPostURL(GetMerchantAccountStatusRequest request) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Action", "GetMerchantAccountStatus");
        this.addClientParameters(parameters, request);
        return Util.convertParameterMapToString(parameters);
    }

    private void addProviderCreditToParamMap(List<ProviderCredit> providerCreditList, Map<String, String> parameters) {
        if (providerCreditList != null) {
            int memberListIndex = 1;
            for (ProviderCredit member : providerCreditList) {
                Price creditAmount;
                if (member == null) continue;
                if (member.getProviderId() != null) {
                    parameters.put("ProviderCreditList.member." + memberListIndex + ".ProviderId", member.getProviderId());
                }
                if ((creditAmount = member.getCreditAmount()) != null) {
                    parameters.put("ProviderCreditList.member." + memberListIndex + ".CreditAmount.Amount", creditAmount.getAmount());
                    parameters.put("ProviderCreditList.member." + memberListIndex + ".CreditAmount.CurrencyCode", creditAmount.getCurrencyCode());
                }
                ++memberListIndex;
            }
        }
    }
}

