/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.exceptions;

import com.amazon.pay.response.parser.ResponseData;
import java.io.Serializable;

public class AmazonClientException
extends RuntimeException
implements Serializable {
    private final String message;
    private int statusCode;
    private String rawResponse;
    private static final long serialVersionUID = 1L;

    public AmazonClientException(ResponseData response, String message, Exception exception) {
        super("Client Exception: " + message, exception);
        this.rawResponse = response.toXML();
        this.statusCode = response.getStatusCode();
        this.message = message;
    }

    public AmazonClientException(String message, Exception exception) {
        super(message, exception);
        this.message = message;
    }

    public AmazonClientException(String message) {
        this.message = message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseXml() {
        return this.rawResponse;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.getMessage() + " (Status Code: " + this.getStatusCode() + "; Raw Response XML: " + this.getResponseXml() + ")";
    }
}

