/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.exceptions;

import com.amazon.pay.response.model.Error;
import com.amazon.pay.response.model.ErrorResponse;
import com.amazon.pay.response.parser.ResponseData;
import java.io.Serializable;

public class AmazonServiceException
extends Exception
implements Serializable {
    private String message;
    private int statusCode;
    private String errorCode;
    private String errorType;
    private String requestId;
    private String rawResponse;
    private static final long serialVersionUID = 1L;

    public AmazonServiceException(ErrorResponse errorResponse, ResponseData response) {
        super(response.toXML());
        this.rawResponse = response.toXML();
        this.statusCode = response.getStatusCode();
        if (errorResponse != null && errorResponse.getError() != null) {
            this.requestId = errorResponse.getRequestId();
            if (!errorResponse.getError().isEmpty()) {
                Error error = errorResponse.getError().get(0);
                this.message = error.getMessage();
                this.errorCode = error.getCode();
                this.errorType = error.getType();
            }
        }
    }

    public AmazonServiceException(String message, Exception exception) {
        super(message, exception);
        this.message = message;
    }

    public AmazonServiceException(String message) {
        super(message);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public String getResponseXml() {
        return this.rawResponse;
    }

    @Override
    public String toString() {
        return this.getErrorMessage() + " (Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + "; Raw Response XML: " + this.getResponseXml() + ")";
    }
}

