/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl;

import com.amazon.pay.Config;
import com.amazon.pay.impl.PayConfig;
import com.amazon.pay.impl.PayLogUtil;
import com.amazon.pay.response.model.Environment;
import com.amazon.pay.response.parser.ResponseData;
import com.amazon.pay.types.Region;
import com.amazon.pay.types.ServiceConstants;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Util {
    private static PayLogUtil payLogUtil = new PayLogUtil();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");

    public static String getSignature(String stringToSign, String secretKey) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(secretKey.getBytes("UTF-8"), "HmacSHA256"));
        byte[] signature = mac.doFinal(stringToSign.getBytes("UTF-8"));
        String signatureBase64 = new String(Base64.encodeBase64((byte[])signature), "UTF-8");
        return signatureBase64;
    }

    public static String getTimestamp() {
        Date date = new Date();
        String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ssz";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(utc);
        String timeStamp = sdf.format(date);
        return timeStamp.replace("UTC", "Z");
    }

    public static ResponseData httpSendRequest(String method, String url, String urlParameters, Map<String, String> headers) throws IOException {
        String inputLine;
        int responseCode;
        payLogUtil.logMessage("Request:\nURL=" + url + "\nPOST Data=" + urlParameters);
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setConnectTimeout(30000);
        con.setReadTimeout(30000);
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                con.setRequestProperty(key, headers.get(key));
            }
        }
        con.setDoOutput(true);
        con.setRequestMethod(method);
        if (urlParameters != null) {
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
        }
        BufferedReader in = (responseCode = con.getResponseCode()) != 200 ? new BufferedReader(new InputStreamReader(con.getErrorStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine).append(LINE_SEPARATOR);
        }
        in.close();
        return new ResponseData(responseCode, response.toString());
    }

    public static ResponseData httpSendRequest(String method, String url, String urlParameters, Map<String, String> headers, PayConfig config) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (config != null) {
            String applicationName = config.getApplicationName();
            String applicationVersion = config.getApplicationVersion();
            StringBuilder userAgent = new StringBuilder("amazon-pay-sdk-java/3.6.2");
            if (applicationName != null && !applicationName.trim().isEmpty() && applicationVersion != null && !applicationVersion.trim().isEmpty()) {
                userAgent.append(" (" + applicationName + "/" + applicationVersion + "; ");
            } else if (applicationVersion != null && !applicationVersion.trim().isEmpty()) {
                userAgent.append(" (" + applicationVersion + "; ");
            } else if (applicationName != null && !applicationName.trim().isEmpty()) {
                userAgent.append(" (" + applicationName + "; ");
            } else {
                userAgent.append(" (");
            }
            userAgent.append("Java/" + JAVA_VERSION + "; " + OS_NAME + "/" + OS_VERSION + ")");
            headerMap.put("User-Agent", userAgent.toString());
            if (config.getProxyHost() != null) {
                String password;
                byte[] encodedPassword;
                Properties systemSettings = System.getProperties();
                systemSettings.put("proxySet", "true");
                systemSettings.put("http.proxyHost", config.getProxyHost());
                systemSettings.put("http.proxyPort", (Object)config.getProxyPort());
                if (config.getProxyUsername() != null && config.getProxyPassword() != null && (encodedPassword = Base64.encodeBase64((byte[])(password = config.getProxyUsername() + ":" + config.getProxyPassword()).getBytes())) != null) {
                    headerMap.put("Proxy-Authorization", new String(encodedPassword));
                }
            }
        }
        ResponseData response = Util.httpSendRequest(method, url, urlParameters, headerMap);
        return response;
    }

    public static String urlEncode(String str) throws UnsupportedEncodingException {
        String val = str == null ? "" : str;
        String encoded = URLEncoder.encode(val, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        return encoded;
    }

    public static void urlEncodeAPIParams(Map<String, String> apiParameters) throws UnsupportedEncodingException {
        for (Map.Entry<String, String> entry : apiParameters.entrySet()) {
            entry.setValue(Util.urlEncode(entry.getValue()));
        }
    }

    public static <T> T convertJsonToObject(String jsonData, Class<T> clazz) {
        Gson gson = new Gson();
        Object object = gson.fromJson(jsonData, clazz);
        return (T)object;
    }

    public static String convertParameterMapToString(Map<String, String> params) {
        StringBuilder parameterString = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = params.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            if (pair.getValue() != null) {
                parameterString.append(pair.getKey() + "=" + pair.getValue());
            } else {
                parameterString.append(pair.getKey() + "=");
            }
            if (!pairs.hasNext()) continue;
            parameterString.append("&");
        }
        return parameterString.toString();
    }

    @Deprecated
    public static String getServiceURLEndpoint(Region region, Environment environment) {
        return ServiceConstants.mwsEndpointMappings.get((Object)region) + Util.getServiceVersionName(environment);
    }

    public static String getServiceURLEndpoint(Config config) {
        if (config.getOverrideServiceURL() != null) {
            return config.getOverrideServiceURL() + Util.getServiceVersionName(config.getEnvironment());
        }
        return ServiceConstants.mwsEndpointMappings.get((Object)config.getRegion()) + Util.getServiceVersionName(config.getEnvironment());
    }

    public static String getServiceVersionName(Environment environment) {
        String mwsServiceAPIVersionName = environment == Environment.SANDBOX ? "/OffAmazonPayments_Sandbox/2013-01-01" : "/OffAmazonPayments/2013-01-01";
        return mwsServiceAPIVersionName;
    }
}

