/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl;

import com.amazon.pay.impl.PayConfig;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;

public class PayConfigLoaderFactory {
    public static PayConfig loadConfigFromJSON(String fileLocation) throws IllegalArgumentException, FileNotFoundException, IOException {
        BufferedReader br = null;
        Properties prop = null;
        try {
            br = new BufferedReader(new FileReader(fileLocation));
            prop = (Properties)new Gson().fromJson((Reader)br, Properties.class);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new PayConfig(prop);
    }

    public static PayConfig loadConfigFromPropertiesFile(String fileLocation) throws IllegalArgumentException, FileNotFoundException, IOException {
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            input = new FileInputStream(fileLocation);
            prop.load(input);
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
        return new PayConfig(prop);
    }
}

