/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl;

import com.amazon.pay.LogUtil;
import com.amazon.pay.exceptions.AmazonClientException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PayLogUtil
implements LogUtil {
    private static Log log = LogFactory.getLog(PayLogUtil.class);

    @Override
    public void logMessage(String message) {
        if (log != null) {
            log.debug((Object)message);
        }
    }

    public String sanitizeString(String responseData) {
        ArrayList<String> restrictedDataList = new ArrayList<String>(){
            {
                this.add("SellerNote");
                this.add("SellerAuthorizationNote");
                this.add("SellerCaptureNote");
                this.add("SellerRefundNote");
                this.add("Buyer");
                this.add("PhysicalDestination");
                this.add("BillingAddress");
                this.add("AuthorizationBillingAddress");
            }
        };
        String sanitizedData = this.getSanitizedData(responseData, (List<String>)restrictedDataList);
        return sanitizedData;
    }

    public String getSanitizedData(String data, List<String> removedata) throws AmazonClientException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(data));
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("*");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                for (String item : removedata) {
                    if (!node.getNodeName().equalsIgnoreCase(item)) continue;
                    node.setTextContent("*** Removed ***");
                }
            }
            StringWriter sw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(list.item(0)), new StreamResult(sw));
            String result = sw.toString();
            return result;
        }
        catch (ParserConfigurationException e) {
            throw new AmazonClientException("Encountered UnsupportedEncodingException:", e);
        }
        catch (SAXException e) {
            throw new AmazonClientException("Encountered SAXException:", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Encountered IOException:", e);
        }
        catch (TransformerConfigurationException e) {
            throw new AmazonClientException("Encountered a Transformer Configuration Exception:", e);
        }
        catch (TransformerException e) {
            throw new AmazonClientException("Encountered a Transformer Exception:", e);
        }
    }
}

