/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.response.parser;

import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.exceptions.AmazonServiceException;
import com.amazon.pay.response.model.AuthorizeOnBillingAgreementResponse;
import com.amazon.pay.response.model.AuthorizeResponse;
import com.amazon.pay.response.model.CancelOrderReferenceResponse;
import com.amazon.pay.response.model.CaptureResponse;
import com.amazon.pay.response.model.CloseAuthorizationResponse;
import com.amazon.pay.response.model.CloseBillingAgreementResponse;
import com.amazon.pay.response.model.CloseOrderReferenceResponse;
import com.amazon.pay.response.model.ConfirmBillingAgreementResponse;
import com.amazon.pay.response.model.ConfirmOrderReferenceResponse;
import com.amazon.pay.response.model.CreateOrderReferenceForIdResponse;
import com.amazon.pay.response.model.ErrorResponse;
import com.amazon.pay.response.model.GetAuthorizationDetailsResponse;
import com.amazon.pay.response.model.GetBillingAgreementDetailsResponse;
import com.amazon.pay.response.model.GetCaptureDetailsResponse;
import com.amazon.pay.response.model.GetMerchantAccountStatusResponse;
import com.amazon.pay.response.model.GetOrderReferenceDetailsResponse;
import com.amazon.pay.response.model.GetProviderCreditDetailsResponse;
import com.amazon.pay.response.model.GetProviderCreditReversalDetailsResponse;
import com.amazon.pay.response.model.GetRefundDetailsResponse;
import com.amazon.pay.response.model.GetServiceStatusResponse;
import com.amazon.pay.response.model.ListOrderReferenceByNextTokenResponse;
import com.amazon.pay.response.model.ListOrderReferenceResponse;
import com.amazon.pay.response.model.RefundResponse;
import com.amazon.pay.response.model.ReverseProviderCreditResponse;
import com.amazon.pay.response.model.SetBillingAgreementDetailsResponse;
import com.amazon.pay.response.model.SetOrderAttributesResponse;
import com.amazon.pay.response.model.SetOrderReferenceDetailsResponse;
import com.amazon.pay.response.model.ValidateBillingAgreementResponse;
import com.amazon.pay.response.parser.AuthorizeOnBillingAgreementResponseData;
import com.amazon.pay.response.parser.AuthorizeResponseData;
import com.amazon.pay.response.parser.CancelOrderReferenceResponseData;
import com.amazon.pay.response.parser.CaptureResponseData;
import com.amazon.pay.response.parser.CloseAuthorizationResponseData;
import com.amazon.pay.response.parser.CloseBillingAgreementResponseData;
import com.amazon.pay.response.parser.CloseOrderReferenceResponseData;
import com.amazon.pay.response.parser.ConfirmBillingAgreementResponseData;
import com.amazon.pay.response.parser.ConfirmOrderReferenceResponseData;
import com.amazon.pay.response.parser.CreateOrderReferenceForIdResponseData;
import com.amazon.pay.response.parser.GetAuthorizationDetailsResponseData;
import com.amazon.pay.response.parser.GetBillingAgreementDetailsResponseData;
import com.amazon.pay.response.parser.GetCaptureDetailsResponseData;
import com.amazon.pay.response.parser.GetMerchantAccountStatusResponseData;
import com.amazon.pay.response.parser.GetOrderReferenceDetailsResponseData;
import com.amazon.pay.response.parser.GetProviderCreditDetailsResponseData;
import com.amazon.pay.response.parser.GetProviderCreditReversalDetailsResponseData;
import com.amazon.pay.response.parser.GetRefundDetailsResponseData;
import com.amazon.pay.response.parser.GetServiceStatusResponseData;
import com.amazon.pay.response.parser.ListOrderReferenceByNextTokenResponseData;
import com.amazon.pay.response.parser.ListOrderReferenceResponseData;
import com.amazon.pay.response.parser.RefundResponseData;
import com.amazon.pay.response.parser.ResponseData;
import com.amazon.pay.response.parser.ReverseProviderCreditResponseData;
import com.amazon.pay.response.parser.SetBillingAgreementDetailsResponseData;
import com.amazon.pay.response.parser.SetOrderAttributesResponseData;
import com.amazon.pay.response.parser.SetOrderReferenceDetailsResponseData;
import com.amazon.pay.response.parser.ValidateBillingAgreementResponseData;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Parser {
    public static GetOrderReferenceDetailsResponseData getOrderReferenceDetails(ResponseData rawResponse) throws AmazonServiceException {
        GetOrderReferenceDetailsResponse response = Parser.marshalXML(GetOrderReferenceDetailsResponse.class, rawResponse);
        return new GetOrderReferenceDetailsResponseData(response, rawResponse);
    }

    public static SetOrderReferenceDetailsResponseData setOrderReferenceDetails(ResponseData rawResponse) throws AmazonServiceException {
        SetOrderReferenceDetailsResponse response = Parser.marshalXML(SetOrderReferenceDetailsResponse.class, rawResponse);
        return new SetOrderReferenceDetailsResponseData(response, rawResponse);
    }

    public static AuthorizeResponseData getAuthorizeData(ResponseData rawResponse) throws AmazonServiceException {
        AuthorizeResponse response = Parser.marshalXML(AuthorizeResponse.class, rawResponse);
        return new AuthorizeResponseData(response, rawResponse);
    }

    public static GetAuthorizationDetailsResponseData getAuthorizationDetailsData(ResponseData rawResponse) throws AmazonServiceException {
        GetAuthorizationDetailsResponse response = Parser.marshalXML(GetAuthorizationDetailsResponse.class, rawResponse);
        return new GetAuthorizationDetailsResponseData(response, rawResponse);
    }

    public static CaptureResponseData getCapture(ResponseData rawResponse) throws AmazonServiceException {
        CaptureResponse response = Parser.marshalXML(CaptureResponse.class, rawResponse);
        return new CaptureResponseData(response, rawResponse);
    }

    public static GetCaptureDetailsResponseData getCaptureDetailsData(ResponseData rawResponse) throws AmazonServiceException {
        GetCaptureDetailsResponse response = Parser.marshalXML(GetCaptureDetailsResponse.class, rawResponse);
        return new GetCaptureDetailsResponseData(response, rawResponse);
    }

    public static ConfirmOrderReferenceResponseData confirmOrderReference(ResponseData rawResponse) throws AmazonServiceException {
        ConfirmOrderReferenceResponse response = Parser.marshalXML(ConfirmOrderReferenceResponse.class, rawResponse);
        return new ConfirmOrderReferenceResponseData(response, rawResponse);
    }

    public static CloseAuthorizationResponseData closeAuthorizationResponse(ResponseData rawResponse) throws AmazonServiceException {
        CloseAuthorizationResponse response = Parser.marshalXML(CloseAuthorizationResponse.class, rawResponse);
        return new CloseAuthorizationResponseData(response, rawResponse);
    }

    public static CancelOrderReferenceResponseData getCancelOrderReference(ResponseData rawResponse) throws AmazonServiceException {
        CancelOrderReferenceResponse response = Parser.marshalXML(CancelOrderReferenceResponse.class, rawResponse);
        return new CancelOrderReferenceResponseData(response, rawResponse);
    }

    public static CloseOrderReferenceResponseData getCloseOrderReference(ResponseData rawResponse) throws AmazonServiceException {
        CloseOrderReferenceResponse response = Parser.marshalXML(CloseOrderReferenceResponse.class, rawResponse);
        return new CloseOrderReferenceResponseData(response, rawResponse);
    }

    public static RefundResponseData getRefundData(ResponseData rawResponse) throws AmazonServiceException {
        RefundResponse response = Parser.marshalXML(RefundResponse.class, rawResponse);
        return new RefundResponseData(response, rawResponse);
    }

    public static GetRefundDetailsResponseData getRefundDetailsData(ResponseData rawResponse) throws AmazonServiceException {
        GetRefundDetailsResponse response = Parser.marshalXML(GetRefundDetailsResponse.class, rawResponse);
        return new GetRefundDetailsResponseData(response, rawResponse);
    }

    public static GetBillingAgreementDetailsResponseData getBillingAgreementDetailsData(ResponseData rawResponse) throws AmazonServiceException {
        GetBillingAgreementDetailsResponse response = Parser.marshalXML(GetBillingAgreementDetailsResponse.class, rawResponse);
        return new GetBillingAgreementDetailsResponseData(response, rawResponse);
    }

    public static SetBillingAgreementDetailsResponseData getSetBillingAgreementDetailsResponse(ResponseData rawResponse) throws AmazonServiceException {
        SetBillingAgreementDetailsResponse response = Parser.marshalXML(SetBillingAgreementDetailsResponse.class, rawResponse);
        return new SetBillingAgreementDetailsResponseData(response, rawResponse);
    }

    public static ValidateBillingAgreementResponseData getValidateBillingAgreementResponse(ResponseData rawResponse) throws AmazonServiceException {
        ValidateBillingAgreementResponse response = Parser.marshalXML(ValidateBillingAgreementResponse.class, rawResponse);
        return new ValidateBillingAgreementResponseData(response, rawResponse);
    }

    public static ConfirmBillingAgreementResponseData confirmBillingAgreementResponse(ResponseData rawResponse) throws AmazonServiceException {
        ConfirmBillingAgreementResponse response = Parser.marshalXML(ConfirmBillingAgreementResponse.class, rawResponse);
        return new ConfirmBillingAgreementResponseData(response, rawResponse);
    }

    public static AuthorizeOnBillingAgreementResponseData getAuthorizeOnBillingAgreement(ResponseData rawResponse) throws AmazonServiceException {
        AuthorizeOnBillingAgreementResponse response = Parser.marshalXML(AuthorizeOnBillingAgreementResponse.class, rawResponse);
        return new AuthorizeOnBillingAgreementResponseData(response, rawResponse);
    }

    public static CloseBillingAgreementResponseData closeBillingAgreementResponse(ResponseData rawResponse) throws AmazonServiceException {
        CloseBillingAgreementResponse response = Parser.marshalXML(CloseBillingAgreementResponse.class, rawResponse);
        return new CloseBillingAgreementResponseData(response, rawResponse);
    }

    public static GetProviderCreditDetailsResponseData getGetProviderCreditDetails(ResponseData rawResponse) throws AmazonServiceException {
        GetProviderCreditDetailsResponse response = Parser.marshalXML(GetProviderCreditDetailsResponse.class, rawResponse);
        return new GetProviderCreditDetailsResponseData(response, rawResponse);
    }

    public static GetProviderCreditReversalDetailsResponseData getProviderCreditReversalDetails(ResponseData rawResponse) throws AmazonServiceException {
        GetProviderCreditReversalDetailsResponse response = Parser.marshalXML(GetProviderCreditReversalDetailsResponse.class, rawResponse);
        return new GetProviderCreditReversalDetailsResponseData(response, rawResponse);
    }

    public static ReverseProviderCreditResponseData getReverseProviderCreditResponseData(ResponseData rawResponse) throws AmazonServiceException {
        ReverseProviderCreditResponse response = Parser.marshalXML(ReverseProviderCreditResponse.class, rawResponse);
        return new ReverseProviderCreditResponseData(response, rawResponse);
    }

    public static GetServiceStatusResponseData getServiceStatus(ResponseData rawResponse) throws AmazonServiceException {
        GetServiceStatusResponse response = Parser.marshalXML(GetServiceStatusResponse.class, rawResponse);
        return new GetServiceStatusResponseData(response, rawResponse);
    }

    public static CreateOrderReferenceForIdResponseData createOrderReferenceForId(ResponseData rawResponse) throws AmazonServiceException {
        CreateOrderReferenceForIdResponse response = Parser.marshalXML(CreateOrderReferenceForIdResponse.class, rawResponse);
        return new CreateOrderReferenceForIdResponseData(response, rawResponse);
    }

    public static ListOrderReferenceResponseData listOrderReference(ResponseData rawResponse) throws AmazonServiceException {
        ListOrderReferenceResponse response = Parser.marshalXML(ListOrderReferenceResponse.class, rawResponse);
        return new ListOrderReferenceResponseData(response, rawResponse);
    }

    public static ListOrderReferenceByNextTokenResponseData listOrderReferenceByNextToken(ResponseData rawResponse) throws AmazonServiceException {
        ListOrderReferenceByNextTokenResponse response = Parser.marshalXML(ListOrderReferenceByNextTokenResponse.class, rawResponse);
        return new ListOrderReferenceByNextTokenResponseData(response, rawResponse);
    }

    public static SetOrderAttributesResponseData setOrderAttributes(ResponseData rawResponse) throws AmazonServiceException {
        SetOrderAttributesResponse response = Parser.marshalXML(SetOrderAttributesResponse.class, rawResponse);
        return new SetOrderAttributesResponseData(response, rawResponse);
    }

    public static GetMerchantAccountStatusResponseData getMerchantAccountStatus(ResponseData rawResponse) throws AmazonServiceException {
        GetMerchantAccountStatusResponse response = Parser.marshalXML(GetMerchantAccountStatusResponse.class, rawResponse);
        return new GetMerchantAccountStatusResponseData(response, rawResponse);
    }

    public static <T> T marshalXML(Class<T> clazz, ResponseData rawResponse) throws AmazonServiceException {
        try {
            if (rawResponse.getStatusCode() == 200) {
                Object responseObject = null;
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
                String noNamespaceXML = rawResponse.toXML().replaceAll("xmlns(?:.*?)?=\"http://mws.amazonservices.com/schema/OffAmazonPayments/2013-01-01\"", "");
                StringReader reader = new StringReader(noNamespaceXML);
                Unmarshaller unmarshaller = context.createUnmarshaller();
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
                responseObject = unmarshaller.unmarshal(xmlStreamReader);
                return (T)responseObject;
            }
            Parser.generateErrorException(rawResponse);
        }
        catch (JAXBException e) {
            throw new AmazonClientException(rawResponse, "Encountered marshalling error while marshalling data " + rawResponse.toXML(), (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            throw new AmazonClientException(rawResponse, "Encountered marshalling error while marshalling data " + rawResponse.toXML(), e);
        }
        return null;
    }

    public static void generateErrorException(ResponseData rawResponse) throws AmazonServiceException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorResponse.class});
        String noNamespaceXML = rawResponse.toXML().replaceAll("xmlns(?:.*?)?=\"http://mws.amazonservices.com/schema/OffAmazonPayments/2013-01-01\"", "");
        StringReader reader = new StringReader(noNamespaceXML);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            ErrorResponse result = (ErrorResponse)unmarshaller.unmarshal(xmlStreamReader);
            throw new AmazonServiceException(result, rawResponse);
        }
        catch (XMLStreamException e) {
            throw new AmazonClientException(rawResponse, "Encountered marshalling error while marshalling data " + rawResponse.toXML(), e);
        }
    }
}

