/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.stash.client.util;

import com.appscode.stash.client.util.WebSockets;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ws.WebSocket;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStreamHandler
implements WebSockets.SocketListener,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(WebSocketStreamHandler.class);
    private final Map<Integer, PipedInputStream> input = new HashMap<Integer, PipedInputStream>();
    private final Map<Integer, PipedOutputStream> pipedOutput = new HashMap<Integer, PipedOutputStream>();
    private final Map<Integer, OutputStream> output = new HashMap<Integer, OutputStream>();
    private WebSocket socket;
    private String protocol;
    private State state = State.UNINITIALIZED;

    @Override
    public synchronized void open(String protocol, WebSocket socket) {
        if (this.state != State.UNINITIALIZED) {
            throw new IllegalStateException();
        }
        this.protocol = protocol;
        this.socket = socket;
        this.state = State.OPEN;
        this.notifyAll();
    }

    @Override
    public void bytesMessage(InputStream in) {
        try {
            this.handleMessage(in.read(), in);
        }
        catch (IOException ex) {
            log.error("Error reading message channel", (Throwable)ex);
        }
    }

    @Override
    public void textMessage(Reader in) {
        try {
            this.handleMessage(in.read(), new ByteArrayInputStream(CharStreams.toString((Readable)in).getBytes(Charsets.UTF_8)));
        }
        catch (IOException ex) {
            log.error("Error writing message", (Throwable)ex);
        }
    }

    protected void handleMessage(int stream, InputStream inStream) throws IOException {
        OutputStream out = this.getSocketInputOutputStream(stream);
        ByteStreams.copy((InputStream)inStream, (OutputStream)out);
    }

    @Override
    public synchronized void close() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            for (PipedOutputStream pipedOutputStream : this.pipedOutput.values()) {
                try {
                    pipedOutputStream.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
            for (OutputStream outputStream : this.output.values()) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
        }
    }

    public synchronized InputStream getInputStream(int stream) {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException();
        }
        if (!this.input.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.pipedOutput.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.input.get(stream);
    }

    public synchronized OutputStream getOutputStream(int stream) {
        if (!this.output.containsKey(stream)) {
            this.output.put(stream, new WebSocketOutputStream(stream));
        }
        return this.output.get(stream);
    }

    private synchronized OutputStream getSocketInputOutputStream(int stream) {
        if (!this.pipedOutput.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.pipedOutput.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.pipedOutput.get(stream);
    }

    private class WebSocketOutputStream
    extends OutputStream {
        private final byte stream;

        public WebSocketOutputStream(int stream) {
            this.stream = (byte)stream;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            if (WebSocketStreamHandler.this.socket == null) {
                WebSocketStreamHandler webSocketStreamHandler = WebSocketStreamHandler.this;
                synchronized (webSocketStreamHandler) {
                    if (WebSocketStreamHandler.this.state == State.CLOSED) {
                        throw new IllegalStateException();
                    }
                    if (WebSocketStreamHandler.this.socket == null) {
                        try {
                            WebSocketStreamHandler.this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                }
            }
            byte[] buffer = new byte[length + 1];
            buffer[0] = this.stream;
            System.arraycopy(b, offset, buffer, 1, length);
            WebSocketStreamHandler.this.socket.sendMessage(RequestBody.create((MediaType)WebSocket.BINARY, (ByteString)ByteString.of((byte[])buffer)));
        }
    }

    private static enum State {
        UNINITIALIZED,
        OPEN,
        CLOSED;

    }
}

