/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.stash.client.util.authenticators;

import com.appscode.stash.client.util.KubeConfig;
import com.appscode.stash.client.util.authenticators.Authenticator;
import java.util.Date;
import java.util.Map;

public class GCPAuthenticator
implements Authenticator {
    @Override
    public String getName() {
        return "gcp";
    }

    @Override
    public String getToken(Map<String, Object> config) {
        return (String)config.get("access-token");
    }

    @Override
    public boolean isExpired(Map<String, Object> config) {
        Date expiry = (Date)config.get("expiry");
        return expiry != null && expiry.compareTo(new Date()) <= 0;
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config) {
        throw new IllegalStateException("Unimplemented");
    }

    static {
        KubeConfig.registerAuthenticator(new GCPAuthenticator());
    }
}

