/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.stash.client.util.credentials;

import com.appscode.stash.client.ApiClient;
import com.appscode.stash.client.util.KubeConfig;
import com.appscode.stash.client.util.credentials.AccessTokenAuthentication;
import com.appscode.stash.client.util.credentials.Authentication;
import com.appscode.stash.client.util.credentials.ClientCertificateAuthentication;
import com.appscode.stash.client.util.credentials.UsernamePasswordAuthentication;
import java.io.IOException;

public class KubeconfigAuthentication
implements Authentication {
    private final String username;
    private final String password;
    private final String token;
    private final byte[] clientCert;
    private final byte[] clientKey;

    public KubeconfigAuthentication(KubeConfig config) throws IOException {
        this.clientCert = KubeConfig.getDataOrFile(config.getClientCertificateData(), config.getClientCertificateFile());
        this.clientKey = KubeConfig.getDataOrFile(config.getClientKeyData(), config.getClientKeyFile());
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.token = config.getAccessToken();
    }

    @Override
    public void provide(ApiClient client) {
        if (this.clientCert != null && this.clientKey != null) {
            new ClientCertificateAuthentication(this.clientCert, this.clientKey).provide(client);
        }
        if (this.username != null && this.password != null) {
            new UsernamePasswordAuthentication(this.username, this.password).provide(client);
        }
        if (this.token != null) {
            new AccessTokenAuthentication(this.token).provide(client);
        }
    }
}

