/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.AudioData;
import com.assemblyai.api.resources.realtime.types.FinalTranscript;
import com.assemblyai.api.resources.realtime.types.PartialTranscript;
import com.assemblyai.api.resources.realtime.types.RealtimeError;
import com.assemblyai.api.resources.realtime.types.RealtimeMessage;
import com.assemblyai.api.resources.realtime.types.RealtimeTranscript;
import com.assemblyai.api.resources.realtime.types.SessionBegins;
import com.assemblyai.api.resources.realtime.types.SessionTerminated;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealtimeTranscriber
implements AutoCloseable {
    private static final String BASE_URL = "wss://api.assemblyai.com";
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient.Builder().build();
    private final String apiKey;
    private final int sampleRate;
    private final Optional<List<String>> wordBoost;
    private final Consumer<SessionBegins> onSessionStart;
    private final Consumer<PartialTranscript> onPartialTranscript;
    private final Consumer<FinalTranscript> onFinalTranscript;
    private final Consumer<RealtimeTranscript> onTranscript;
    private final Consumer<Throwable> onError;
    private final RealtimeMessageVisitor realtimeMessageVisitor;
    private WebSocket webSocket;

    private RealtimeTranscriber(String apiKey, int sampleRate, Optional<List<String>> wordBoost, Consumer<SessionBegins> onSessionStart, Consumer<PartialTranscript> onPartialTranscript, Consumer<FinalTranscript> onFinalTranscript, Consumer<RealtimeTranscript> onTranscript, Consumer<Throwable> onError) {
        this.apiKey = apiKey;
        this.sampleRate = sampleRate;
        this.onSessionStart = onSessionStart;
        this.onPartialTranscript = onPartialTranscript;
        this.onFinalTranscript = onFinalTranscript;
        this.onTranscript = onTranscript;
        this.wordBoost = wordBoost;
        this.onError = onError;
        this.realtimeMessageVisitor = new RealtimeMessageVisitor();
    }

    public void connect() {
        String url = "wss://api.assemblyai.com/v2/realtime/ws?sample_rate=" + this.sampleRate;
        if (this.wordBoost.isPresent() && !this.wordBoost.get().isEmpty()) {
            try {
                url = url + "&word_boost=" + ObjectMappers.JSON_MAPPER.writeValueAsString(this.wordBoost.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize word boosts");
            }
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", this.apiKey).build();
        this.webSocket = OK_HTTP_CLIENT.newWebSocket(request, (WebSocketListener)new Listener());
    }

    public void sendAudio(byte[] data) {
        String encoded = new String(Base64.getEncoder().encode(data), StandardCharsets.UTF_8);
        this.sendAudio(encoded);
    }

    public void sendAudio(String data) {
        try {
            AudioData audioData = AudioData.builder().audioData(data).build();
            this.webSocket.send(ObjectMappers.JSON_MAPPER.writeValueAsString((Object)audioData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        boolean closed = this.webSocket.close(1000, "Shutting down");
        if (!closed) {
            this.webSocket.cancel();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class RealtimeMessageVisitor
    implements RealtimeMessage.Visitor<Void> {
        private RealtimeMessageVisitor() {
        }

        @Override
        public Void visit(SessionBegins value) {
            RealtimeTranscriber.this.onSessionStart.accept(value);
            return null;
        }

        @Override
        public Void visit(PartialTranscript value) {
            RealtimeTranscriber.this.onPartialTranscript.accept(value);
            RealtimeTranscriber.this.onTranscript.accept(RealtimeTranscript.of(value));
            return null;
        }

        @Override
        public Void visit(FinalTranscript value) {
            RealtimeTranscriber.this.onFinalTranscript.accept(value);
            RealtimeTranscriber.this.onTranscript.accept(RealtimeTranscript.of(value));
            return null;
        }

        @Override
        public Void visit(SessionTerminated value) {
            return null;
        }

        @Override
        public Void visit(RealtimeError value) {
            RealtimeTranscriber.this.onError.accept(new Exception(value.getError()));
            return null;
        }
    }

    private final class Listener
    extends WebSocketListener {
        private Listener() {
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
            try {
                RealtimeMessage realtimeMessage = (RealtimeMessage)ObjectMappers.JSON_MAPPER.readValue(text, RealtimeMessage.class);
                realtimeMessage.visit(RealtimeTranscriber.this.realtimeMessageVisitor);
            }
            catch (JsonProcessingException e) {
                RealtimeTranscriber.this.onError.accept(e);
            }
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            RealtimeTranscriber.this.onError.accept(t);
        }
    }

    public static final class Builder {
        private static final int DEFAULT_SAMPLE_RATE = 16000;
        private String apiKey;
        private Integer sampleRate;
        private List<String> wordBoost;
        private Consumer<SessionBegins> onSessionStart = _unused -> {};
        private Consumer<PartialTranscript> onPartialTranscript = _unused -> {};
        private Consumer<FinalTranscript> onFinalTranscript = _unused -> {};
        private Consumer<RealtimeTranscript> onTranscript = _unused -> {};
        private Consumer<Throwable> onError;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder wordBoost(List<String> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        public Builder onSessionStart(Consumer<SessionBegins> onSessionStart) {
            this.onSessionStart = onSessionStart;
            return this;
        }

        public Builder onPartialTranscript(Consumer<PartialTranscript> onPartialTranscript) {
            this.onPartialTranscript = onPartialTranscript;
            return this;
        }

        public Builder onFinalTranscript(Consumer<FinalTranscript> onFinalTranscript) {
            this.onFinalTranscript = onFinalTranscript;
            return this;
        }

        public Builder onTranscript(Consumer<RealtimeTranscript> onTranscript) {
            this.onTranscript = onTranscript;
            return this;
        }

        public Builder onError(Consumer<Throwable> onError) {
            this.onError = onError;
            return this;
        }

        public RealtimeTranscriber build() {
            if (this.apiKey == null) {
                throw new RuntimeException("apiKey must be specified to construct RealtimeTranscriber");
            }
            return new RealtimeTranscriber(this.apiKey, this.sampleRate == null ? 16000 : this.sampleRate, Optional.ofNullable(this.wordBoost), this.onSessionStart, this.onPartialTranscript, this.onFinalTranscript, this.onTranscript, this.onError);
        }
    }
}

