/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class LemurModel {
    public static final LemurModel ASSEMBLYAI_MISTRAL_7_B = new LemurModel(Value.ASSEMBLYAI_MISTRAL_7_B, "assemblyai/mistral-7b");
    public static final LemurModel BASIC = new LemurModel(Value.BASIC, "basic");
    public static final LemurModel DEFAULT = new LemurModel(Value.DEFAULT, "default");
    private final Value value;
    private final String string;

    LemurModel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LemurModel && this.string.equals(((LemurModel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case ASSEMBLYAI_MISTRAL_7_B: {
                return visitor.visitAssemblyaiMistral7B();
            }
            case BASIC: {
                return visitor.visitBasic();
            }
            case DEFAULT: {
                return visitor.visitDefault();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LemurModel valueOf(String value) {
        switch (value) {
            case "assemblyai/mistral-7b": {
                return ASSEMBLYAI_MISTRAL_7_B;
            }
            case "basic": {
                return BASIC;
            }
            case "default": {
                return DEFAULT;
            }
        }
        return new LemurModel(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitDefault();

        public T visitBasic();

        public T visitAssemblyaiMistral7B();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        DEFAULT,
        BASIC,
        ASSEMBLYAI_MISTRAL_7_B,
        UNKNOWN;

    }
}

