/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.FinalTranscript;
import com.assemblyai.api.resources.realtime.types.PartialTranscript;
import com.assemblyai.api.resources.realtime.types.RealtimeError;
import com.assemblyai.api.resources.realtime.types.SessionBegins;
import com.assemblyai.api.resources.realtime.types.SessionTerminated;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
public final class RealtimeMessage {
    private final Object value;
    private final int type;

    private RealtimeMessage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((SessionBegins)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((PartialTranscript)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((FinalTranscript)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((SessionTerminated)this.value);
        }
        if (this.type == 4) {
            return visitor.visit((RealtimeError)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RealtimeMessage && this.equalTo((RealtimeMessage)other);
    }

    private boolean equalTo(RealtimeMessage other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static RealtimeMessage of(SessionBegins value) {
        return new RealtimeMessage(value, 0);
    }

    public static RealtimeMessage of(PartialTranscript value) {
        return new RealtimeMessage(value, 1);
    }

    public static RealtimeMessage of(FinalTranscript value) {
        return new RealtimeMessage(value, 2);
    }

    public static RealtimeMessage of(SessionTerminated value) {
        return new RealtimeMessage(value, 3);
    }

    public static RealtimeMessage of(RealtimeError value) {
        return new RealtimeMessage(value, 4);
    }

    static final class Deserializer
    extends StdDeserializer<RealtimeMessage> {
        Deserializer() {
            super(RealtimeMessage.class);
        }

        public RealtimeMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String json = ObjectMappers.JSON_MAPPER.writeValueAsString(p.readValueAs(Object.class));
            Optional<SessionBegins> sessionBegins = ObjectMappers.parse(json, SessionBegins.class);
            if (sessionBegins.isPresent()) {
                return RealtimeMessage.of(sessionBegins.get());
            }
            Optional<PartialTranscript> partialTranscript = ObjectMappers.parse(json, PartialTranscript.class);
            if (partialTranscript.isPresent()) {
                return RealtimeMessage.of(partialTranscript.get());
            }
            Optional<FinalTranscript> finalTranscript = ObjectMappers.parse(json, FinalTranscript.class);
            if (finalTranscript.isPresent()) {
                return RealtimeMessage.of(finalTranscript.get());
            }
            Optional<SessionTerminated> sessionTerminated = ObjectMappers.parse(json, SessionTerminated.class);
            if (sessionTerminated.isPresent()) {
                return RealtimeMessage.of(sessionTerminated.get());
            }
            Optional<RealtimeError> realtimeError = ObjectMappers.parse(json, RealtimeError.class);
            if (realtimeError.isPresent()) {
                return RealtimeMessage.of(sessionBegins.get());
            }
            throw new JsonParseException(p, "Received unknown RealtimeMessage: " + json);
        }
    }

    public static interface Visitor<T> {
        public T visit(SessionBegins var1);

        public T visit(PartialTranscript var1);

        public T visit(FinalTranscript var1);

        public T visit(SessionTerminated var1);

        public T visit(RealtimeError var1);
    }
}

