/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts;

import com.assemblyai.api.core.ApiError;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.MediaTypes;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.resources.transcripts.requests.GetSubtitlesParams;
import com.assemblyai.api.resources.transcripts.requests.ListTranscriptParams;
import com.assemblyai.api.resources.transcripts.requests.TranscriptParams;
import com.assemblyai.api.resources.transcripts.requests.WordSearchParams;
import com.assemblyai.api.resources.transcripts.types.ParagraphsResponse;
import com.assemblyai.api.resources.transcripts.types.RedactedAudioResponse;
import com.assemblyai.api.resources.transcripts.types.SentencesResponse;
import com.assemblyai.api.resources.transcripts.types.SubtitleFormat;
import com.assemblyai.api.resources.transcripts.types.Transcript;
import com.assemblyai.api.resources.transcripts.types.TranscriptList;
import com.assemblyai.api.resources.transcripts.types.WordSearchResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TranscriptsClient {
    protected final ClientOptions clientOptions;

    public TranscriptsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public TranscriptList list() {
        return this.list(ListTranscriptParams.builder().build());
    }

    public TranscriptList list(ListTranscriptParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript");
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getStatus().isPresent()) {
            httpUrl.addQueryParameter("status", request.getStatus().get().toString());
        }
        if (request.getCreatedOn().isPresent()) {
            httpUrl.addQueryParameter("created_on", request.getCreatedOn().get());
        }
        if (request.getBeforeId().isPresent()) {
            httpUrl.addQueryParameter("before_id", request.getBeforeId().get());
        }
        if (request.getAfterId().isPresent()) {
            httpUrl.addQueryParameter("after_id", request.getAfterId().get());
        }
        if (request.getThrottledOnly().isPresent()) {
            httpUrl.addQueryParameter("throttled_only", request.getThrottledOnly().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (TranscriptList)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), TranscriptList.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TranscriptList list(ListTranscriptParams request) {
        return this.list(request, null);
    }

    public Transcript submit(TranscriptParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Transcript)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Transcript.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Transcript submit(TranscriptParams request) {
        return this.submit(request, null);
    }

    public Transcript get(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Transcript)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Transcript.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Transcript get(String transcriptId) {
        return this.get(transcriptId, null);
    }

    public Transcript delete(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Transcript)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Transcript.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Transcript delete(String transcriptId) {
        return this.delete(transcriptId, null);
    }

    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat) {
        return this.getSubtitles(transcriptId, subtitleFormat, GetSubtitlesParams.builder().build());
    }

    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat, GetSubtitlesParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegment(subtitleFormat.toString());
        if (request.getCharsPerCaption().isPresent()) {
            httpUrl.addQueryParameter("chars_per_caption", request.getCharsPerCaption().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return response.body().string();
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSubtitles(String transcriptId, SubtitleFormat subtitleFormat, GetSubtitlesParams request) {
        return this.getSubtitles(transcriptId, subtitleFormat, request, null);
    }

    public SentencesResponse getSentences(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("sentences").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (SentencesResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), SentencesResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SentencesResponse getSentences(String transcriptId) {
        return this.getSentences(transcriptId, null);
    }

    public ParagraphsResponse getParagraphs(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("paragraphs").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ParagraphsResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ParagraphsResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParagraphsResponse getParagraphs(String transcriptId) {
        return this.getParagraphs(transcriptId, null);
    }

    public WordSearchResponse wordSearch(String transcriptId) {
        return this.wordSearch(transcriptId, WordSearchParams.builder().build());
    }

    public WordSearchResponse wordSearch(String transcriptId, WordSearchParams request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("word-search");
        if (request.getWords().isPresent()) {
            httpUrl.addQueryParameter("words", request.getWords().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (WordSearchResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), WordSearchResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WordSearchResponse wordSearch(String transcriptId, WordSearchParams request) {
        return this.wordSearch(transcriptId, request, null);
    }

    public RedactedAudioResponse getRedactedAudio(String transcriptId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/transcript").addPathSegment(transcriptId).addPathSegments("redacted-audio").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (RedactedAudioResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), RedactedAudioResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RedactedAudioResponse getRedactedAudio(String transcriptId) {
        return this.getRedactedAudio(transcriptId, null);
    }
}

