/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PageDetails {
    private final int limit;
    private final int resultCount;
    private final String currentUrl;
    private final String prevUrl;
    private final Optional<String> nextUrl;
    private final Map<String, Object> additionalProperties;

    private PageDetails(int limit, int resultCount, String currentUrl, String prevUrl, Optional<String> nextUrl, Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.resultCount = resultCount;
        this.currentUrl = currentUrl;
        this.prevUrl = prevUrl;
        this.nextUrl = nextUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="limit")
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="result_count")
    public int getResultCount() {
        return this.resultCount;
    }

    @JsonProperty(value="current_url")
    public String getCurrentUrl() {
        return this.currentUrl;
    }

    @JsonProperty(value="prev_url")
    public String getPrevUrl() {
        return this.prevUrl;
    }

    @JsonProperty(value="next_url")
    public Optional<String> getNextUrl() {
        return this.nextUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PageDetails && this.equalTo((PageDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PageDetails other) {
        return this.limit == other.limit && this.resultCount == other.resultCount && this.currentUrl.equals(other.currentUrl) && this.prevUrl.equals(other.prevUrl) && this.nextUrl.equals(other.nextUrl);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.resultCount, this.currentUrl, this.prevUrl, this.nextUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LimitStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LimitStage,
    ResultCountStage,
    CurrentUrlStage,
    PrevUrlStage,
    _FinalStage {
        private int limit;
        private int resultCount;
        private String currentUrl;
        private String prevUrl;
        private Optional<String> nextUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PageDetails other) {
            this.limit(other.getLimit());
            this.resultCount(other.getResultCount());
            this.currentUrl(other.getCurrentUrl());
            this.prevUrl(other.getPrevUrl());
            this.nextUrl(other.getNextUrl());
            return this;
        }

        @Override
        @JsonSetter(value="limit")
        public ResultCountStage limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        @JsonSetter(value="result_count")
        public CurrentUrlStage resultCount(int resultCount) {
            this.resultCount = resultCount;
            return this;
        }

        @Override
        @JsonSetter(value="current_url")
        public PrevUrlStage currentUrl(String currentUrl) {
            this.currentUrl = currentUrl;
            return this;
        }

        @Override
        @JsonSetter(value="prev_url")
        public _FinalStage prevUrl(String prevUrl) {
            this.prevUrl = prevUrl;
            return this;
        }

        @Override
        public _FinalStage nextUrl(String nextUrl) {
            this.nextUrl = Optional.of(nextUrl);
            return this;
        }

        @Override
        @JsonSetter(value="next_url", nulls=Nulls.SKIP)
        public _FinalStage nextUrl(Optional<String> nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        @Override
        public PageDetails build() {
            return new PageDetails(this.limit, this.resultCount, this.currentUrl, this.prevUrl, this.nextUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PageDetails build();

        public _FinalStage nextUrl(Optional<String> var1);

        public _FinalStage nextUrl(String var1);
    }

    public static interface PrevUrlStage {
        public _FinalStage prevUrl(String var1);
    }

    public static interface CurrentUrlStage {
        public PrevUrlStage currentUrl(String var1);
    }

    public static interface ResultCountStage {
        public CurrentUrlStage resultCount(int var1);
    }

    public static interface LimitStage {
        public ResultCountStage limit(int var1);

        public Builder from(PageDetails var1);
    }
}

