/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.WordSearchMatch;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WordSearchResponse {
    private final String id;
    private final int totalCount;
    private final List<WordSearchMatch> matches;
    private final Map<String, Object> additionalProperties;

    private WordSearchResponse(String id, int totalCount, List<WordSearchMatch> matches, Map<String, Object> additionalProperties) {
        this.id = id;
        this.totalCount = totalCount;
        this.matches = matches;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="matches")
    public List<WordSearchMatch> getMatches() {
        return this.matches;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WordSearchResponse && this.equalTo((WordSearchResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WordSearchResponse other) {
        return this.id.equals(other.id) && this.totalCount == other.totalCount && this.matches.equals(other.matches);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.totalCount, this.matches);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TotalCountStage,
    _FinalStage {
        private String id;
        private int totalCount;
        private List<WordSearchMatch> matches = new ArrayList<WordSearchMatch>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WordSearchResponse other) {
            this.id(other.getId());
            this.totalCount(other.getTotalCount());
            this.matches(other.getMatches());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TotalCountStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllMatches(List<WordSearchMatch> matches) {
            this.matches.addAll(matches);
            return this;
        }

        @Override
        public _FinalStage addMatches(WordSearchMatch matches) {
            this.matches.add(matches);
            return this;
        }

        @Override
        @JsonSetter(value="matches", nulls=Nulls.SKIP)
        public _FinalStage matches(List<WordSearchMatch> matches) {
            this.matches.clear();
            this.matches.addAll(matches);
            return this;
        }

        @Override
        public WordSearchResponse build() {
            return new WordSearchResponse(this.id, this.totalCount, this.matches, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WordSearchResponse build();

        public _FinalStage matches(List<WordSearchMatch> var1);

        public _FinalStage addMatches(WordSearchMatch var1);

        public _FinalStage addAllMatches(List<WordSearchMatch> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);
    }

    public static interface IdStage {
        public TotalCountStage id(String var1);

        public Builder from(WordSearchResponse var1);
    }
}

