/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.FinalTranscript;
import com.assemblyai.api.resources.realtime.types.PartialTranscript;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class RealtimeTranscript {
    private final Object value;
    private final int type;

    private RealtimeTranscript(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((PartialTranscript)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((FinalTranscript)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RealtimeTranscript && this.equalTo((RealtimeTranscript)other);
    }

    private boolean equalTo(RealtimeTranscript other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static RealtimeTranscript of(PartialTranscript value) {
        return new RealtimeTranscript(value, 0);
    }

    public static RealtimeTranscript of(FinalTranscript value) {
        return new RealtimeTranscript(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<RealtimeTranscript> {
        Deserializer() {
            super(RealtimeTranscript.class);
        }

        public RealtimeTranscript deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return RealtimeTranscript.of((PartialTranscript)ObjectMappers.JSON_MAPPER.convertValue(value, PartialTranscript.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return RealtimeTranscript.of((FinalTranscript)ObjectMappers.JSON_MAPPER.convertValue(value, FinalTranscript.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(PartialTranscript var1);

        public T visit(FinalTranscript var1);
    }
}

