/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Chapter {
    private final String gist;
    private final String headline;
    private final String summary;
    private final int start;
    private final int end;
    private final Map<String, Object> additionalProperties;

    private Chapter(String gist, String headline, String summary, int start, int end, Map<String, Object> additionalProperties) {
        this.gist = gist;
        this.headline = headline;
        this.summary = summary;
        this.start = start;
        this.end = end;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="gist")
    public String getGist() {
        return this.gist;
    }

    @JsonProperty(value="headline")
    public String getHeadline() {
        return this.headline;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Chapter && this.equalTo((Chapter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Chapter other) {
        return this.gist.equals(other.gist) && this.headline.equals(other.headline) && this.summary.equals(other.summary) && this.start == other.start && this.end == other.end;
    }

    public int hashCode() {
        return Objects.hash(this.gist, this.headline, this.summary, this.start, this.end);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GistStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GistStage,
    HeadlineStage,
    SummaryStage,
    StartStage,
    EndStage,
    _FinalStage {
        private String gist;
        private String headline;
        private String summary;
        private int start;
        private int end;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Chapter other) {
            this.gist(other.getGist());
            this.headline(other.getHeadline());
            this.summary(other.getSummary());
            this.start(other.getStart());
            this.end(other.getEnd());
            return this;
        }

        @Override
        @JsonSetter(value="gist")
        public HeadlineStage gist(String gist) {
            this.gist = gist;
            return this;
        }

        @Override
        @JsonSetter(value="headline")
        public SummaryStage headline(String headline) {
            this.headline = headline;
            return this;
        }

        @Override
        @JsonSetter(value="summary")
        public StartStage summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public _FinalStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        public Chapter build() {
            return new Chapter(this.gist, this.headline, this.summary, this.start, this.end, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Chapter build();
    }

    public static interface EndStage {
        public _FinalStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);
    }

    public static interface SummaryStage {
        public StartStage summary(String var1);
    }

    public static interface HeadlineStage {
        public SummaryStage headline(String var1);
    }

    public static interface GistStage {
        public HeadlineStage gist(String var1);

        public Builder from(Chapter var1);
    }
}

