/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.AutoHighlightsResult;
import com.assemblyai.api.resources.transcripts.types.Chapter;
import com.assemblyai.api.resources.transcripts.types.ContentSafetyLabelsResult;
import com.assemblyai.api.resources.transcripts.types.Entity;
import com.assemblyai.api.resources.transcripts.types.PiiPolicy;
import com.assemblyai.api.resources.transcripts.types.RedactPiiAudioQuality;
import com.assemblyai.api.resources.transcripts.types.SentimentAnalysisResult;
import com.assemblyai.api.resources.transcripts.types.SpeechModel;
import com.assemblyai.api.resources.transcripts.types.SubstitutionPolicy;
import com.assemblyai.api.resources.transcripts.types.TopicDetectionModelResult;
import com.assemblyai.api.resources.transcripts.types.TranscriptCustomSpelling;
import com.assemblyai.api.resources.transcripts.types.TranscriptLanguageCode;
import com.assemblyai.api.resources.transcripts.types.TranscriptStatus;
import com.assemblyai.api.resources.transcripts.types.TranscriptUtterance;
import com.assemblyai.api.resources.transcripts.types.TranscriptWord;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Transcript {
    private final String id;
    private final String languageModel;
    private final String acousticModel;
    private final TranscriptStatus status;
    private final Optional<TranscriptLanguageCode> languageCode;
    private final String audioUrl;
    private final Optional<String> text;
    private final Optional<List<TranscriptWord>> words;
    private final Optional<List<TranscriptUtterance>> utterances;
    private final Optional<Double> confidence;
    private final Optional<Double> audioDuration;
    private final Optional<Boolean> punctuate;
    private final Optional<Boolean> formatText;
    private final Optional<Boolean> dualChannel;
    private final Optional<SpeechModel> speechModel;
    private final Optional<String> webhookUrl;
    private final Optional<Integer> webhookStatusCode;
    private final boolean webhookAuth;
    private final Optional<String> webhookAuthHeaderName;
    private final Optional<Boolean> speedBoost;
    private final boolean autoHighlights;
    private final Optional<AutoHighlightsResult> autoHighlightsResult;
    private final Optional<Integer> audioStartFrom;
    private final Optional<Integer> audioEndAt;
    private final Optional<List<String>> wordBoost;
    private final Optional<String> boostParam;
    private final Optional<Boolean> filterProfanity;
    private final boolean redactPii;
    private final Optional<Boolean> redactPiiAudio;
    private final Optional<RedactPiiAudioQuality> redactPiiAudioQuality;
    private final Optional<List<PiiPolicy>> redactPiiPolicies;
    private final Optional<SubstitutionPolicy> redactPiiSub;
    private final Optional<Boolean> speakerLabels;
    private final Optional<Integer> speakersExpected;
    private final Optional<Boolean> contentSafety;
    private final Optional<ContentSafetyLabelsResult> contentSafetyLabels;
    private final Optional<Boolean> iabCategories;
    private final Optional<TopicDetectionModelResult> iabCategoriesResult;
    private final Optional<Boolean> languageDetection;
    private final Optional<List<TranscriptCustomSpelling>> customSpelling;
    private final Optional<Boolean> autoChapters;
    private final Optional<List<Chapter>> chapters;
    private final boolean summarization;
    private final Optional<String> summaryType;
    private final Optional<String> summaryModel;
    private final Optional<String> summary;
    private final Optional<Boolean> customTopics;
    private final Optional<List<String>> topics;
    private final Optional<Boolean> disfluencies;
    private final Optional<Boolean> sentimentAnalysis;
    private final Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults;
    private final Optional<Boolean> entityDetection;
    private final Optional<List<Entity>> entities;
    private final Optional<Double> speechThreshold;
    private final Optional<Boolean> throttled;
    private final Optional<String> error;
    private final Map<String, Object> additionalProperties;

    private Transcript(String id, String languageModel, String acousticModel, TranscriptStatus status, Optional<TranscriptLanguageCode> languageCode, String audioUrl, Optional<String> text, Optional<List<TranscriptWord>> words, Optional<List<TranscriptUtterance>> utterances, Optional<Double> confidence, Optional<Double> audioDuration, Optional<Boolean> punctuate, Optional<Boolean> formatText, Optional<Boolean> dualChannel, Optional<SpeechModel> speechModel, Optional<String> webhookUrl, Optional<Integer> webhookStatusCode, boolean webhookAuth, Optional<String> webhookAuthHeaderName, Optional<Boolean> speedBoost, boolean autoHighlights, Optional<AutoHighlightsResult> autoHighlightsResult, Optional<Integer> audioStartFrom, Optional<Integer> audioEndAt, Optional<List<String>> wordBoost, Optional<String> boostParam, Optional<Boolean> filterProfanity, boolean redactPii, Optional<Boolean> redactPiiAudio, Optional<RedactPiiAudioQuality> redactPiiAudioQuality, Optional<List<PiiPolicy>> redactPiiPolicies, Optional<SubstitutionPolicy> redactPiiSub, Optional<Boolean> speakerLabels, Optional<Integer> speakersExpected, Optional<Boolean> contentSafety, Optional<ContentSafetyLabelsResult> contentSafetyLabels, Optional<Boolean> iabCategories, Optional<TopicDetectionModelResult> iabCategoriesResult, Optional<Boolean> languageDetection, Optional<List<TranscriptCustomSpelling>> customSpelling, Optional<Boolean> autoChapters, Optional<List<Chapter>> chapters, boolean summarization, Optional<String> summaryType, Optional<String> summaryModel, Optional<String> summary, Optional<Boolean> customTopics, Optional<List<String>> topics, Optional<Boolean> disfluencies, Optional<Boolean> sentimentAnalysis, Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults, Optional<Boolean> entityDetection, Optional<List<Entity>> entities, Optional<Double> speechThreshold, Optional<Boolean> throttled, Optional<String> error, Map<String, Object> additionalProperties) {
        this.id = id;
        this.languageModel = languageModel;
        this.acousticModel = acousticModel;
        this.status = status;
        this.languageCode = languageCode;
        this.audioUrl = audioUrl;
        this.text = text;
        this.words = words;
        this.utterances = utterances;
        this.confidence = confidence;
        this.audioDuration = audioDuration;
        this.punctuate = punctuate;
        this.formatText = formatText;
        this.dualChannel = dualChannel;
        this.speechModel = speechModel;
        this.webhookUrl = webhookUrl;
        this.webhookStatusCode = webhookStatusCode;
        this.webhookAuth = webhookAuth;
        this.webhookAuthHeaderName = webhookAuthHeaderName;
        this.speedBoost = speedBoost;
        this.autoHighlights = autoHighlights;
        this.autoHighlightsResult = autoHighlightsResult;
        this.audioStartFrom = audioStartFrom;
        this.audioEndAt = audioEndAt;
        this.wordBoost = wordBoost;
        this.boostParam = boostParam;
        this.filterProfanity = filterProfanity;
        this.redactPii = redactPii;
        this.redactPiiAudio = redactPiiAudio;
        this.redactPiiAudioQuality = redactPiiAudioQuality;
        this.redactPiiPolicies = redactPiiPolicies;
        this.redactPiiSub = redactPiiSub;
        this.speakerLabels = speakerLabels;
        this.speakersExpected = speakersExpected;
        this.contentSafety = contentSafety;
        this.contentSafetyLabels = contentSafetyLabels;
        this.iabCategories = iabCategories;
        this.iabCategoriesResult = iabCategoriesResult;
        this.languageDetection = languageDetection;
        this.customSpelling = customSpelling;
        this.autoChapters = autoChapters;
        this.chapters = chapters;
        this.summarization = summarization;
        this.summaryType = summaryType;
        this.summaryModel = summaryModel;
        this.summary = summary;
        this.customTopics = customTopics;
        this.topics = topics;
        this.disfluencies = disfluencies;
        this.sentimentAnalysis = sentimentAnalysis;
        this.sentimentAnalysisResults = sentimentAnalysisResults;
        this.entityDetection = entityDetection;
        this.entities = entities;
        this.speechThreshold = speechThreshold;
        this.throttled = throttled;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="language_model")
    public String getLanguageModel() {
        return this.languageModel;
    }

    @JsonProperty(value="acoustic_model")
    public String getAcousticModel() {
        return this.acousticModel;
    }

    @JsonProperty(value="status")
    public TranscriptStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="language_code")
    public Optional<TranscriptLanguageCode> getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="audio_url")
    public String getAudioUrl() {
        return this.audioUrl;
    }

    @JsonProperty(value="text")
    public Optional<String> getText() {
        return this.text;
    }

    @JsonProperty(value="words")
    public Optional<List<TranscriptWord>> getWords() {
        return this.words;
    }

    @JsonProperty(value="utterances")
    public Optional<List<TranscriptUtterance>> getUtterances() {
        return this.utterances;
    }

    @JsonProperty(value="confidence")
    public Optional<Double> getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="audio_duration")
    public Optional<Double> getAudioDuration() {
        return this.audioDuration;
    }

    @JsonProperty(value="punctuate")
    public Optional<Boolean> getPunctuate() {
        return this.punctuate;
    }

    @JsonProperty(value="format_text")
    public Optional<Boolean> getFormatText() {
        return this.formatText;
    }

    @JsonProperty(value="dual_channel")
    public Optional<Boolean> getDualChannel() {
        return this.dualChannel;
    }

    @JsonProperty(value="speech_model")
    public Optional<SpeechModel> getSpeechModel() {
        return this.speechModel;
    }

    @JsonProperty(value="webhook_url")
    public Optional<String> getWebhookUrl() {
        return this.webhookUrl;
    }

    @JsonProperty(value="webhook_status_code")
    public Optional<Integer> getWebhookStatusCode() {
        return this.webhookStatusCode;
    }

    @JsonProperty(value="webhook_auth")
    public boolean getWebhookAuth() {
        return this.webhookAuth;
    }

    @JsonProperty(value="webhook_auth_header_name")
    public Optional<String> getWebhookAuthHeaderName() {
        return this.webhookAuthHeaderName;
    }

    @JsonProperty(value="speed_boost")
    public Optional<Boolean> getSpeedBoost() {
        return this.speedBoost;
    }

    @JsonProperty(value="auto_highlights")
    public boolean getAutoHighlights() {
        return this.autoHighlights;
    }

    @JsonProperty(value="auto_highlights_result")
    public Optional<AutoHighlightsResult> getAutoHighlightsResult() {
        return this.autoHighlightsResult;
    }

    @JsonProperty(value="audio_start_from")
    public Optional<Integer> getAudioStartFrom() {
        return this.audioStartFrom;
    }

    @JsonProperty(value="audio_end_at")
    public Optional<Integer> getAudioEndAt() {
        return this.audioEndAt;
    }

    @JsonProperty(value="word_boost")
    public Optional<List<String>> getWordBoost() {
        return this.wordBoost;
    }

    @JsonProperty(value="boost_param")
    public Optional<String> getBoostParam() {
        return this.boostParam;
    }

    @JsonProperty(value="filter_profanity")
    public Optional<Boolean> getFilterProfanity() {
        return this.filterProfanity;
    }

    @JsonProperty(value="redact_pii")
    public boolean getRedactPii() {
        return this.redactPii;
    }

    @JsonProperty(value="redact_pii_audio")
    public Optional<Boolean> getRedactPiiAudio() {
        return this.redactPiiAudio;
    }

    @JsonProperty(value="redact_pii_audio_quality")
    public Optional<RedactPiiAudioQuality> getRedactPiiAudioQuality() {
        return this.redactPiiAudioQuality;
    }

    @JsonProperty(value="redact_pii_policies")
    public Optional<List<PiiPolicy>> getRedactPiiPolicies() {
        return this.redactPiiPolicies;
    }

    @JsonProperty(value="redact_pii_sub")
    public Optional<SubstitutionPolicy> getRedactPiiSub() {
        return this.redactPiiSub;
    }

    @JsonProperty(value="speaker_labels")
    public Optional<Boolean> getSpeakerLabels() {
        return this.speakerLabels;
    }

    @JsonProperty(value="speakers_expected")
    public Optional<Integer> getSpeakersExpected() {
        return this.speakersExpected;
    }

    @JsonProperty(value="content_safety")
    public Optional<Boolean> getContentSafety() {
        return this.contentSafety;
    }

    @JsonProperty(value="content_safety_labels")
    public Optional<ContentSafetyLabelsResult> getContentSafetyLabels() {
        return this.contentSafetyLabels;
    }

    @JsonProperty(value="iab_categories")
    public Optional<Boolean> getIabCategories() {
        return this.iabCategories;
    }

    @JsonProperty(value="iab_categories_result")
    public Optional<TopicDetectionModelResult> getIabCategoriesResult() {
        return this.iabCategoriesResult;
    }

    @JsonProperty(value="language_detection")
    public Optional<Boolean> getLanguageDetection() {
        return this.languageDetection;
    }

    @JsonProperty(value="custom_spelling")
    public Optional<List<TranscriptCustomSpelling>> getCustomSpelling() {
        return this.customSpelling;
    }

    @JsonProperty(value="auto_chapters")
    public Optional<Boolean> getAutoChapters() {
        return this.autoChapters;
    }

    @JsonProperty(value="chapters")
    public Optional<List<Chapter>> getChapters() {
        return this.chapters;
    }

    @JsonProperty(value="summarization")
    public boolean getSummarization() {
        return this.summarization;
    }

    @JsonProperty(value="summary_type")
    public Optional<String> getSummaryType() {
        return this.summaryType;
    }

    @JsonProperty(value="summary_model")
    public Optional<String> getSummaryModel() {
        return this.summaryModel;
    }

    @JsonProperty(value="summary")
    public Optional<String> getSummary() {
        return this.summary;
    }

    @JsonProperty(value="custom_topics")
    public Optional<Boolean> getCustomTopics() {
        return this.customTopics;
    }

    @JsonProperty(value="topics")
    public Optional<List<String>> getTopics() {
        return this.topics;
    }

    @JsonProperty(value="disfluencies")
    public Optional<Boolean> getDisfluencies() {
        return this.disfluencies;
    }

    @JsonProperty(value="sentiment_analysis")
    public Optional<Boolean> getSentimentAnalysis() {
        return this.sentimentAnalysis;
    }

    @JsonProperty(value="sentiment_analysis_results")
    public Optional<List<SentimentAnalysisResult>> getSentimentAnalysisResults() {
        return this.sentimentAnalysisResults;
    }

    @JsonProperty(value="entity_detection")
    public Optional<Boolean> getEntityDetection() {
        return this.entityDetection;
    }

    @JsonProperty(value="entities")
    public Optional<List<Entity>> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="speech_threshold")
    public Optional<Double> getSpeechThreshold() {
        return this.speechThreshold;
    }

    @JsonProperty(value="throttled")
    public Optional<Boolean> getThrottled() {
        return this.throttled;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Transcript && this.equalTo((Transcript)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Transcript other) {
        return this.id.equals(other.id) && this.languageModel.equals(other.languageModel) && this.acousticModel.equals(other.acousticModel) && this.status.equals(other.status) && this.languageCode.equals(other.languageCode) && this.audioUrl.equals(other.audioUrl) && this.text.equals(other.text) && this.words.equals(other.words) && this.utterances.equals(other.utterances) && this.confidence.equals(other.confidence) && this.audioDuration.equals(other.audioDuration) && this.punctuate.equals(other.punctuate) && this.formatText.equals(other.formatText) && this.dualChannel.equals(other.dualChannel) && this.speechModel.equals(other.speechModel) && this.webhookUrl.equals(other.webhookUrl) && this.webhookStatusCode.equals(other.webhookStatusCode) && this.webhookAuth == other.webhookAuth && this.webhookAuthHeaderName.equals(other.webhookAuthHeaderName) && this.speedBoost.equals(other.speedBoost) && this.autoHighlights == other.autoHighlights && this.autoHighlightsResult.equals(other.autoHighlightsResult) && this.audioStartFrom.equals(other.audioStartFrom) && this.audioEndAt.equals(other.audioEndAt) && this.wordBoost.equals(other.wordBoost) && this.boostParam.equals(other.boostParam) && this.filterProfanity.equals(other.filterProfanity) && this.redactPii == other.redactPii && this.redactPiiAudio.equals(other.redactPiiAudio) && this.redactPiiAudioQuality.equals(other.redactPiiAudioQuality) && this.redactPiiPolicies.equals(other.redactPiiPolicies) && this.redactPiiSub.equals(other.redactPiiSub) && this.speakerLabels.equals(other.speakerLabels) && this.speakersExpected.equals(other.speakersExpected) && this.contentSafety.equals(other.contentSafety) && this.contentSafetyLabels.equals(other.contentSafetyLabels) && this.iabCategories.equals(other.iabCategories) && this.iabCategoriesResult.equals(other.iabCategoriesResult) && this.languageDetection.equals(other.languageDetection) && this.customSpelling.equals(other.customSpelling) && this.autoChapters.equals(other.autoChapters) && this.chapters.equals(other.chapters) && this.summarization == other.summarization && this.summaryType.equals(other.summaryType) && this.summaryModel.equals(other.summaryModel) && this.summary.equals(other.summary) && this.customTopics.equals(other.customTopics) && this.topics.equals(other.topics) && this.disfluencies.equals(other.disfluencies) && this.sentimentAnalysis.equals(other.sentimentAnalysis) && this.sentimentAnalysisResults.equals(other.sentimentAnalysisResults) && this.entityDetection.equals(other.entityDetection) && this.entities.equals(other.entities) && this.speechThreshold.equals(other.speechThreshold) && this.throttled.equals(other.throttled) && this.error.equals(other.error);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.languageModel, this.acousticModel, this.status, this.languageCode, this.audioUrl, this.text, this.words, this.utterances, this.confidence, this.audioDuration, this.punctuate, this.formatText, this.dualChannel, this.speechModel, this.webhookUrl, this.webhookStatusCode, this.webhookAuth, this.webhookAuthHeaderName, this.speedBoost, this.autoHighlights, this.autoHighlightsResult, this.audioStartFrom, this.audioEndAt, this.wordBoost, this.boostParam, this.filterProfanity, this.redactPii, this.redactPiiAudio, this.redactPiiAudioQuality, this.redactPiiPolicies, this.redactPiiSub, this.speakerLabels, this.speakersExpected, this.contentSafety, this.contentSafetyLabels, this.iabCategories, this.iabCategoriesResult, this.languageDetection, this.customSpelling, this.autoChapters, this.chapters, this.summarization, this.summaryType, this.summaryModel, this.summary, this.customTopics, this.topics, this.disfluencies, this.sentimentAnalysis, this.sentimentAnalysisResults, this.entityDetection, this.entities, this.speechThreshold, this.throttled, this.error);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LanguageModelStage,
    AcousticModelStage,
    StatusStage,
    AudioUrlStage,
    WebhookAuthStage,
    AutoHighlightsStage,
    RedactPiiStage,
    SummarizationStage,
    _FinalStage {
        private String id;
        private String languageModel;
        private String acousticModel;
        private TranscriptStatus status;
        private String audioUrl;
        private boolean webhookAuth;
        private boolean autoHighlights;
        private boolean redactPii;
        private boolean summarization;
        private Optional<String> error = Optional.empty();
        private Optional<Boolean> throttled = Optional.empty();
        private Optional<Double> speechThreshold = Optional.empty();
        private Optional<List<Entity>> entities = Optional.empty();
        private Optional<Boolean> entityDetection = Optional.empty();
        private Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults = Optional.empty();
        private Optional<Boolean> sentimentAnalysis = Optional.empty();
        private Optional<Boolean> disfluencies = Optional.empty();
        private Optional<List<String>> topics = Optional.empty();
        private Optional<Boolean> customTopics = Optional.empty();
        private Optional<String> summary = Optional.empty();
        private Optional<String> summaryModel = Optional.empty();
        private Optional<String> summaryType = Optional.empty();
        private Optional<List<Chapter>> chapters = Optional.empty();
        private Optional<Boolean> autoChapters = Optional.empty();
        private Optional<List<TranscriptCustomSpelling>> customSpelling = Optional.empty();
        private Optional<Boolean> languageDetection = Optional.empty();
        private Optional<TopicDetectionModelResult> iabCategoriesResult = Optional.empty();
        private Optional<Boolean> iabCategories = Optional.empty();
        private Optional<ContentSafetyLabelsResult> contentSafetyLabels = Optional.empty();
        private Optional<Boolean> contentSafety = Optional.empty();
        private Optional<Integer> speakersExpected = Optional.empty();
        private Optional<Boolean> speakerLabels = Optional.empty();
        private Optional<SubstitutionPolicy> redactPiiSub = Optional.empty();
        private Optional<List<PiiPolicy>> redactPiiPolicies = Optional.empty();
        private Optional<RedactPiiAudioQuality> redactPiiAudioQuality = Optional.empty();
        private Optional<Boolean> redactPiiAudio = Optional.empty();
        private Optional<Boolean> filterProfanity = Optional.empty();
        private Optional<String> boostParam = Optional.empty();
        private Optional<List<String>> wordBoost = Optional.empty();
        private Optional<Integer> audioEndAt = Optional.empty();
        private Optional<Integer> audioStartFrom = Optional.empty();
        private Optional<AutoHighlightsResult> autoHighlightsResult = Optional.empty();
        private Optional<Boolean> speedBoost = Optional.empty();
        private Optional<String> webhookAuthHeaderName = Optional.empty();
        private Optional<Integer> webhookStatusCode = Optional.empty();
        private Optional<String> webhookUrl = Optional.empty();
        private Optional<SpeechModel> speechModel = Optional.empty();
        private Optional<Boolean> dualChannel = Optional.empty();
        private Optional<Boolean> formatText = Optional.empty();
        private Optional<Boolean> punctuate = Optional.empty();
        private Optional<Double> audioDuration = Optional.empty();
        private Optional<Double> confidence = Optional.empty();
        private Optional<List<TranscriptUtterance>> utterances = Optional.empty();
        private Optional<List<TranscriptWord>> words = Optional.empty();
        private Optional<String> text = Optional.empty();
        private Optional<TranscriptLanguageCode> languageCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Transcript other) {
            this.id(other.getId());
            this.languageModel(other.getLanguageModel());
            this.acousticModel(other.getAcousticModel());
            this.status(other.getStatus());
            this.languageCode(other.getLanguageCode());
            this.audioUrl(other.getAudioUrl());
            this.text(other.getText());
            this.words(other.getWords());
            this.utterances(other.getUtterances());
            this.confidence(other.getConfidence());
            this.audioDuration(other.getAudioDuration());
            this.punctuate(other.getPunctuate());
            this.formatText(other.getFormatText());
            this.dualChannel(other.getDualChannel());
            this.speechModel(other.getSpeechModel());
            this.webhookUrl(other.getWebhookUrl());
            this.webhookStatusCode(other.getWebhookStatusCode());
            this.webhookAuth(other.getWebhookAuth());
            this.webhookAuthHeaderName(other.getWebhookAuthHeaderName());
            this.speedBoost(other.getSpeedBoost());
            this.autoHighlights(other.getAutoHighlights());
            this.autoHighlightsResult(other.getAutoHighlightsResult());
            this.audioStartFrom(other.getAudioStartFrom());
            this.audioEndAt(other.getAudioEndAt());
            this.wordBoost(other.getWordBoost());
            this.boostParam(other.getBoostParam());
            this.filterProfanity(other.getFilterProfanity());
            this.redactPii(other.getRedactPii());
            this.redactPiiAudio(other.getRedactPiiAudio());
            this.redactPiiAudioQuality(other.getRedactPiiAudioQuality());
            this.redactPiiPolicies(other.getRedactPiiPolicies());
            this.redactPiiSub(other.getRedactPiiSub());
            this.speakerLabels(other.getSpeakerLabels());
            this.speakersExpected(other.getSpeakersExpected());
            this.contentSafety(other.getContentSafety());
            this.contentSafetyLabels(other.getContentSafetyLabels());
            this.iabCategories(other.getIabCategories());
            this.iabCategoriesResult(other.getIabCategoriesResult());
            this.languageDetection(other.getLanguageDetection());
            this.customSpelling(other.getCustomSpelling());
            this.autoChapters(other.getAutoChapters());
            this.chapters(other.getChapters());
            this.summarization(other.getSummarization());
            this.summaryType(other.getSummaryType());
            this.summaryModel(other.getSummaryModel());
            this.summary(other.getSummary());
            this.customTopics(other.getCustomTopics());
            this.topics(other.getTopics());
            this.disfluencies(other.getDisfluencies());
            this.sentimentAnalysis(other.getSentimentAnalysis());
            this.sentimentAnalysisResults(other.getSentimentAnalysisResults());
            this.entityDetection(other.getEntityDetection());
            this.entities(other.getEntities());
            this.speechThreshold(other.getSpeechThreshold());
            this.throttled(other.getThrottled());
            this.error(other.getError());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LanguageModelStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="language_model")
        public AcousticModelStage languageModel(String languageModel) {
            this.languageModel = languageModel;
            return this;
        }

        @Override
        @JsonSetter(value="acoustic_model")
        public StatusStage acousticModel(String acousticModel) {
            this.acousticModel = acousticModel;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public AudioUrlStage status(TranscriptStatus status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="audio_url")
        public WebhookAuthStage audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        @Override
        @JsonSetter(value="webhook_auth")
        public AutoHighlightsStage webhookAuth(boolean webhookAuth) {
            this.webhookAuth = webhookAuth;
            return this;
        }

        @Override
        @JsonSetter(value="auto_highlights")
        public RedactPiiStage autoHighlights(boolean autoHighlights) {
            this.autoHighlights = autoHighlights;
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii")
        public SummarizationStage redactPii(boolean redactPii) {
            this.redactPii = redactPii;
            return this;
        }

        @Override
        @JsonSetter(value="summarization")
        public _FinalStage summarization(boolean summarization) {
            this.summarization = summarization;
            return this;
        }

        @Override
        public _FinalStage error(String error) {
            this.error = Optional.of(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage throttled(Boolean throttled) {
            this.throttled = Optional.of(throttled);
            return this;
        }

        @Override
        @JsonSetter(value="throttled", nulls=Nulls.SKIP)
        public _FinalStage throttled(Optional<Boolean> throttled) {
            this.throttled = throttled;
            return this;
        }

        @Override
        public _FinalStage speechThreshold(Double speechThreshold) {
            this.speechThreshold = Optional.of(speechThreshold);
            return this;
        }

        @Override
        @JsonSetter(value="speech_threshold", nulls=Nulls.SKIP)
        public _FinalStage speechThreshold(Optional<Double> speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        @Override
        public _FinalStage entities(List<Entity> entities) {
            this.entities = Optional.of(entities);
            return this;
        }

        @Override
        @JsonSetter(value="entities", nulls=Nulls.SKIP)
        public _FinalStage entities(Optional<List<Entity>> entities) {
            this.entities = entities;
            return this;
        }

        @Override
        public _FinalStage entityDetection(Boolean entityDetection) {
            this.entityDetection = Optional.of(entityDetection);
            return this;
        }

        @Override
        @JsonSetter(value="entity_detection", nulls=Nulls.SKIP)
        public _FinalStage entityDetection(Optional<Boolean> entityDetection) {
            this.entityDetection = entityDetection;
            return this;
        }

        @Override
        public _FinalStage sentimentAnalysisResults(List<SentimentAnalysisResult> sentimentAnalysisResults) {
            this.sentimentAnalysisResults = Optional.of(sentimentAnalysisResults);
            return this;
        }

        @Override
        @JsonSetter(value="sentiment_analysis_results", nulls=Nulls.SKIP)
        public _FinalStage sentimentAnalysisResults(Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults) {
            this.sentimentAnalysisResults = sentimentAnalysisResults;
            return this;
        }

        @Override
        public _FinalStage sentimentAnalysis(Boolean sentimentAnalysis) {
            this.sentimentAnalysis = Optional.of(sentimentAnalysis);
            return this;
        }

        @Override
        @JsonSetter(value="sentiment_analysis", nulls=Nulls.SKIP)
        public _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        @Override
        public _FinalStage disfluencies(Boolean disfluencies) {
            this.disfluencies = Optional.of(disfluencies);
            return this;
        }

        @Override
        @JsonSetter(value="disfluencies", nulls=Nulls.SKIP)
        public _FinalStage disfluencies(Optional<Boolean> disfluencies) {
            this.disfluencies = disfluencies;
            return this;
        }

        @Override
        public _FinalStage topics(List<String> topics) {
            this.topics = Optional.of(topics);
            return this;
        }

        @Override
        @JsonSetter(value="topics", nulls=Nulls.SKIP)
        public _FinalStage topics(Optional<List<String>> topics) {
            this.topics = topics;
            return this;
        }

        @Override
        public _FinalStage customTopics(Boolean customTopics) {
            this.customTopics = Optional.of(customTopics);
            return this;
        }

        @Override
        @JsonSetter(value="custom_topics", nulls=Nulls.SKIP)
        public _FinalStage customTopics(Optional<Boolean> customTopics) {
            this.customTopics = customTopics;
            return this;
        }

        @Override
        public _FinalStage summary(String summary) {
            this.summary = Optional.of(summary);
            return this;
        }

        @Override
        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public _FinalStage summary(Optional<String> summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public _FinalStage summaryModel(String summaryModel) {
            this.summaryModel = Optional.of(summaryModel);
            return this;
        }

        @Override
        @JsonSetter(value="summary_model", nulls=Nulls.SKIP)
        public _FinalStage summaryModel(Optional<String> summaryModel) {
            this.summaryModel = summaryModel;
            return this;
        }

        @Override
        public _FinalStage summaryType(String summaryType) {
            this.summaryType = Optional.of(summaryType);
            return this;
        }

        @Override
        @JsonSetter(value="summary_type", nulls=Nulls.SKIP)
        public _FinalStage summaryType(Optional<String> summaryType) {
            this.summaryType = summaryType;
            return this;
        }

        @Override
        public _FinalStage chapters(List<Chapter> chapters) {
            this.chapters = Optional.of(chapters);
            return this;
        }

        @Override
        @JsonSetter(value="chapters", nulls=Nulls.SKIP)
        public _FinalStage chapters(Optional<List<Chapter>> chapters) {
            this.chapters = chapters;
            return this;
        }

        @Override
        public _FinalStage autoChapters(Boolean autoChapters) {
            this.autoChapters = Optional.of(autoChapters);
            return this;
        }

        @Override
        @JsonSetter(value="auto_chapters", nulls=Nulls.SKIP)
        public _FinalStage autoChapters(Optional<Boolean> autoChapters) {
            this.autoChapters = autoChapters;
            return this;
        }

        @Override
        public _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling) {
            this.customSpelling = Optional.of(customSpelling);
            return this;
        }

        @Override
        @JsonSetter(value="custom_spelling", nulls=Nulls.SKIP)
        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling) {
            this.customSpelling = customSpelling;
            return this;
        }

        @Override
        public _FinalStage languageDetection(Boolean languageDetection) {
            this.languageDetection = Optional.of(languageDetection);
            return this;
        }

        @Override
        @JsonSetter(value="language_detection", nulls=Nulls.SKIP)
        public _FinalStage languageDetection(Optional<Boolean> languageDetection) {
            this.languageDetection = languageDetection;
            return this;
        }

        @Override
        public _FinalStage iabCategoriesResult(TopicDetectionModelResult iabCategoriesResult) {
            this.iabCategoriesResult = Optional.of(iabCategoriesResult);
            return this;
        }

        @Override
        @JsonSetter(value="iab_categories_result", nulls=Nulls.SKIP)
        public _FinalStage iabCategoriesResult(Optional<TopicDetectionModelResult> iabCategoriesResult) {
            this.iabCategoriesResult = iabCategoriesResult;
            return this;
        }

        @Override
        public _FinalStage iabCategories(Boolean iabCategories) {
            this.iabCategories = Optional.of(iabCategories);
            return this;
        }

        @Override
        @JsonSetter(value="iab_categories", nulls=Nulls.SKIP)
        public _FinalStage iabCategories(Optional<Boolean> iabCategories) {
            this.iabCategories = iabCategories;
            return this;
        }

        @Override
        public _FinalStage contentSafetyLabels(ContentSafetyLabelsResult contentSafetyLabels) {
            this.contentSafetyLabels = Optional.of(contentSafetyLabels);
            return this;
        }

        @Override
        @JsonSetter(value="content_safety_labels", nulls=Nulls.SKIP)
        public _FinalStage contentSafetyLabels(Optional<ContentSafetyLabelsResult> contentSafetyLabels) {
            this.contentSafetyLabels = contentSafetyLabels;
            return this;
        }

        @Override
        public _FinalStage contentSafety(Boolean contentSafety) {
            this.contentSafety = Optional.of(contentSafety);
            return this;
        }

        @Override
        @JsonSetter(value="content_safety", nulls=Nulls.SKIP)
        public _FinalStage contentSafety(Optional<Boolean> contentSafety) {
            this.contentSafety = contentSafety;
            return this;
        }

        @Override
        public _FinalStage speakersExpected(Integer speakersExpected) {
            this.speakersExpected = Optional.of(speakersExpected);
            return this;
        }

        @Override
        @JsonSetter(value="speakers_expected", nulls=Nulls.SKIP)
        public _FinalStage speakersExpected(Optional<Integer> speakersExpected) {
            this.speakersExpected = speakersExpected;
            return this;
        }

        @Override
        public _FinalStage speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = Optional.of(speakerLabels);
            return this;
        }

        @Override
        @JsonSetter(value="speaker_labels", nulls=Nulls.SKIP)
        public _FinalStage speakerLabels(Optional<Boolean> speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        @Override
        public _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub) {
            this.redactPiiSub = Optional.of(redactPiiSub);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_sub", nulls=Nulls.SKIP)
        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub) {
            this.redactPiiSub = redactPiiSub;
            return this;
        }

        @Override
        public _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies) {
            this.redactPiiPolicies = Optional.of(redactPiiPolicies);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_policies", nulls=Nulls.SKIP)
        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies) {
            this.redactPiiPolicies = redactPiiPolicies;
            return this;
        }

        @Override
        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality) {
            this.redactPiiAudioQuality = Optional.of(redactPiiAudioQuality);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_audio_quality", nulls=Nulls.SKIP)
        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality) {
            this.redactPiiAudioQuality = redactPiiAudioQuality;
            return this;
        }

        @Override
        public _FinalStage redactPiiAudio(Boolean redactPiiAudio) {
            this.redactPiiAudio = Optional.of(redactPiiAudio);
            return this;
        }

        @Override
        @JsonSetter(value="redact_pii_audio", nulls=Nulls.SKIP)
        public _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio) {
            this.redactPiiAudio = redactPiiAudio;
            return this;
        }

        @Override
        public _FinalStage filterProfanity(Boolean filterProfanity) {
            this.filterProfanity = Optional.of(filterProfanity);
            return this;
        }

        @Override
        @JsonSetter(value="filter_profanity", nulls=Nulls.SKIP)
        public _FinalStage filterProfanity(Optional<Boolean> filterProfanity) {
            this.filterProfanity = filterProfanity;
            return this;
        }

        @Override
        public _FinalStage boostParam(String boostParam) {
            this.boostParam = Optional.of(boostParam);
            return this;
        }

        @Override
        @JsonSetter(value="boost_param", nulls=Nulls.SKIP)
        public _FinalStage boostParam(Optional<String> boostParam) {
            this.boostParam = boostParam;
            return this;
        }

        @Override
        public _FinalStage wordBoost(List<String> wordBoost) {
            this.wordBoost = Optional.of(wordBoost);
            return this;
        }

        @Override
        @JsonSetter(value="word_boost", nulls=Nulls.SKIP)
        public _FinalStage wordBoost(Optional<List<String>> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        @Override
        public _FinalStage audioEndAt(Integer audioEndAt) {
            this.audioEndAt = Optional.of(audioEndAt);
            return this;
        }

        @Override
        @JsonSetter(value="audio_end_at", nulls=Nulls.SKIP)
        public _FinalStage audioEndAt(Optional<Integer> audioEndAt) {
            this.audioEndAt = audioEndAt;
            return this;
        }

        @Override
        public _FinalStage audioStartFrom(Integer audioStartFrom) {
            this.audioStartFrom = Optional.of(audioStartFrom);
            return this;
        }

        @Override
        @JsonSetter(value="audio_start_from", nulls=Nulls.SKIP)
        public _FinalStage audioStartFrom(Optional<Integer> audioStartFrom) {
            this.audioStartFrom = audioStartFrom;
            return this;
        }

        @Override
        public _FinalStage autoHighlightsResult(AutoHighlightsResult autoHighlightsResult) {
            this.autoHighlightsResult = Optional.of(autoHighlightsResult);
            return this;
        }

        @Override
        @JsonSetter(value="auto_highlights_result", nulls=Nulls.SKIP)
        public _FinalStage autoHighlightsResult(Optional<AutoHighlightsResult> autoHighlightsResult) {
            this.autoHighlightsResult = autoHighlightsResult;
            return this;
        }

        @Override
        public _FinalStage speedBoost(Boolean speedBoost) {
            this.speedBoost = Optional.of(speedBoost);
            return this;
        }

        @Override
        @JsonSetter(value="speed_boost", nulls=Nulls.SKIP)
        public _FinalStage speedBoost(Optional<Boolean> speedBoost) {
            this.speedBoost = speedBoost;
            return this;
        }

        @Override
        public _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName) {
            this.webhookAuthHeaderName = Optional.of(webhookAuthHeaderName);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_auth_header_name", nulls=Nulls.SKIP)
        public _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName) {
            this.webhookAuthHeaderName = webhookAuthHeaderName;
            return this;
        }

        @Override
        public _FinalStage webhookStatusCode(Integer webhookStatusCode) {
            this.webhookStatusCode = Optional.of(webhookStatusCode);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_status_code", nulls=Nulls.SKIP)
        public _FinalStage webhookStatusCode(Optional<Integer> webhookStatusCode) {
            this.webhookStatusCode = webhookStatusCode;
            return this;
        }

        @Override
        public _FinalStage webhookUrl(String webhookUrl) {
            this.webhookUrl = Optional.of(webhookUrl);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_url", nulls=Nulls.SKIP)
        public _FinalStage webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        @Override
        public _FinalStage speechModel(SpeechModel speechModel) {
            this.speechModel = Optional.of(speechModel);
            return this;
        }

        @Override
        @JsonSetter(value="speech_model", nulls=Nulls.SKIP)
        public _FinalStage speechModel(Optional<SpeechModel> speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        @Override
        public _FinalStage dualChannel(Boolean dualChannel) {
            this.dualChannel = Optional.of(dualChannel);
            return this;
        }

        @Override
        @JsonSetter(value="dual_channel", nulls=Nulls.SKIP)
        public _FinalStage dualChannel(Optional<Boolean> dualChannel) {
            this.dualChannel = dualChannel;
            return this;
        }

        @Override
        public _FinalStage formatText(Boolean formatText) {
            this.formatText = Optional.of(formatText);
            return this;
        }

        @Override
        @JsonSetter(value="format_text", nulls=Nulls.SKIP)
        public _FinalStage formatText(Optional<Boolean> formatText) {
            this.formatText = formatText;
            return this;
        }

        @Override
        public _FinalStage punctuate(Boolean punctuate) {
            this.punctuate = Optional.of(punctuate);
            return this;
        }

        @Override
        @JsonSetter(value="punctuate", nulls=Nulls.SKIP)
        public _FinalStage punctuate(Optional<Boolean> punctuate) {
            this.punctuate = punctuate;
            return this;
        }

        @Override
        public _FinalStage audioDuration(Double audioDuration) {
            this.audioDuration = Optional.of(audioDuration);
            return this;
        }

        @Override
        @JsonSetter(value="audio_duration", nulls=Nulls.SKIP)
        public _FinalStage audioDuration(Optional<Double> audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public _FinalStage confidence(Double confidence) {
            this.confidence = Optional.of(confidence);
            return this;
        }

        @Override
        @JsonSetter(value="confidence", nulls=Nulls.SKIP)
        public _FinalStage confidence(Optional<Double> confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage utterances(List<TranscriptUtterance> utterances) {
            this.utterances = Optional.of(utterances);
            return this;
        }

        @Override
        @JsonSetter(value="utterances", nulls=Nulls.SKIP)
        public _FinalStage utterances(Optional<List<TranscriptUtterance>> utterances) {
            this.utterances = utterances;
            return this;
        }

        @Override
        public _FinalStage words(List<TranscriptWord> words) {
            this.words = Optional.of(words);
            return this;
        }

        @Override
        @JsonSetter(value="words", nulls=Nulls.SKIP)
        public _FinalStage words(Optional<List<TranscriptWord>> words) {
            this.words = words;
            return this;
        }

        @Override
        public _FinalStage text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @Override
        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public _FinalStage text(Optional<String> text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage languageCode(TranscriptLanguageCode languageCode) {
            this.languageCode = Optional.of(languageCode);
            return this;
        }

        @Override
        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public Transcript build() {
            return new Transcript(this.id, this.languageModel, this.acousticModel, this.status, this.languageCode, this.audioUrl, this.text, this.words, this.utterances, this.confidence, this.audioDuration, this.punctuate, this.formatText, this.dualChannel, this.speechModel, this.webhookUrl, this.webhookStatusCode, this.webhookAuth, this.webhookAuthHeaderName, this.speedBoost, this.autoHighlights, this.autoHighlightsResult, this.audioStartFrom, this.audioEndAt, this.wordBoost, this.boostParam, this.filterProfanity, this.redactPii, this.redactPiiAudio, this.redactPiiAudioQuality, this.redactPiiPolicies, this.redactPiiSub, this.speakerLabels, this.speakersExpected, this.contentSafety, this.contentSafetyLabels, this.iabCategories, this.iabCategoriesResult, this.languageDetection, this.customSpelling, this.autoChapters, this.chapters, this.summarization, this.summaryType, this.summaryModel, this.summary, this.customTopics, this.topics, this.disfluencies, this.sentimentAnalysis, this.sentimentAnalysisResults, this.entityDetection, this.entities, this.speechThreshold, this.throttled, this.error, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Transcript build();

        public _FinalStage languageCode(Optional<TranscriptLanguageCode> var1);

        public _FinalStage languageCode(TranscriptLanguageCode var1);

        public _FinalStage text(Optional<String> var1);

        public _FinalStage text(String var1);

        public _FinalStage words(Optional<List<TranscriptWord>> var1);

        public _FinalStage words(List<TranscriptWord> var1);

        public _FinalStage utterances(Optional<List<TranscriptUtterance>> var1);

        public _FinalStage utterances(List<TranscriptUtterance> var1);

        public _FinalStage confidence(Optional<Double> var1);

        public _FinalStage confidence(Double var1);

        public _FinalStage audioDuration(Optional<Double> var1);

        public _FinalStage audioDuration(Double var1);

        public _FinalStage punctuate(Optional<Boolean> var1);

        public _FinalStage punctuate(Boolean var1);

        public _FinalStage formatText(Optional<Boolean> var1);

        public _FinalStage formatText(Boolean var1);

        public _FinalStage dualChannel(Optional<Boolean> var1);

        public _FinalStage dualChannel(Boolean var1);

        public _FinalStage speechModel(Optional<SpeechModel> var1);

        public _FinalStage speechModel(SpeechModel var1);

        public _FinalStage webhookUrl(Optional<String> var1);

        public _FinalStage webhookUrl(String var1);

        public _FinalStage webhookStatusCode(Optional<Integer> var1);

        public _FinalStage webhookStatusCode(Integer var1);

        public _FinalStage webhookAuthHeaderName(Optional<String> var1);

        public _FinalStage webhookAuthHeaderName(String var1);

        public _FinalStage speedBoost(Optional<Boolean> var1);

        public _FinalStage speedBoost(Boolean var1);

        public _FinalStage autoHighlightsResult(Optional<AutoHighlightsResult> var1);

        public _FinalStage autoHighlightsResult(AutoHighlightsResult var1);

        public _FinalStage audioStartFrom(Optional<Integer> var1);

        public _FinalStage audioStartFrom(Integer var1);

        public _FinalStage audioEndAt(Optional<Integer> var1);

        public _FinalStage audioEndAt(Integer var1);

        public _FinalStage wordBoost(Optional<List<String>> var1);

        public _FinalStage wordBoost(List<String> var1);

        public _FinalStage boostParam(Optional<String> var1);

        public _FinalStage boostParam(String var1);

        public _FinalStage filterProfanity(Optional<Boolean> var1);

        public _FinalStage filterProfanity(Boolean var1);

        public _FinalStage redactPiiAudio(Optional<Boolean> var1);

        public _FinalStage redactPiiAudio(Boolean var1);

        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> var1);

        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality var1);

        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> var1);

        public _FinalStage redactPiiPolicies(List<PiiPolicy> var1);

        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> var1);

        public _FinalStage redactPiiSub(SubstitutionPolicy var1);

        public _FinalStage speakerLabels(Optional<Boolean> var1);

        public _FinalStage speakerLabels(Boolean var1);

        public _FinalStage speakersExpected(Optional<Integer> var1);

        public _FinalStage speakersExpected(Integer var1);

        public _FinalStage contentSafety(Optional<Boolean> var1);

        public _FinalStage contentSafety(Boolean var1);

        public _FinalStage contentSafetyLabels(Optional<ContentSafetyLabelsResult> var1);

        public _FinalStage contentSafetyLabels(ContentSafetyLabelsResult var1);

        public _FinalStage iabCategories(Optional<Boolean> var1);

        public _FinalStage iabCategories(Boolean var1);

        public _FinalStage iabCategoriesResult(Optional<TopicDetectionModelResult> var1);

        public _FinalStage iabCategoriesResult(TopicDetectionModelResult var1);

        public _FinalStage languageDetection(Optional<Boolean> var1);

        public _FinalStage languageDetection(Boolean var1);

        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> var1);

        public _FinalStage customSpelling(List<TranscriptCustomSpelling> var1);

        public _FinalStage autoChapters(Optional<Boolean> var1);

        public _FinalStage autoChapters(Boolean var1);

        public _FinalStage chapters(Optional<List<Chapter>> var1);

        public _FinalStage chapters(List<Chapter> var1);

        public _FinalStage summaryType(Optional<String> var1);

        public _FinalStage summaryType(String var1);

        public _FinalStage summaryModel(Optional<String> var1);

        public _FinalStage summaryModel(String var1);

        public _FinalStage summary(Optional<String> var1);

        public _FinalStage summary(String var1);

        public _FinalStage customTopics(Optional<Boolean> var1);

        public _FinalStage customTopics(Boolean var1);

        public _FinalStage topics(Optional<List<String>> var1);

        public _FinalStage topics(List<String> var1);

        public _FinalStage disfluencies(Optional<Boolean> var1);

        public _FinalStage disfluencies(Boolean var1);

        public _FinalStage sentimentAnalysis(Optional<Boolean> var1);

        public _FinalStage sentimentAnalysis(Boolean var1);

        public _FinalStage sentimentAnalysisResults(Optional<List<SentimentAnalysisResult>> var1);

        public _FinalStage sentimentAnalysisResults(List<SentimentAnalysisResult> var1);

        public _FinalStage entityDetection(Optional<Boolean> var1);

        public _FinalStage entityDetection(Boolean var1);

        public _FinalStage entities(Optional<List<Entity>> var1);

        public _FinalStage entities(List<Entity> var1);

        public _FinalStage speechThreshold(Optional<Double> var1);

        public _FinalStage speechThreshold(Double var1);

        public _FinalStage throttled(Optional<Boolean> var1);

        public _FinalStage throttled(Boolean var1);

        public _FinalStage error(Optional<String> var1);

        public _FinalStage error(String var1);
    }

    public static interface SummarizationStage {
        public _FinalStage summarization(boolean var1);
    }

    public static interface RedactPiiStage {
        public SummarizationStage redactPii(boolean var1);
    }

    public static interface AutoHighlightsStage {
        public RedactPiiStage autoHighlights(boolean var1);
    }

    public static interface WebhookAuthStage {
        public AutoHighlightsStage webhookAuth(boolean var1);
    }

    public static interface AudioUrlStage {
        public WebhookAuthStage audioUrl(String var1);
    }

    public static interface StatusStage {
        public AudioUrlStage status(TranscriptStatus var1);
    }

    public static interface AcousticModelStage {
        public StatusStage acousticModel(String var1);
    }

    public static interface LanguageModelStage {
        public AcousticModelStage languageModel(String var1);
    }

    public static interface IdStage {
        public LanguageModelStage id(String var1);

        public Builder from(Transcript var1);
    }
}

