/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TranscriptWord {
    private final double confidence;
    private final int start;
    private final int end;
    private final String text;
    private final Optional<String> speaker;
    private final Map<String, Object> additionalProperties;

    private TranscriptWord(double confidence, int start, int end, String text, Optional<String> speaker, Map<String, Object> additionalProperties) {
        this.confidence = confidence;
        this.start = start;
        this.end = end;
        this.text = text;
        this.speaker = speaker;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="speaker")
    public Optional<String> getSpeaker() {
        return this.speaker;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptWord && this.equalTo((TranscriptWord)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptWord other) {
        return this.confidence == other.confidence && this.start == other.start && this.end == other.end && this.text.equals(other.text) && this.speaker.equals(other.speaker);
    }

    public int hashCode() {
        return Objects.hash(this.confidence, this.start, this.end, this.text, this.speaker);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConfidenceStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConfidenceStage,
    StartStage,
    EndStage,
    TextStage,
    _FinalStage {
        private double confidence;
        private int start;
        private int end;
        private String text;
        private Optional<String> speaker = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TranscriptWord other) {
            this.confidence(other.getConfidence());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.text(other.getText());
            this.speaker(other.getSpeaker());
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public StartStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public TextStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public _FinalStage speaker(String speaker) {
            this.speaker = Optional.of(speaker);
            return this;
        }

        @Override
        @JsonSetter(value="speaker", nulls=Nulls.SKIP)
        public _FinalStage speaker(Optional<String> speaker) {
            this.speaker = speaker;
            return this;
        }

        @Override
        public TranscriptWord build() {
            return new TranscriptWord(this.confidence, this.start, this.end, this.text, this.speaker, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TranscriptWord build();

        public _FinalStage speaker(Optional<String> var1);

        public _FinalStage speaker(String var1);
    }

    public static interface TextStage {
        public _FinalStage text(String var1);
    }

    public static interface EndStage {
        public TextStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);
    }

    public static interface ConfidenceStage {
        public StartStage confidence(double var1);

        public Builder from(TranscriptWord var1);
    }
}

