/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api;

import com.assemblyai.api.AssemblyAIBuilder;
import com.assemblyai.api.PollingTranscriptsClient;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.Suppliers;
import com.assemblyai.api.resources.files.FilesClient;
import com.assemblyai.api.resources.lemur.LemurClient;
import com.assemblyai.api.resources.realtime.RealtimeClient;
import java.util.function.Supplier;

public class AssemblyAI {
    protected final ClientOptions clientOptions;
    protected final Supplier<FilesClient> filesClient;
    protected final Supplier<PollingTranscriptsClient> transcriptClient;
    protected final Supplier<RealtimeClient> realtimeClient;
    protected final Supplier<LemurClient> lemurClient;

    public AssemblyAI(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.filesClient = Suppliers.memoize(() -> new FilesClient(clientOptions));
        this.transcriptClient = Suppliers.memoize(() -> new PollingTranscriptsClient(clientOptions, this));
        this.realtimeClient = Suppliers.memoize(() -> new RealtimeClient(clientOptions));
        this.lemurClient = Suppliers.memoize(() -> new LemurClient(clientOptions));
    }

    public AssemblyAI(ClientOptions clientOptions, ClientOptions lemurClientOptions) {
        this.clientOptions = clientOptions;
        this.filesClient = Suppliers.memoize(() -> new FilesClient(clientOptions));
        this.transcriptClient = Suppliers.memoize(() -> new PollingTranscriptsClient(clientOptions, this));
        this.realtimeClient = Suppliers.memoize(() -> new RealtimeClient(clientOptions));
        this.lemurClient = Suppliers.memoize(() -> new LemurClient(lemurClientOptions));
    }

    public FilesClient files() {
        return this.filesClient.get();
    }

    public PollingTranscriptsClient transcripts() {
        return this.transcriptClient.get();
    }

    public RealtimeClient realtime() {
        return this.realtimeClient.get();
    }

    public LemurClient lemur() {
        return this.lemurClient.get();
    }

    public static AssemblyAIBuilder builder() {
        return new AssemblyAIBuilder();
    }
}

