/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.TranscriptSentence;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SentencesResponse {
    private final String id;
    private final double confidence;
    private final int audioDuration;
    private final List<TranscriptSentence> sentences;
    private final Map<String, Object> additionalProperties;

    private SentencesResponse(String id, double confidence, int audioDuration, List<TranscriptSentence> sentences, Map<String, Object> additionalProperties) {
        this.id = id;
        this.confidence = confidence;
        this.audioDuration = audioDuration;
        this.sentences = sentences;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="audio_duration")
    public int getAudioDuration() {
        return this.audioDuration;
    }

    @JsonProperty(value="sentences")
    public List<TranscriptSentence> getSentences() {
        return this.sentences;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SentencesResponse && this.equalTo((SentencesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SentencesResponse other) {
        return this.id.equals(other.id) && this.confidence == other.confidence && this.audioDuration == other.audioDuration && this.sentences.equals(other.sentences);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.confidence, this.audioDuration, this.sentences);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ConfidenceStage,
    AudioDurationStage,
    _FinalStage {
        private String id;
        private double confidence;
        private int audioDuration;
        private List<TranscriptSentence> sentences = new ArrayList<TranscriptSentence>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SentencesResponse other) {
            this.id(other.getId());
            this.confidence(other.getConfidence());
            this.audioDuration(other.getAudioDuration());
            this.sentences(other.getSentences());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ConfidenceStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="confidence")
        public AudioDurationStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        @JsonSetter(value="audio_duration")
        public _FinalStage audioDuration(int audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public _FinalStage addAllSentences(List<TranscriptSentence> sentences) {
            this.sentences.addAll(sentences);
            return this;
        }

        @Override
        public _FinalStage addSentences(TranscriptSentence sentences) {
            this.sentences.add(sentences);
            return this;
        }

        @Override
        @JsonSetter(value="sentences", nulls=Nulls.SKIP)
        public _FinalStage sentences(List<TranscriptSentence> sentences) {
            this.sentences.clear();
            this.sentences.addAll(sentences);
            return this;
        }

        @Override
        public SentencesResponse build() {
            return new SentencesResponse(this.id, this.confidence, this.audioDuration, this.sentences, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SentencesResponse build();

        public _FinalStage sentences(List<TranscriptSentence> var1);

        public _FinalStage addSentences(TranscriptSentence var1);

        public _FinalStage addAllSentences(List<TranscriptSentence> var1);
    }

    public static interface AudioDurationStage {
        public _FinalStage audioDuration(int var1);
    }

    public static interface ConfidenceStage {
        public AudioDurationStage confidence(double var1);
    }

    public static interface IdStage {
        public ConfidenceStage id(String var1);

        public Builder from(SentencesResponse var1);
    }
}

