/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class Sentiment {
    public static final Sentiment NEUTRAL = new Sentiment(Value.NEUTRAL, "NEUTRAL");
    public static final Sentiment NEGATIVE = new Sentiment(Value.NEGATIVE, "NEGATIVE");
    public static final Sentiment POSITIVE = new Sentiment(Value.POSITIVE, "POSITIVE");
    private final Value value;
    private final String string;

    Sentiment(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Sentiment && this.string.equals(((Sentiment)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case NEUTRAL: {
                return visitor.visitNeutral();
            }
            case NEGATIVE: {
                return visitor.visitNegative();
            }
            case POSITIVE: {
                return visitor.visitPositive();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Sentiment valueOf(String value) {
        switch (value) {
            case "NEUTRAL": {
                return NEUTRAL;
            }
            case "NEGATIVE": {
                return NEGATIVE;
            }
            case "POSITIVE": {
                return POSITIVE;
            }
        }
        return new Sentiment(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPositive();

        public T visitNeutral();

        public T visitNegative();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        POSITIVE,
        NEUTRAL,
        NEGATIVE,
        UNKNOWN;

    }
}

