/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class SpeechModel {
    public static final SpeechModel NANO = new SpeechModel(Value.NANO, "nano");
    public static final SpeechModel BEST = new SpeechModel(Value.BEST, "best");
    @Deprecated
    public static final SpeechModel CONFORMER2 = new SpeechModel(Value.CONFORMER2, "conformer-2");
    private final Value value;
    private final String string;

    SpeechModel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpeechModel && this.string.equals(((SpeechModel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case NANO: {
                return visitor.visitNano();
            }
            case BEST: {
                return visitor.visitBest();
            }
            case CONFORMER2: {
                return visitor.visitConformer2();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SpeechModel valueOf(String value) {
        switch (value) {
            case "nano": {
                return NANO;
            }
            case "best": {
                return BEST;
            }
            case "conformer-2": {
                return CONFORMER2;
            }
        }
        return new SpeechModel(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitBest();

        public T visitNano();

        public T visitConformer2();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        BEST,
        NANO,
        CONFORMER2,
        UNKNOWN;

    }
}

