/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptStatus {
    public static final TranscriptStatus COMPLETED = new TranscriptStatus(Value.COMPLETED, "completed");
    public static final TranscriptStatus ERROR = new TranscriptStatus(Value.ERROR, "error");
    public static final TranscriptStatus QUEUED = new TranscriptStatus(Value.QUEUED, "queued");
    public static final TranscriptStatus PROCESSING = new TranscriptStatus(Value.PROCESSING, "processing");
    private final Value value;
    private final String string;

    TranscriptStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TranscriptStatus && this.string.equals(((TranscriptStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case ERROR: {
                return visitor.visitError();
            }
            case QUEUED: {
                return visitor.visitQueued();
            }
            case PROCESSING: {
                return visitor.visitProcessing();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TranscriptStatus valueOf(String value) {
        switch (value) {
            case "completed": {
                return COMPLETED;
            }
            case "error": {
                return ERROR;
            }
            case "queued": {
                return QUEUED;
            }
            case "processing": {
                return PROCESSING;
            }
        }
        return new TranscriptStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitQueued();

        public T visitProcessing();

        public T visitCompleted();

        public T visitError();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        QUEUED,
        PROCESSING,
        COMPLETED,
        ERROR,
        UNKNOWN;

    }
}

